/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.util.Map;
import java.util.function.BiFunction;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ParentTaskAssigningClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.reindex.AbstractAsyncBulkByScrollAction;
import org.elasticsearch.index.reindex.BulkByScrollParallelizationHelper;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.ParentBulkByScrollTask;
import org.elasticsearch.index.reindex.ScrollableHitSource;
import org.elasticsearch.index.reindex.UpdateByQueryAction;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.index.reindex.WorkingBulkByScrollTask;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportUpdateByQueryAction
extends HandledTransportAction<UpdateByQueryRequest, BulkByScrollResponse> {
    private final Client client;
    private final ScriptService scriptService;
    private final ClusterService clusterService;

    @Inject
    public TransportUpdateByQueryAction(Settings settings, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client, TransportService transportService, ScriptService scriptService, ClusterService clusterService) {
        super(settings, "indices:data/write/update/byquery", threadPool, transportService, actionFilters, indexNameExpressionResolver, UpdateByQueryRequest::new);
        this.client = client;
        this.scriptService = scriptService;
        this.clusterService = clusterService;
    }

    protected void doExecute(Task task, UpdateByQueryRequest request, ActionListener<BulkByScrollResponse> listener) {
        if (request.getSlices() > 1) {
            BulkByScrollParallelizationHelper.startSlices(this.client, this.taskManager, UpdateByQueryAction.INSTANCE, this.clusterService.localNode().getId(), (ParentBulkByScrollTask)task, request, listener);
        } else {
            ClusterState state = this.clusterService.state();
            ParentTaskAssigningClient client = new ParentTaskAssigningClient(this.client, this.clusterService.localNode(), task);
            new AsyncIndexBySearchAction((WorkingBulkByScrollTask)task, this.logger, client, this.threadPool, request, this.scriptService, state, listener).start();
        }
    }

    protected void doExecute(UpdateByQueryRequest request, ActionListener<BulkByScrollResponse> listener) {
        throw new UnsupportedOperationException("task required");
    }

    static class AsyncIndexBySearchAction
    extends AbstractAsyncBulkByScrollAction<UpdateByQueryRequest> {
        AsyncIndexBySearchAction(WorkingBulkByScrollTask task, Logger logger, ParentTaskAssigningClient client, ThreadPool threadPool, UpdateByQueryRequest request, ScriptService scriptService, ClusterState clusterState, ActionListener<BulkByScrollResponse> listener) {
            this(task, logger, client, threadPool, request, scriptService, clusterState, listener, client.settings());
        }

        AsyncIndexBySearchAction(WorkingBulkByScrollTask task, Logger logger, ParentTaskAssigningClient client, ThreadPool threadPool, UpdateByQueryRequest request, ScriptService scriptService, ClusterState clusterState, ActionListener<BulkByScrollResponse> listener, Settings settings) {
            super(task, logger, client, threadPool, request, scriptService, clusterState, listener, settings);
        }

        @Override
        protected boolean needsSourceDocumentVersions() {
            return true;
        }

        @Override
        public BiFunction<AbstractAsyncBulkByScrollAction.RequestWrapper<?>, ScrollableHitSource.Hit, AbstractAsyncBulkByScrollAction.RequestWrapper<?>> buildScriptApplier() {
            Script script = ((UpdateByQueryRequest)this.mainRequest).getScript();
            if (script != null) {
                return new UpdateByQueryScriptApplier(this.task, this.scriptService, script, (Map<String, Object>)script.getParams());
            }
            return super.buildScriptApplier();
        }

        @Override
        protected AbstractAsyncBulkByScrollAction.RequestWrapper<IndexRequest> buildRequest(ScrollableHitSource.Hit doc) {
            IndexRequest index = new IndexRequest();
            index.index(doc.getIndex());
            index.type(doc.getType());
            index.id(doc.getId());
            index.source(doc.getSource(), doc.getXContentType());
            index.versionType(VersionType.INTERNAL);
            index.version(doc.getVersion());
            index.setPipeline(((UpdateByQueryRequest)this.mainRequest).getPipeline());
            return AsyncIndexBySearchAction.wrap(index);
        }

        class UpdateByQueryScriptApplier
        extends AbstractAsyncBulkByScrollAction.ScriptApplier {
            UpdateByQueryScriptApplier(WorkingBulkByScrollTask task, ScriptService scriptService, Script script, Map<String, Object> params) {
                super(AsyncIndexBySearchAction.this, task, scriptService, script, params);
            }

            @Override
            protected void scriptChangedIndex(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, Object to) {
                throw new IllegalArgumentException("Modifying [_index] not allowed");
            }

            @Override
            protected void scriptChangedType(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, Object to) {
                throw new IllegalArgumentException("Modifying [_type] not allowed");
            }

            @Override
            protected void scriptChangedId(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, Object to) {
                throw new IllegalArgumentException("Modifying [_id] not allowed");
            }

            @Override
            protected void scriptChangedVersion(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, Object to) {
                throw new IllegalArgumentException("Modifying [_version] not allowed");
            }

            @Override
            protected void scriptChangedRouting(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, Object to) {
                throw new IllegalArgumentException("Modifying [_routing] not allowed");
            }

            @Override
            protected void scriptChangedParent(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, Object to) {
                throw new IllegalArgumentException("Modifying [_parent] not allowed");
            }
        }
    }
}

