/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.plugins;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.NonNullApi;
import org.gradle.api.Plugin;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.language.base.plugins.LifecycleBasePlugin;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.cpp.CppExecutable;
import org.gradle.language.cpp.CppSharedLibrary;
import org.gradle.language.cpp.internal.DefaultCppBinary;
import org.gradle.language.cpp.internal.DefaultCppExecutable;
import org.gradle.language.cpp.internal.DefaultCppSharedLibrary;
import org.gradle.language.cpp.tasks.CppCompile;
import org.gradle.language.nativeplatform.internal.Names;
import org.gradle.language.nativeplatform.tasks.Depend;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.tasks.InstallExecutable;
import org.gradle.nativeplatform.tasks.LinkExecutable;
import org.gradle.nativeplatform.tasks.LinkSharedLibrary;
import org.gradle.nativeplatform.toolchain.Clang;
import org.gradle.nativeplatform.toolchain.Gcc;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainRegistryInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.SystemIncludesAwarePlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.plugins.StandardToolChainsPlugin;
import org.gradle.platform.base.Platform;
import org.gradle.platform.base.ToolChain;

@Incubating
@NonNullApi
public class CppBasePlugin
implements Plugin<ProjectInternal> {
    public void apply(final ProjectInternal project) {
        project.getPluginManager().apply(LifecycleBasePlugin.class);
        project.getPluginManager().apply(StandardToolChainsPlugin.class);
        final TaskContainerInternal tasks = project.getTasks();
        final DirectoryProperty buildDirectory = project.getLayout().getBuildDirectory();
        final ModelRegistry modelRegistry = project.getModelRegistry();
        final ProviderFactory providers = project.getProviders();
        project.getGradle().getExperimentalFeatures().enable();
        project.getComponents().withType(CppBinary.class, (Action)new Action<CppBinary>(){

            public void execute(final CppBinary binary) {
                final Names names = Names.of(binary.getName());
                String language = "cpp";
                final DefaultNativePlatform currentPlatform = new DefaultNativePlatform("current");
                final NativeToolChain toolChain = (NativeToolChain)((NativeToolChainRegistryInternal)modelRegistry.realize("toolChains", NativeToolChainRegistryInternal.class)).getForPlatform((Platform)currentPlatform);
                Callable<List<File>> systemIncludes = new Callable<List<File>>(){

                    @Override
                    public List<File> call() throws Exception {
                        PlatformToolProvider platformToolProvider = ((NativeToolChainInternal)toolChain).select((NativePlatformInternal)currentPlatform);
                        if (platformToolProvider instanceof SystemIncludesAwarePlatformToolProvider) {
                            return ((SystemIncludesAwarePlatformToolProvider)platformToolProvider).getSystemIncludes();
                        }
                        return ImmutableList.of();
                    }
                };
                CppCompile compile = (CppCompile)tasks.create(names.getCompileTaskName(language), CppCompile.class);
                this.configureCompile(compile, binary, currentPlatform, toolChain, systemIncludes);
                compile.getObjectFileDir().set(buildDirectory.dir("obj/" + names.getDirName()));
                ((DefaultCppBinary)binary).getObjectsDir().set((Provider)compile.getObjectFileDir());
                Depend depend = (Depend)tasks.create(names.getDependTaskName(language), Depend.class);
                this.configureDepend(depend, binary, toolChain, systemIncludes);
                compile.getHeaderDependenciesFile().set((Provider)depend.getHeaderDependenciesFile());
                if (binary instanceof CppExecutable) {
                    LinkExecutable link = (LinkExecutable)tasks.create(names.getTaskName("link"), LinkExecutable.class);
                    link.source((Object)binary.getObjects());
                    link.lib((Object)binary.getLinkLibraries());
                    final PlatformToolProvider toolProvider = ((NativeToolChainInternal)toolChain).select((NativePlatformInternal)currentPlatform);
                    link.setOutputFile(buildDirectory.file(providers.provider((Callable)new Callable<String>(){

                        @Override
                        public String call() throws Exception {
                            return toolProvider.getExecutableName("exe/" + names.getDirName() + (String)binary.getBaseName().get());
                        }
                    })));
                    link.setTargetPlatform((NativePlatform)currentPlatform);
                    link.setToolChain(toolChain);
                    link.setDebuggable(binary.isDebuggable());
                    InstallExecutable install = (InstallExecutable)tasks.create(names.getTaskName("install"), InstallExecutable.class);
                    install.setPlatform(link.getTargetPlatform());
                    install.setToolChain((ToolChain)link.getToolChain());
                    install.getInstallDirectory().set(buildDirectory.dir("install/" + names.getDirName()));
                    install.getSourceFile().set((Provider)link.getBinaryFile());
                    install.lib((Object)binary.getRuntimeLibraries());
                    ((DefaultCppExecutable)binary).getExecutableFile().set((Provider)link.getBinaryFile());
                    ((DefaultCppExecutable)binary).getInstallDirectory().set((Provider)install.getInstallDirectory());
                } else if (binary instanceof CppSharedLibrary) {
                    final PlatformToolProvider toolProvider = ((NativeToolChainInternal)toolChain).select((NativePlatformInternal)currentPlatform);
                    compile.setPositionIndependentCode(true);
                    LinkSharedLibrary link = (LinkSharedLibrary)tasks.create(names.getTaskName("link"), LinkSharedLibrary.class);
                    link.source((Object)binary.getObjects());
                    link.lib((Object)binary.getLinkLibraries());
                    Provider runtimeFile = buildDirectory.file(providers.provider((Callable)new Callable<String>(){

                        @Override
                        public String call() {
                            return toolProvider.getSharedLibraryName("lib/" + names.getDirName() + (String)binary.getBaseName().get());
                        }
                    }));
                    link.getBinaryFile().set(runtimeFile);
                    link.setTargetPlatform((NativePlatform)currentPlatform);
                    link.setToolChain(toolChain);
                    link.setDebuggable(binary.isDebuggable());
                    RegularFileProperty linkFile = link.getBinaryFile();
                    if (toolProvider.producesImportLibrary()) {
                        Provider importLibrary = buildDirectory.file(providers.provider((Callable)new Callable<String>(){

                            @Override
                            public String call() {
                                return toolProvider.getImportLibraryName("lib/" + names.getDirName() + (String)binary.getBaseName().get());
                            }
                        }));
                        link.getImportLibrary().set(importLibrary);
                        linkFile = link.getImportLibrary();
                    }
                    ((DefaultCppSharedLibrary)binary).getRuntimeFile().set((Provider)link.getBinaryFile());
                    ((DefaultCppSharedLibrary)binary).getLinkFile().set((Provider)linkFile);
                }
            }

            private void configureCompile(CppCompile compile, CppBinary binary, DefaultNativePlatform currentPlatform, NativeToolChain toolChain, Callable<List<File>> systemIncludes) {
                compile.includes(binary.getCompileIncludePath());
                compile.includes(systemIncludes);
                compile.source(binary.getCppSource());
                if (binary.isDebuggable()) {
                    compile.setDebuggable(true);
                } else {
                    compile.setOptimized(true);
                }
                compile.setTargetPlatform((NativePlatform)currentPlatform);
                compile.setToolChain(toolChain);
            }

            private void configureDepend(Depend depend, CppBinary binary, NativeToolChain toolChain, Callable<List<File>> systemIncludesProvider) {
                depend.includes(binary.getCompileIncludePath());
                depend.includes(systemIncludesProvider);
                depend.source(binary.getCppSource());
                depend.getHeaderDependenciesFile().set(project.getLayout().getBuildDirectory().file(depend.getName() + "/" + "inputs.txt"));
                depend.getImportsAreIncludes().set((Object)(Clang.class.isAssignableFrom(toolChain.getClass()) || Gcc.class.isAssignableFrom(toolChain.getClass()) ? 1 : 0));
            }
        });
    }
}

