#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: QuickCheck
version: 2.10.1
id: QuickCheck-2.10.1-BUFYQzp5Pjm7JbQeTzW89l
key: QuickCheck-2.10.1-BUFYQzp5Pjm7JbQeTzW89l
license: BSD3
copyright: 2000-2017 Koen Claessen, 2006-2008 Björn Bringert, 2009-2017 Nick Smallbone
maintainer: Nick Smallbone <nick@smallbone.se>; see also QuickCheck mailing list (https://groups.google.com/forum/#!forum/haskell-quickcheck)
homepage: https://github.com/nick8325/quickcheck
synopsis: Automatic testing of Haskell programs
description:
    QuickCheck is a library for random testing of program properties.
    .
    The programmer provides a specification of the program, in the form of
    properties which functions should satisfy, and QuickCheck then tests that the
    properties hold in a large number of randomly generated cases.
    .
    Specifications are expressed in Haskell, using combinators defined in the
    QuickCheck library. QuickCheck provides combinators to define properties,
    observe the distribution of test data, and define test data generators.
    .
    The <http://www.cse.chalmers.se/~rjmh/QuickCheck/manual.html official QuickCheck manual>
    explains how to write generators and properties;
    it is out-of-date in some details but still full of useful advice.
    .
    A user of QuickCheck has written an unofficial, but detailed, tutorial which
    you can find at
    <https://begriffs.com/posts/2017-01-14-design-use-quickcheck.html>.
category: Testing
author: Koen Claessen <koen@chalmers.se>
exposed: True
indefinite: False
exposed-modules:
    Test.QuickCheck Test.QuickCheck.All Test.QuickCheck.Arbitrary
    Test.QuickCheck.Exception Test.QuickCheck.Function
    Test.QuickCheck.Gen Test.QuickCheck.Gen.Unsafe
    Test.QuickCheck.Modifiers Test.QuickCheck.Monadic
    Test.QuickCheck.Poly Test.QuickCheck.Property
    Test.QuickCheck.Random Test.QuickCheck.State Test.QuickCheck.Test
    Test.QuickCheck.Text
abi: a871331a7e5e7b5c37818b7997512ddd
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/QuickCheck-2.10.1
library-dirs: /usr/lib/ghc-8.2.2/site-local/QuickCheck-2.10.1
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.2/QuickCheck-2.10.1
hs-libraries: HSQuickCheck-2.10.1-BUFYQzp5Pjm7JbQeTzW89l
depends:
    base-4.10.1.0 random-1.1-LLUGZ7T9DqQ5vN0Jbcd0We containers-0.5.10.2
    transformers-0.5.2.0 deepseq-1.4.3.0 template-haskell-2.12.0.0
    tf-random-0.5-ABwehMmciu8CuAFbHLp6To
abi-depends: base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
             random-1.1-LLUGZ7T9DqQ5vN0Jbcd0We=368a9f817c8c1b290191231dd0d81d85
             containers-0.5.10.2=0f9db0d1b935cacba444aac19f4cb54d
             transformers-0.5.2.0=b5dee110a615d751493b7ce1c6f95946
             deepseq-1.4.3.0=e843b5d736cc095915bf2399fddf152e
             template-haskell-2.12.0.0=24d98a36b9e0dbd4d443161d478c05b2
             tf-random-0.5-ABwehMmciu8CuAFbHLp6To=375abfe9b23f7bb0563d2c2d4e64e49c
haddock-interfaces: /usr/share/doc/haskell-quickcheck/html/QuickCheck.haddock
haddock-html: /usr/share/doc/haskell-quickcheck/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

