#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: statistics
version: 0.14.0.2
id: statistics-0.14.0.2-GpLyT89gYaDEvGGFtYojWK
key: statistics-0.14.0.2-GpLyT89gYaDEvGGFtYojWK
license: BSD2
copyright: 2009-2014 Bryan O'\''Sullivan
maintainer: Bryan O'\''Sullivan <bos@serpentine.com>
homepage: https://github.com/bos/statistics
synopsis: A library of statistical types, data, and functions
description:
    This library provides a number of common functions and types useful
    in statistics.  We focus on high performance, numerical robustness,
    and use of good algorithms.  Where possible, we provide
    references to the statistical literature.
    .
    The library'\''s facilities can be divided into four broad categories:
    .
    * Working with widely used discrete and continuous probability
    distributions.  (There are dozens of exotic distributions in use;
    we focus on the most common.)
    .
    * Computing with sample data: quantile estimation, kernel density
    estimation, histograms, bootstrap methods, significance testing,
    and regression and autocorrelation analysis.
    .
    * Random variate generation under several different distributions.
    .
    * Common statistical tests for significant differences between
    samples.
category: Math, Statistics
author: Bryan O'\''Sullivan <bos@serpentine.com>
exposed: True
indefinite: False
exposed-modules:
    Statistics.Autocorrelation Statistics.ConfidenceInt
    Statistics.Correlation Statistics.Correlation.Kendall
    Statistics.Distribution Statistics.Distribution.Beta
    Statistics.Distribution.Binomial
    Statistics.Distribution.CauchyLorentz
    Statistics.Distribution.ChiSquared
    Statistics.Distribution.DiscreteUniform
    Statistics.Distribution.Exponential
    Statistics.Distribution.FDistribution Statistics.Distribution.Gamma
    Statistics.Distribution.Geometric
    Statistics.Distribution.Hypergeometric
    Statistics.Distribution.Laplace Statistics.Distribution.Normal
    Statistics.Distribution.Poisson Statistics.Distribution.StudentT
    Statistics.Distribution.Transform Statistics.Distribution.Uniform
    Statistics.Function Statistics.Math.RootFinding Statistics.Matrix
    Statistics.Matrix.Algorithms Statistics.Matrix.Mutable
    Statistics.Matrix.Types Statistics.Quantile Statistics.Regression
    Statistics.Resampling Statistics.Resampling.Bootstrap
    Statistics.Sample Statistics.Sample.Histogram
    Statistics.Sample.KernelDensity
    Statistics.Sample.KernelDensity.Simple Statistics.Sample.Powers
    Statistics.Test.ChiSquared Statistics.Test.KolmogorovSmirnov
    Statistics.Test.KruskalWallis Statistics.Test.MannWhitneyU
    Statistics.Test.StudentT Statistics.Test.Types
    Statistics.Test.WilcoxonT Statistics.Transform Statistics.Types
hidden-modules: Statistics.Distribution.Poisson.Internal
                Statistics.Function.Comparison Statistics.Internal
                Statistics.Sample.Internal Statistics.Test.Internal
                Statistics.Types.Internal
abi: fc8db35b8398dc3ffe19107b467109a7
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/statistics-0.14.0.2
library-dirs: /usr/lib/ghc-8.2.2/site-local/statistics-0.14.0.2
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.2/statistics-0.14.0.2
hs-libraries: HSstatistics-0.14.0.2-GpLyT89gYaDEvGGFtYojWK
depends:
    aeson-1.2.3.0-LNkLuLvRI8W9I8ocVQs80F base-4.10.1.0
    base-orphans-0.6-KoJqNefbvUAEuaR7CDOiu4 binary-0.8.5.1
    deepseq-1.4.3.0 erf-2.0.0.0-FIyUTQ0buYn83lNwX85oAb
    math-functions-0.2.1.0-Ffg2SR9VoXB36fZMhQmMl1
    monad-par-0.3.4.8-67wpl5GD5LKI0ysbGLZTVD
    mwc-random-0.13.6.0-3s7old0IIUJ6cNLUb7xtit
    primitive-0.6.2.0-EI3NK1Xfv9zEcRtyXK2EwZ
    vector-0.12.0.1-IUGn3M9mkBh8CyXcBnfTR4
    vector-algorithms-0.7.0.1-IlgMkkQzf7kBLgtLlabzVP
    vector-th-unbox-0.2.1.6-3P8JZRhyMmIHRdA9vtPCkD
    vector-binary-instances-0.2.3.5-88BjY2keX9S3iT3dJHxwKv
abi-depends: aeson-1.2.3.0-LNkLuLvRI8W9I8ocVQs80F=4c58219744f0571919d1814f029cc115
             base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
             base-orphans-0.6-KoJqNefbvUAEuaR7CDOiu4=fb09ffe63c021a5df200f5dd3f288699
             binary-0.8.5.1=33c677d3ced9a5afbc7b354509494653
             deepseq-1.4.3.0=e843b5d736cc095915bf2399fddf152e
             erf-2.0.0.0-FIyUTQ0buYn83lNwX85oAb=c963357379fde9f88d3366a8182a1c17
             math-functions-0.2.1.0-Ffg2SR9VoXB36fZMhQmMl1=9d6304e05f661e5168e3337087f2f469
             monad-par-0.3.4.8-67wpl5GD5LKI0ysbGLZTVD=4f8b6153ff22f291882886d5951f0e1f
             mwc-random-0.13.6.0-3s7old0IIUJ6cNLUb7xtit=8a92dd30e2d2110ac72ea0b168061fe2
             primitive-0.6.2.0-EI3NK1Xfv9zEcRtyXK2EwZ=8f45321f6a36e57e226bf2d17d6dafd0
             vector-0.12.0.1-IUGn3M9mkBh8CyXcBnfTR4=d8375a46a4155c3f449ce3d319b3dbaa
             vector-algorithms-0.7.0.1-IlgMkkQzf7kBLgtLlabzVP=20be0bc6e88cd27702622527898b03d0
             vector-th-unbox-0.2.1.6-3P8JZRhyMmIHRdA9vtPCkD=6cabeee69959d254ee1238e445d860d7
             vector-binary-instances-0.2.3.5-88BjY2keX9S3iT3dJHxwKv=e425ebe595a78443d5604d41c0c100ac
haddock-interfaces: /usr/share/doc/haskell-statistics/html/statistics.haddock
haddock-html: /usr/share/doc/haskell-statistics/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

