/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DeprecationResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eJ0\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH&\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageChecker;", "", "check", "", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "element", "Lcom/intellij/psi/PsiElement;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "deprecationResolver", "Lorg/jetbrains/kotlin/resolve/DeprecationResolver;", "Companion", "frontend"})
public interface ClassifierUsageChecker {
    public static final Companion Companion = org.jetbrains.kotlin.resolve.checkers.ClassifierUsageChecker$Companion.$$INSTANCE;

    public void check(@NotNull ClassifierDescriptor var1, @NotNull BindingTrace var2, @NotNull PsiElement var3, @NotNull LanguageVersionSettings var4, @NotNull DeprecationResolver var5);

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageChecker$Companion;", "", "()V", "check", "", "declarations", "", "Lcom/intellij/psi/PsiElement;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "deprecationResolver", "Lorg/jetbrains/kotlin/resolve/DeprecationResolver;", "checkers", "", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageChecker;", "frontend"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        public final void check(@NotNull Collection<? extends PsiElement> declarations, @NotNull BindingTrace trace, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull DeprecationResolver deprecationResolver, @NotNull Iterable<? extends ClassifierUsageChecker> checkers) {
            Intrinsics.checkParameterIsNotNull(declarations, "declarations");
            Intrinsics.checkParameterIsNotNull(trace, "trace");
            Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
            Intrinsics.checkParameterIsNotNull(deprecationResolver, "deprecationResolver");
            Intrinsics.checkParameterIsNotNull(checkers, "checkers");
            KtTreeVisitorVoid visitor2 = new KtTreeVisitorVoid(checkers, trace, languageVersionSettings, deprecationResolver){
                final /* synthetic */ Iterable $checkers;
                final /* synthetic */ BindingTrace $trace;
                final /* synthetic */ LanguageVersionSettings $languageVersionSettings;
                final /* synthetic */ DeprecationResolver $deprecationResolver;

                public void visitReferenceExpression(@NotNull KtReferenceExpression expression2) {
                    block4: {
                        ClassifierDescriptor classifierDescriptor;
                        Intrinsics.checkParameterIsNotNull(expression2, "expression");
                        super.visitReferenceExpression(expression2);
                        if (expression2 instanceof KtNameReferenceExpression && Intrinsics.areEqual(((KtNameReferenceExpression)expression2).getReferencedNameElementType(), KtTokens.SUPER_KEYWORD)) {
                            return;
                        }
                        ClassifierDescriptor classifierDescriptor2 = this.getReferencedClassifier(expression2);
                        if (classifierDescriptor2 == null) {
                            return;
                        }
                        ClassifierDescriptor target = classifierDescriptor2;
                        this.runCheckersWithTarget(target, expression2);
                        ClassifierDescriptor classifierDescriptor3 = this.getReferenceToCompanionViaClassifier(expression2, target);
                        if (classifierDescriptor3 == null) break block4;
                        ClassifierDescriptor referenceClassifier = classifierDescriptor = classifierDescriptor3;
                        DeclarationDescriptor declarationDescriptor = target.getContainingDeclaration();
                        if (declarationDescriptor == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                        }
                        ClassDescriptor outerClass2 = (ClassDescriptor)declarationDescriptor;
                        this.runCheckersWithTarget(outerClass2, expression2);
                        if (referenceClassifier instanceof TypeAliasDescriptor) {
                            this.runCheckersWithTarget(referenceClassifier, expression2);
                        }
                    }
                }

                private final void runCheckersWithTarget(ClassifierDescriptor target, KtReferenceExpression expression2) {
                    for (ClassifierUsageChecker checker : this.$checkers) {
                        checker.check(target, this.$trace, expression2, this.$languageVersionSettings, this.$deprecationResolver);
                    }
                }

                private final ClassifierDescriptor getReferencedClassifier(KtReferenceExpression expression2) {
                    Iterable $receiver$iv$iv;
                    Iterable $receiver$iv;
                    Collection targets;
                    ClassifierDescriptor target;
                    V v = this.$trace.get(BindingContext.REFERENCE_TARGET, expression2);
                    if (!(v instanceof ClassifierDescriptor)) {
                        v = null;
                    }
                    if ((target = (ClassifierDescriptor)v) != null) {
                        return target;
                    }
                    Collection collection = (Collection)this.$trace.get(BindingContext.AMBIGUOUS_REFERENCE_TARGET, expression2);
                    if (collection == null) {
                        return null;
                    }
                    Collection collection2 = targets = collection;
                    Intrinsics.checkExpressionValueIsNotNull(collection2, "targets");
                    Iterable iterable = $receiver$iv = (Iterable)collection2;
                    Object destination$iv$iv = new LinkedHashMap<K, V>();
                    for (T element$iv$iv : $receiver$iv$iv) {
                        Object object;
                        DeclarationDescriptor it = (DeclarationDescriptor)element$iv$iv;
                        DeclarationDescriptor declarationDescriptor = it;
                        if (!(declarationDescriptor instanceof DeclarationDescriptorWithSource)) {
                            declarationDescriptor = null;
                        }
                        DeclarationDescriptorWithSource declarationDescriptorWithSource = (DeclarationDescriptorWithSource)declarationDescriptor;
                        Object $receiver$iv$iv$iv = destination$iv$iv;
                        SourceElement key$iv$iv = declarationDescriptorWithSource != null ? declarationDescriptorWithSource.getSource() : null;
                        V value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
                        if (value$iv$iv$iv == null) {
                            ArrayList<E> answer$iv$iv$iv = new ArrayList<E>();
                            $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                            object = answer$iv$iv$iv;
                        } else {
                            object = value$iv$iv$iv;
                        }
                        List list$iv$iv = (List)object;
                        list$iv$iv.add(element$iv$iv);
                    }
                    if (destination$iv$iv.size() != 1) {
                        return null;
                    }
                    $receiver$iv$iv = $receiver$iv = (Iterable)targets;
                    destination$iv$iv = new ArrayList<E>();
                    for (T element$iv$iv : $receiver$iv$iv) {
                        if (!(element$iv$iv instanceof ClassifierDescriptor)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    return (ClassifierDescriptor)CollectionsKt.singleOrNull((List)destination$iv$iv);
                }

                private final ClassifierDescriptor getReferenceToCompanionViaClassifier(KtReferenceExpression expression2, ClassifierDescriptor target) {
                    if (!DescriptorUtils.isCompanionObject(target)) {
                        return null;
                    }
                    return (ClassifierDescriptor)this.$trace.get(BindingContext.SHORT_REFERENCE_TO_COMPANION_OBJECT, expression2);
                }
                {
                    this.$checkers = $captured_local_variable$0;
                    this.$trace = $captured_local_variable$1;
                    this.$languageVersionSettings = $captured_local_variable$2;
                    this.$deprecationResolver = $captured_local_variable$3;
                }
            };
            for (PsiElement psiElement : declarations) {
                psiElement.accept(visitor2);
            }
        }

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
        }
    }
}

