/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.URLUtil;
import java.net.MalformedURLException;
import java.net.URL;
import org.jetbrains.annotations.NotNull;

public class KotlinVfsUtil {
    @NotNull
    public static String convertFromUrl(@NotNull URL url) throws MalformedURLException {
        String protocol = url.getProtocol();
        String path2 = url.getPath();
        if ("jar".equals(protocol)) {
            if (StringUtil.startsWithConcatenationOf(path2, "file", ":")) {
                URL subURL = new URL(path2);
                path2 = subURL.getPath();
            } else {
                throw new MalformedURLException("Can't parse url: " + url.toExternalForm());
            }
        }
        if (SystemInfo.isWindows || SystemInfo.isOS2) {
            while (path2.length() > 0 && path2.charAt(0) == '/') {
                path2 = path2.substring(1, path2.length());
            }
        }
        path2 = URLUtil.unescapePercentSequences(path2);
        return protocol + "://" + path2;
    }

    private KotlinVfsUtil() {
    }
}

