#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: pandoc
version: 2.0.5
id: pandoc-2.0.5-91IyCZ1v9wdD446Sq76mIZ
key: pandoc-2.0.5-91IyCZ1v9wdD446Sq76mIZ
license: GPL
copyright: (c) 2006-2017 John MacFarlane
maintainer: John MacFarlane <jgm@berkeley.edu>
stability: alpha
homepage: http://pandoc.org
synopsis: Conversion between markup formats
description:
    Pandoc is a Haskell library for converting from one markup
    format to another, and a command-line tool that uses
    this library. It can read several dialects of Markdown and
    (subsets of) HTML, reStructuredText, LaTeX, DocBook,
    MediaWiki markup, TWiki markup, TikiWiki markup, Creole 1.0,
    Haddock markup, OPML, Emacs Org-Mode, Emacs Muse, txt2tags,
    Vimwiki, Word Docx, ODT, and Textile, and it can write
    Markdown, reStructuredText, XHTML, HTML 5, LaTeX, ConTeXt,
    DocBook, JATS, OPML, TEI, OpenDocument, ODT, Word docx,
    RTF, MediaWiki, DokuWiki, ZimWiki, Textile, groff man,
    groff ms, plain text, Emacs Org-Mode, AsciiDoc,
    Haddock markup, EPUB (v2 and v3), FictionBook2, InDesign
    ICML, Muse, LaTeX beamer slides, PowerPoint, and several
    kinds of HTML/JavaScript slide shows (S5, Slidy, Slideous,
    DZSlides, reveal.js).
    .
    In contrast to most existing tools for converting Markdown
    to HTML, pandoc has a modular design: it consists of a set of
    readers, which parse text in a given format and produce a
    native representation of the document, and a set of writers,
    which convert this native representation into a target
    format. Thus, adding an input or output format requires
    only adding a reader or writer.
category: Text
author: John MacFarlane <jgm@berkeley.edu>
exposed: True
indefinite: False
exposed-modules:
    Text.Pandoc Text.Pandoc.App Text.Pandoc.Asciify Text.Pandoc.BCP47
    Text.Pandoc.Class Text.Pandoc.Emoji Text.Pandoc.Error
    Text.Pandoc.Extensions Text.Pandoc.Highlighting
    Text.Pandoc.ImageSize Text.Pandoc.Logging Text.Pandoc.Lua
    Text.Pandoc.MIME Text.Pandoc.MediaBag Text.Pandoc.Options
    Text.Pandoc.PDF Text.Pandoc.Parsing Text.Pandoc.Pretty
    Text.Pandoc.Process Text.Pandoc.Readers
    Text.Pandoc.Readers.CommonMark Text.Pandoc.Readers.Creole
    Text.Pandoc.Readers.DocBook Text.Pandoc.Readers.Docx
    Text.Pandoc.Readers.EPUB Text.Pandoc.Readers.HTML
    Text.Pandoc.Readers.Haddock Text.Pandoc.Readers.LaTeX
    Text.Pandoc.Readers.LaTeX.Types Text.Pandoc.Readers.Markdown
    Text.Pandoc.Readers.MediaWiki Text.Pandoc.Readers.Muse
    Text.Pandoc.Readers.Native Text.Pandoc.Readers.OPML
    Text.Pandoc.Readers.Odt Text.Pandoc.Readers.Org
    Text.Pandoc.Readers.RST Text.Pandoc.Readers.TWiki
    Text.Pandoc.Readers.Textile Text.Pandoc.Readers.TikiWiki
    Text.Pandoc.Readers.Txt2Tags Text.Pandoc.Readers.Vimwiki
    Text.Pandoc.SelfContained Text.Pandoc.Shared Text.Pandoc.Templates
    Text.Pandoc.UTF8 Text.Pandoc.Writers Text.Pandoc.Writers.AsciiDoc
    Text.Pandoc.Writers.CommonMark Text.Pandoc.Writers.ConTeXt
    Text.Pandoc.Writers.Custom Text.Pandoc.Writers.Docbook
    Text.Pandoc.Writers.Docx Text.Pandoc.Writers.DokuWiki
    Text.Pandoc.Writers.EPUB Text.Pandoc.Writers.FB2
    Text.Pandoc.Writers.HTML Text.Pandoc.Writers.Haddock
    Text.Pandoc.Writers.ICML Text.Pandoc.Writers.JATS
    Text.Pandoc.Writers.LaTeX Text.Pandoc.Writers.Man
    Text.Pandoc.Writers.Markdown Text.Pandoc.Writers.Math
    Text.Pandoc.Writers.MediaWiki Text.Pandoc.Writers.Ms
    Text.Pandoc.Writers.Muse Text.Pandoc.Writers.Native
    Text.Pandoc.Writers.ODT Text.Pandoc.Writers.OOXML
    Text.Pandoc.Writers.OPML Text.Pandoc.Writers.OpenDocument
    Text.Pandoc.Writers.Org Text.Pandoc.Writers.Powerpoint
    Text.Pandoc.Writers.RST Text.Pandoc.Writers.RTF
    Text.Pandoc.Writers.Shared Text.Pandoc.Writers.TEI
    Text.Pandoc.Writers.Texinfo Text.Pandoc.Writers.Textile
    Text.Pandoc.Writers.ZimWiki Text.Pandoc.XML
hidden-modules: Text.Pandoc.Readers.Docx.Lists
                Text.Pandoc.Readers.Docx.Combine Text.Pandoc.Readers.Docx.Parse
                Text.Pandoc.Readers.Docx.Util Text.Pandoc.Readers.Docx.StyleMap
                Text.Pandoc.Readers.Odt.Base Text.Pandoc.Readers.Odt.Namespaces
                Text.Pandoc.Readers.Odt.StyleReader
                Text.Pandoc.Readers.Odt.ContentReader
                Text.Pandoc.Readers.Odt.Generic.Fallible
                Text.Pandoc.Readers.Odt.Generic.SetMap
                Text.Pandoc.Readers.Odt.Generic.Utils
                Text.Pandoc.Readers.Odt.Generic.Namespaces
                Text.Pandoc.Readers.Odt.Generic.XMLConverter
                Text.Pandoc.Readers.Odt.Arrows.State
                Text.Pandoc.Readers.Odt.Arrows.Utils
                Text.Pandoc.Readers.Org.BlockStarts Text.Pandoc.Readers.Org.Blocks
                Text.Pandoc.Readers.Org.DocumentTree
                Text.Pandoc.Readers.Org.ExportSettings
                Text.Pandoc.Readers.Org.Inlines Text.Pandoc.Readers.Org.Meta
                Text.Pandoc.Readers.Org.ParserState Text.Pandoc.Readers.Org.Parsing
                Text.Pandoc.Readers.Org.Shared Text.Pandoc.Lua.Packages
                Text.Pandoc.Lua.PandocModule Text.Pandoc.Lua.Filter
                Text.Pandoc.Lua.StackInstances Text.Pandoc.Lua.Util Text.Pandoc.CSS
                Text.Pandoc.CSV Text.Pandoc.UUID Text.Pandoc.Translations
                Text.Pandoc.Slides Text.Pandoc.Compat.Time Paths_pandoc
abi: 7f85f0a3a8d1dd52133118f72d2b2ef0
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/pandoc-2.0.5
library-dirs: /usr/lib/ghc-8.2.2/site-local/pandoc-2.0.5
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/pandoc
hs-libraries: HSpandoc-2.0.5-91IyCZ1v9wdD446Sq76mIZ
depends:
    base-4.10.1.0 syb-0.7-3Lq8MQxmYP07qktjI1jxu0 containers-0.5.10.2
    unordered-containers-0.2.8.0-I4wGGMV7X9X97sk1hrOqCV
    parsec-3.1.11-4HFX6l6YojG1oyYQULsuQ1
    mtl-2.2.1-DscMMmDQUE6GBfOSl4qMUH filepath-1.4.1.2 process-1.6.1.0
    directory-1.3.0.2 bytestring-0.10.8.2
    text-1.2.2.2-E3rQA0mJl73IvZIzvmwqAj
    safe-0.3.15-EroU33EYnr02fGSZYGiX97
    zip-archive-0.3.1.1-7FrckYj3aETCtRFPL29bkU
    HTTP-4000.3.9-8ak7ZEEv7LnBNQSKgqkDLq
    texmath-0.10-GD4q3ZhBPT27xmQCwrh0vw
    xml-1.3.14-4CFkuDapbpFLOtwR0lZo9m
    split-0.2.3.2-7cayvoeRj5XIrIBUB58mMy
    random-1.1-LLUGZ7T9DqQ5vN0Jbcd0We
    pandoc-types-1.17.3-6WNmkWSEi8aL8GAuLp4yvH
    aeson-1.2.3.0-LNkLuLvRI8W9I8ocVQs80F
    aeson-pretty-0.8.5-LFJu9kVJ6zPIrRgYhOjpbD
    tagsoup-0.14.2-B5UcFoI7I1ZJyQrv3xQJiu
    base64-bytestring-1.0.0.1-8MlzMz2YH3lCqJ4GOwL1Be
    zlib-0.6.1.2-3jYpKaDVsj2d994OadtMM
    skylighting-0.5-766k0h1rKlDHfDBpyvroJ9
    data-default-0.7.1.1-FICujruwzSN8grhdf3Hr65
    temporary-1.2.1.1-7a1ypWDsHB4EWhBxWwtUro
    blaze-html-0.9.0.1-AJ5BYeepLwbHkN0LWWSQW
    blaze-markup-0.8.0.0-KhGWK8j3xIT2gHtdkKPmyu
    yaml-0.8.25-ITsFqbq3blw7wAvfFQu3xZ
    scientific-0.3.5.2-Lc8fLx9ZwucCofr91mB0B5
    vector-0.12.0.1-IUGn3M9mkBh8CyXcBnfTR4
    hslua-0.9.3-B8N4GePgqNiKxSWH8EofkB
    hslua-module-text-0.1.2.1-KlYwMf2sBQ013v77rZM0JU binary-0.8.5.1
    SHA-1.6.4.2-1gNz0XEXVc9D2LWQ8o29zI
    haddock-library-1.4.5-uQdrVGi1uKLD22IlKGc6n deepseq-1.4.3.0
    JuicyPixels-3.2.9.1-9RgQgT8ijYSJcNoiMshBhk
    Glob-0.7.14-DzrLFI5lOpA97DYhPgnVv6
    cmark-gfm-0.1.3-9DQ8lJ6w58yIpjjdWOVtyy
    doctemplates-0.2.1-Bc06wZDwg6pAfGqM87qilP
    http-client-0.5.7.1-F4gW6CLqjRz4NQkO4hWphA
    http-client-tls-0.3.5.1-4n2xrEf2LbfCs4Vnf1RaAA
    http-types-0.9.1-LLq3nvC0GR761npQ3LSltX
    case-insensitive-1.2.0.10-BoRVwnTiXXU9RJ6NEnu1BA unix-2.7.2.2
    time-1.8.0.2 network-uri-2.6.1.0-LYYrYvUJy87zSaoB2hpvT
    network-2.6.3.2-Elf6Dxkfz0iKjb1zv5eBTP
abi-depends: base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
             syb-0.7-3Lq8MQxmYP07qktjI1jxu0=f985ea42a9fa578e0f67572a93e19b5d
             containers-0.5.10.2=0f9db0d1b935cacba444aac19f4cb54d
             unordered-containers-0.2.8.0-I4wGGMV7X9X97sk1hrOqCV=db9131d5548eea6d7a3eab9f0d172004
             parsec-3.1.11-4HFX6l6YojG1oyYQULsuQ1=893424ff0bd1ccfdf429c25df7ce2aa4
             mtl-2.2.1-DscMMmDQUE6GBfOSl4qMUH=a1f89647d7228db4bf59b7aaec52e888
             filepath-1.4.1.2=a40cd48e5480796e558f3c29652ee19a
             process-1.6.1.0=e78440f24fd9cc3300a1da2a92a47757
             directory-1.3.0.2=7b913664ccd770192b307d7c4c6817cc
             bytestring-0.10.8.2=4b2726b654ceeff6535e698a2a1e724e
             text-1.2.2.2-E3rQA0mJl73IvZIzvmwqAj=19cd54ed0f93cc2e72d3ff0c754f5306
             safe-0.3.15-EroU33EYnr02fGSZYGiX97=604c7b7c109a34b58d71795df287548a
             zip-archive-0.3.1.1-7FrckYj3aETCtRFPL29bkU=383ec5be330eca6a77ecfe285380f040
             HTTP-4000.3.9-8ak7ZEEv7LnBNQSKgqkDLq=576683c48b2dbfd6ada88368f7234400
             texmath-0.10-GD4q3ZhBPT27xmQCwrh0vw=7f1b5e3df2eba102ef19d7cb92d5bf97
             xml-1.3.14-4CFkuDapbpFLOtwR0lZo9m=54ceb3ab32cca0374ff7cee0a256661e
             split-0.2.3.2-7cayvoeRj5XIrIBUB58mMy=797cd4cd973bcc2d6f301fd097dd3406
             random-1.1-LLUGZ7T9DqQ5vN0Jbcd0We=368a9f817c8c1b290191231dd0d81d85
             pandoc-types-1.17.3-6WNmkWSEi8aL8GAuLp4yvH=d57705ff806f55c85667bb3699a61443
             aeson-1.2.3.0-LNkLuLvRI8W9I8ocVQs80F=4c58219744f0571919d1814f029cc115
             aeson-pretty-0.8.5-LFJu9kVJ6zPIrRgYhOjpbD=8539f09caee154613432bd791095a2d1
             tagsoup-0.14.2-B5UcFoI7I1ZJyQrv3xQJiu=d89f6224fe78a605d11171b73e194e00
             base64-bytestring-1.0.0.1-8MlzMz2YH3lCqJ4GOwL1Be=fd5db0dc9688093c1ac2c3223371478e
             zlib-0.6.1.2-3jYpKaDVsj2d994OadtMM=fc994ec0331fc01f98e1d968398a1aa2
             skylighting-0.5-766k0h1rKlDHfDBpyvroJ9=e571022903f61df2c012dd2b1c1c35eb
             data-default-0.7.1.1-FICujruwzSN8grhdf3Hr65=f057e993f72fa1f980dd728ed8010ca1
             temporary-1.2.1.1-7a1ypWDsHB4EWhBxWwtUro=b8bff4b84b25638f1f5ef8924bbd6e32
             blaze-html-0.9.0.1-AJ5BYeepLwbHkN0LWWSQW=149b27858c24c2fbb2a49b79255301b8
             blaze-markup-0.8.0.0-KhGWK8j3xIT2gHtdkKPmyu=63159b929711dfedc567b0fafce4aed8
             yaml-0.8.25-ITsFqbq3blw7wAvfFQu3xZ=4551de0e79d2c89cdf4b2c12f83d0c9c
             scientific-0.3.5.2-Lc8fLx9ZwucCofr91mB0B5=7c20e5f5e59fd4e457b5ba5744572d2c
             vector-0.12.0.1-IUGn3M9mkBh8CyXcBnfTR4=d8375a46a4155c3f449ce3d319b3dbaa
             hslua-0.9.3-B8N4GePgqNiKxSWH8EofkB=2e6d3f9dce56e982f0edea2451409f1b
             hslua-module-text-0.1.2.1-KlYwMf2sBQ013v77rZM0JU=71f744fe511d24f57f0f666345525b73
             binary-0.8.5.1=33c677d3ced9a5afbc7b354509494653
             SHA-1.6.4.2-1gNz0XEXVc9D2LWQ8o29zI=a1e214e4043a6e8594f125021a39000f
             haddock-library-1.4.5-uQdrVGi1uKLD22IlKGc6n=6190889e581e299524df9ddefc6f117b
             deepseq-1.4.3.0=e843b5d736cc095915bf2399fddf152e
             JuicyPixels-3.2.9.1-9RgQgT8ijYSJcNoiMshBhk=f7e47e914e38b216af21b05d2b7fa937
             Glob-0.7.14-DzrLFI5lOpA97DYhPgnVv6=1013f80b89485d7e2cae25eb44cd266a
             cmark-gfm-0.1.3-9DQ8lJ6w58yIpjjdWOVtyy=7f0d6ac056610acfbbdcfe6cb2cb3264
             doctemplates-0.2.1-Bc06wZDwg6pAfGqM87qilP=1d1142d659c90273ef3daa738a0e9f59
             http-client-0.5.7.1-F4gW6CLqjRz4NQkO4hWphA=d0571206ade6809eefa707c437b17401
             http-client-tls-0.3.5.1-4n2xrEf2LbfCs4Vnf1RaAA=ecc680c28f7f97c92bd4ec68f16761b3
             http-types-0.9.1-LLq3nvC0GR761npQ3LSltX=8737ff00443d120d7dd51745f32137a9
             case-insensitive-1.2.0.10-BoRVwnTiXXU9RJ6NEnu1BA=4295449faa2e312746ed6e93c93f9c1e
             unix-2.7.2.2=3df01ca0d7640dab598065ff1b1cffeb
             time-1.8.0.2=d7392e85059cb108aeb68d6e24815970
             network-uri-2.6.1.0-LYYrYvUJy87zSaoB2hpvT=0b326ed8cea6aef4683ed7796a7691a6
             network-2.6.3.2-Elf6Dxkfz0iKjb1zv5eBTP=a333d9df3290e5924c2ef4f5f4b24781
haddock-interfaces: /usr/share/doc/pandoc/html/pandoc.haddock
haddock-html: /usr/share/doc/pandoc/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

