/*
 * Decompiled with CFR 0.152.
 */
package ch.softenvironment.util;

import ch.softenvironment.util.StringUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.Node;

public class ImageUtils {
    public static void screenShot(String filename) {
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension screenSize = toolkit.getScreenSize();
            Rectangle screenRect = new Rectangle(screenSize);
            Robot robot = new Robot();
            BufferedImage image = robot.createScreenCapture(screenRect);
            ImageIO.write((RenderedImage)image, "png", new File(ImageUtils.checkSuffixPNG(filename)));
        }
        catch (Throwable e) {
            System.out.println("screenshot failed: " + e.getLocalizedMessage());
        }
    }

    private static String checkSuffixPNG(String filename) {
        return StringUtils.tryAppendSuffix(filename, ".png");
    }

    public static void writeImage(String filename, BufferedImage bufferedImage) throws IOException {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersBySuffix("png");
        if (!iterator.hasNext()) {
            throw new IllegalStateException("no writers found");
        }
        ImageWriter imageWriter = iterator.next();
        FileOutputStream outputStream = new FileOutputStream(ImageUtils.checkSuffixPNG(filename));
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(outputStream);
        imageWriter.setOutput(imageOutputStream);
        ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
        ImageTypeSpecifier imageTypeSpecifier = new ImageTypeSpecifier(bufferedImage);
        IIOMetadata metadata = imageWriter.getDefaultImageMetadata(imageTypeSpecifier, imageWriteParam);
        String sFormat = "javax_imageio_png_1.0";
        Node node = metadata.getAsTree(sFormat);
        IIOMetadataNode gammaNode = new IIOMetadataNode("gAMA");
        String sGamma = "55556";
        gammaNode.setAttribute("value", sGamma);
        node.appendChild(gammaNode);
        metadata.setFromTree(sFormat, node);
        imageWriter.write(new IIOImage(bufferedImage, null, metadata));
    }

    public static void main(String[] args) {
        BufferedImage bufferedImage = new BufferedImage(50, 50, 2);
        Graphics2D g2 = (Graphics2D)bufferedImage.getGraphics();
        g2.setColor(new Color(204, 204, 255));
        g2.fillRect(0, 0, 50, 50);
        try {
            ImageUtils.writeImage("C:/Temp/test_ph1.png", bufferedImage);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ImageUtils.screenShot("C:/Temp/test_ps_sc1.png");
    }
}

