/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.CloseConnectionException;
import Ice.CommunicatorDestroyedException;
import Ice.ConnectionManuallyClosedException;
import Ice.Holder;
import Ice.Identity;
import Ice.InputStream;
import Ice.InvocationCanceledException;
import Ice.InvocationTimeoutException;
import Ice.LocalException;
import Ice.Logger;
import Ice.MarshalException;
import Ice.ObjectAdapterDeactivatedException;
import Ice.ObjectNotExistException;
import Ice.ObjectPrx;
import Ice.ObjectPrxHelperBase;
import Ice.OperationInterruptedException;
import Ice.RequestFailedException;
import IceInternal.Instance;
import IceInternal.LocatorInfo;
import IceInternal.Reference;
import IceInternal.TraceLevels;
import java.util.HashMap;
import java.util.Map;

public final class ProxyFactory {
    private Instance _instance;
    private int[] _retryIntervals;

    public ObjectPrx stringToProxy(String str) {
        Reference ref = this._instance.referenceFactory().create(str, null);
        return this.referenceToProxy(ref);
    }

    public String proxyToString(ObjectPrx proxy) {
        if (proxy != null) {
            ObjectPrxHelperBase h = (ObjectPrxHelperBase)proxy;
            return h._getReference().toString();
        }
        return "";
    }

    public ObjectPrx propertyToProxy(String prefix) {
        String proxy = this._instance.initializationData().properties.getProperty(prefix);
        Reference ref = this._instance.referenceFactory().create(proxy, prefix);
        return this.referenceToProxy(ref);
    }

    public Map<String, String> proxyToProperty(ObjectPrx proxy, String prefix) {
        if (proxy != null) {
            ObjectPrxHelperBase h = (ObjectPrxHelperBase)proxy;
            return h._getReference().toProperty(prefix);
        }
        return new HashMap<String, String>();
    }

    public ObjectPrx streamToProxy(InputStream s) {
        Identity ident = new Identity();
        ident.ice_readMembers(s);
        Reference ref = this._instance.referenceFactory().create(ident, s);
        return this.referenceToProxy(ref);
    }

    public ObjectPrx referenceToProxy(Reference ref) {
        if (ref != null) {
            ObjectPrxHelperBase proxy = new ObjectPrxHelperBase();
            proxy._setup(ref);
            return proxy;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int checkRetryAfterException(LocalException ex, Reference ref, Holder<Integer> sleepInterval, int cnt) {
        String s;
        int interval;
        TraceLevels traceLevels = this._instance.traceLevels();
        Logger logger = this._instance.initializationData().logger;
        if (ref.getMode() == 2 || ref.getMode() == 4) {
            throw ex;
        }
        if (ex instanceof ObjectNotExistException) {
            LocatorInfo li;
            ObjectNotExistException one = (ObjectNotExistException)ex;
            if (ref.getRouterInfo() != null && one.operation.equals("ice_add_proxy")) {
                ref.getRouterInfo().clearCache(ref);
                if (traceLevels.retry >= 1) {
                    String s2 = "retrying operation call to add proxy to router\n" + ex.toString();
                    logger.trace(traceLevels.retryCat, s2);
                }
                if (sleepInterval == null) return cnt;
                sleepInterval.value = 0;
                return cnt;
            }
            if (!ref.isIndirect()) throw ex;
            if (ref.isWellKnown() && (li = ref.getLocatorInfo()) != null) {
                li.clearCache(ref);
            }
        } else if (ex instanceof RequestFailedException) {
            throw ex;
        }
        if (ex instanceof MarshalException) {
            throw ex;
        }
        if (ex instanceof CommunicatorDestroyedException || ex instanceof ObjectAdapterDeactivatedException || ex instanceof ConnectionManuallyClosedException) {
            throw ex;
        }
        if (ex instanceof InvocationTimeoutException || ex instanceof InvocationCanceledException) {
            throw ex;
        }
        if (ex instanceof OperationInterruptedException) {
            throw ex;
        }
        assert (++cnt > 0);
        if (cnt == this._retryIntervals.length + 1 && ex instanceof CloseConnectionException) {
            interval = 0;
        } else {
            if (cnt > this._retryIntervals.length) {
                if (traceLevels.retry < 1) throw ex;
                s = "cannot retry operation call because retry limit has been exceeded\n" + ex.toString();
                logger.trace(traceLevels.retryCat, s);
                throw ex;
            }
            interval = this._retryIntervals[cnt - 1];
        }
        if (traceLevels.retry >= 1) {
            s = "retrying operation call";
            if (interval > 0) {
                s = s + " in " + interval + "ms";
            }
            s = s + " because of exception\n" + ex;
            logger.trace(traceLevels.retryCat, s);
        }
        sleepInterval.value = interval;
        return cnt;
    }

    ProxyFactory(Instance instance) {
        this._instance = instance;
        String[] arr = this._instance.initializationData().properties.getPropertyAsList("Ice.RetryIntervals");
        if (arr.length > 0) {
            this._retryIntervals = new int[arr.length];
            for (int i = 0; i < arr.length; ++i) {
                int v;
                try {
                    v = Integer.parseInt(arr[i]);
                }
                catch (NumberFormatException ex) {
                    v = 0;
                }
                if (i == 0 && v == -1) {
                    this._retryIntervals = new int[0];
                    break;
                }
                this._retryIntervals[i] = v > 0 ? v : 0;
            }
        } else {
            this._retryIntervals = new int[1];
            this._retryIntervals[0] = 0;
        }
    }
}

