// Generated by CoffeeScript 1.11.1
(function() {
  var bplistCreator, bplistParser, fs, plist;

  bplistParser = require('bplist-parser');

  bplistCreator = require('bplist-creator');

  plist = require('plist');

  fs = require('fs');

  exports.plist = plist;

  exports.bplistCreator = bplistCreator;

  exports.bplistParser = bplistParser;

  exports.readFileSync = function(aFile) {
    var contents;
    contents = fs.readFileSync(aFile);
    if (contents.length === 0) {
      return {};
    }
    return exports.parse(contents, aFile);
  };

  exports.readFile = function(aFile, callback) {
    return fs.readFile(aFile, function(err, contents) {
      var results;
      if (err) {
        return callback(err);
      } else {
        try {
          results = exports.parse(contents, aFile);
          return callback(null, results);
        } catch (error) {
          err = error;
          return callback(err);
        }
      }
    });
  };

  exports.writeFileSync = function(aFile, anObject, options) {
    var data;
    data = plist.build(anObject);
    return fs.writeFileSync(aFile, data, options);
  };

  exports.writeFile = function(aFile, anObject, options, callback) {
    var data;
    if (arguments.length === 3 && typeof options === 'function') {
      callback = options;
      options = void 0;
    }
    data = plist.build(anObject);
    return fs.writeFile(aFile, data, options, callback);
  };

  exports.writeBinaryFileSync = function(aFile, anObject, options) {
    var data;
    data = bplistCreator(anObject);
    return fs.writeFileSync(aFile, data, options);
  };

  exports.writeBinaryFile = function(aFile, anObject, options, callback) {
    var data;
    if (arguments.length === 3 && typeof options === 'function') {
      callback = options;
      options = void 0;
    }
    data = bplistCreator(anObject);
    return fs.writeFile(aFile, data, options, callback);
  };

  exports.stringify = function(anObject) {
    return plist.build(anObject);
  };

  exports.parse = function(aStringOrBuffer, aFile) {
    var e, firstByte, results;
    firstByte = aStringOrBuffer[0];
    try {
      if (firstByte === 60 || firstByte === '<') {
        results = plist.parse(aStringOrBuffer.toString());
      } else if (firstByte === 98) {
        results = bplistParser.parseBuffer(aStringOrBuffer)[0];
      } else {
        if (aFile != null) {
          throw new Error("Unable to determine format for '" + aFile + "'");
        } else {
          throw new Error("Unable to determine format for plist aStringOrBuffer");
        }
        results = {};
      }
    } catch (error) {
      e = error;
      throw new Error(aFile + " has errors");
    }
    return results;
  };

}).call(this);
