/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.locklistener;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Iterator;
import org.gradle.cache.internal.locklistener.GracefullyStoppedException;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.remote.internal.inet.InetAddressFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLockCommunicator {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileLockCommunicator.class);
    private static final String SOCKET_OPERATION_NOT_PERMITTED_ERROR_MESSAGE = "Operation not permitted";
    private static final byte PROTOCOL_VERSION = 1;
    private final DatagramSocket socket;
    private final InetAddressFactory addressFactory;
    private boolean stopped;

    public FileLockCommunicator(InetAddressFactory addressFactory) {
        this.addressFactory = addressFactory;
        try {
            this.socket = new DatagramSocket(0, addressFactory.getLocalBindingAddress());
        }
        catch (SocketException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean pingOwner(int ownerPort, long lockId, String displayName) {
        try {
            byte[] bytesToSend = FileLockCommunicator.encode(lockId);
            Iterator i$ = this.addressFactory.getCommunicationAddresses().iterator();
            while (i$.hasNext()) {
                InetAddress address = (InetAddress)i$.next();
                try {
                    this.socket.send(new DatagramPacket(bytesToSend, bytesToSend.length, address, ownerPort));
                }
                catch (IOException e) {
                    if (e.getMessage() == null) throw e;
                    if (!e.getMessage().startsWith(SOCKET_OPERATION_NOT_PERMITTED_ERROR_MESSAGE)) throw e;
                    LOGGER.debug("Failed attempt to ping owner of lock for {} (lock id: {}, port: {}, address: {})", new Object[]{displayName, lockId, ownerPort, address});
                    return false;
                }
            }
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to ping owner of lock for %s (lock id: %s, port: %s)", displayName, lockId, ownerPort), e);
        }
    }

    public DatagramPacket receive() throws GracefullyStoppedException {
        try {
            byte[] bytes = new byte[9];
            DatagramPacket packet = new DatagramPacket(bytes, bytes.length);
            this.socket.receive(packet);
            return packet;
        }
        catch (IOException e) {
            if (!this.stopped) {
                throw new RuntimeException(e);
            }
            throw new GracefullyStoppedException();
        }
    }

    public long decodeLockId(DatagramPacket receivedPacket) {
        try {
            return FileLockCommunicator.decode(receivedPacket.getData());
        }
        catch (IOException e) {
            if (!this.stopped) {
                throw new RuntimeException(e);
            }
            throw new GracefullyStoppedException();
        }
    }

    public void confirmUnlockRequest(DatagramPacket receivedPacket) {
        try {
            byte[] bytes = receivedPacket.getData();
            DatagramPacket confirmPacket = new DatagramPacket(bytes, bytes.length, receivedPacket.getAddress(), receivedPacket.getPort());
            this.socket.send(confirmPacket);
        }
        catch (IOException e) {
            if (!this.stopped) {
                throw new RuntimeException(e);
            }
            throw new GracefullyStoppedException();
        }
    }

    public void stop() {
        this.stopped = true;
        this.socket.close();
    }

    private static byte[] encode(long lockId) throws IOException {
        ByteArrayOutputStream packet = new ByteArrayOutputStream();
        DataOutputStream dataOutput = new DataOutputStream(packet);
        dataOutput.writeByte(1);
        dataOutput.writeLong(lockId);
        dataOutput.flush();
        return packet.toByteArray();
    }

    private static long decode(byte[] bytes) throws IOException {
        DataInputStream dataInput = new DataInputStream(new ByteArrayInputStream(bytes));
        byte version = dataInput.readByte();
        if (version != 1) {
            throw new IllegalArgumentException(String.format("Unexpected protocol version %s received in lock contention notification message", version));
        }
        return dataInput.readLong();
    }

    public int getPort() {
        return this.socket.getLocalPort();
    }
}

