/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import groovy.lang.Closure;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.file.SourceDirectorySetFactory;
import org.gradle.api.internal.jvm.ClassDirectoryBinaryNamingScheme;
import org.gradle.api.internal.tasks.DefaultSourceSetOutput;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.GUtil;

public class DefaultSourceSet
implements SourceSet {
    private final String name;
    private final String baseName;
    private FileCollection compileClasspath;
    private FileCollection runtimeClasspath;
    private final SourceDirectorySet javaSource;
    private final SourceDirectorySet allJavaSource;
    private final SourceDirectorySet resources;
    private final String displayName;
    private final SourceDirectorySet allSource;
    private final ClassDirectoryBinaryNamingScheme namingScheme;
    private DefaultSourceSetOutput output;

    public DefaultSourceSet(String name, SourceDirectorySetFactory sourceDirectorySetFactory) {
        this.name = name;
        this.baseName = name.equals("main") ? "" : GUtil.toCamelCase((CharSequence)name);
        this.displayName = GUtil.toWords((CharSequence)this.name);
        this.namingScheme = new ClassDirectoryBinaryNamingScheme(name);
        String javaSrcDisplayName = this.displayName + " Java source";
        this.javaSource = sourceDirectorySetFactory.create("java", javaSrcDisplayName);
        this.javaSource.getFilter().include(new String[]{"**/*.java"});
        this.allJavaSource = sourceDirectorySetFactory.create(javaSrcDisplayName);
        this.allJavaSource.getFilter().include(new String[]{"**/*.java"});
        this.allJavaSource.source(this.javaSource);
        String resourcesDisplayName = this.displayName + " resources";
        this.resources = sourceDirectorySetFactory.create(resourcesDisplayName);
        this.resources.getFilter().exclude((Spec)new Spec<FileTreeElement>(){

            public boolean isSatisfiedBy(FileTreeElement element) {
                return DefaultSourceSet.this.javaSource.contains(element.getFile());
            }
        });
        String allSourceDisplayName = this.displayName + " source";
        this.allSource = sourceDirectorySetFactory.create(allSourceDisplayName);
        this.allSource.source(this.resources);
        this.allSource.source(this.javaSource);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return "source set '" + this.getDisplayName() + "'";
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getClassesTaskName() {
        return this.getTaskName(null, "classes");
    }

    @Override
    public String getCompileTaskName(String language) {
        return this.getTaskName("compile", language);
    }

    @Override
    public String getCompileJavaTaskName() {
        return this.getCompileTaskName("java");
    }

    @Override
    public String getProcessResourcesTaskName() {
        return this.getTaskName("process", "resources");
    }

    @Override
    public String getJarTaskName() {
        return this.getTaskName(null, "jar");
    }

    @Override
    public String getTaskName(String verb, String target) {
        return this.namingScheme.getTaskName(verb, target);
    }

    private String getTaskBaseName() {
        return this.baseName;
    }

    @Override
    public String getCompileConfigurationName() {
        return this.configurationNameOf("compile");
    }

    private String configurationNameOf(String baseName) {
        return StringUtils.uncapitalize((String)(this.getTaskBaseName() + StringUtils.capitalize((String)baseName)));
    }

    @Override
    public String getRuntimeConfigurationName() {
        return this.configurationNameOf("runtime");
    }

    @Override
    public String getCompileOnlyConfigurationName() {
        return this.configurationNameOf("compileOnly");
    }

    @Override
    public String getCompileClasspathConfigurationName() {
        return this.configurationNameOf("compileClasspath");
    }

    @Override
    public String getApiConfigurationName() {
        return this.configurationNameOf("api");
    }

    @Override
    public String getImplementationConfigurationName() {
        return this.configurationNameOf("implementation");
    }

    @Override
    public String getApiElementsConfigurationName() {
        return this.configurationNameOf("apiElements");
    }

    @Override
    public String getRuntimeOnlyConfigurationName() {
        return this.configurationNameOf("runtimeOnly");
    }

    @Override
    public String getRuntimeClasspathConfigurationName() {
        return this.configurationNameOf("runtimeClasspath");
    }

    @Override
    public String getRuntimeElementsConfigurationName() {
        return this.configurationNameOf("runtimeElements");
    }

    @Override
    public SourceSetOutput getOutput() {
        return this.output;
    }

    public void setClasses(DefaultSourceSetOutput classes) {
        this.output = classes;
    }

    @Override
    public SourceSet compiledBy(Object ... taskPaths) {
        this.output.builtBy(taskPaths);
        return this;
    }

    @Override
    public FileCollection getCompileClasspath() {
        return this.compileClasspath;
    }

    @Override
    public FileCollection getRuntimeClasspath() {
        return this.runtimeClasspath;
    }

    @Override
    public void setCompileClasspath(FileCollection classpath) {
        this.compileClasspath = classpath;
    }

    @Override
    public void setRuntimeClasspath(FileCollection classpath) {
        this.runtimeClasspath = classpath;
    }

    @Override
    public SourceDirectorySet getJava() {
        return this.javaSource;
    }

    @Override
    public SourceSet java(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getJava());
        return this;
    }

    @Override
    public SourceSet java(Action<? super SourceDirectorySet> configureAction) {
        configureAction.execute((Object)this.getJava());
        return this;
    }

    @Override
    public SourceDirectorySet getAllJava() {
        return this.allJavaSource;
    }

    @Override
    public SourceDirectorySet getResources() {
        return this.resources;
    }

    @Override
    public SourceSet resources(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getResources());
        return this;
    }

    @Override
    public SourceSet resources(Action<? super SourceDirectorySet> configureAction) {
        configureAction.execute((Object)this.getResources());
        return this;
    }

    @Override
    public SourceDirectorySet getAllSource() {
        return this.allSource;
    }
}

