/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Data;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataIntegrityProblemException;
import org.openstreetmap.josm.data.osm.DataSelectionListener;
import org.openstreetmap.josm.data.osm.DataSetMerger;
import org.openstreetmap.josm.data.osm.HighlightUpdateListener;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.QuadBucketPrimitiveStore;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.Storage;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.ChangesetIdChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitiveFlagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionChangeListener;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ListenerList;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;

public final class DataSet
extends QuadBucketPrimitiveStore
implements Data,
ProjectionChangeListener {
    private static final int MAX_SINGLE_EVENTS = 30;
    private static final int MAX_EVENTS = 1000;
    private final Storage<OsmPrimitive> allPrimitives = new Storage<PrimitiveId>(new Storage.PrimitiveIdHash(), true);
    private final Map<PrimitiveId, OsmPrimitive> primitivesMap = this.allPrimitives.foreignKey(new Storage.PrimitiveIdHash());
    private final CopyOnWriteArrayList<DataSetListener> listeners = new CopyOnWriteArrayList();
    private Collection<WaySegment> highlightedVirtualNodes = new LinkedList<WaySegment>();
    private Collection<WaySegment> highlightedWaySegments = new LinkedList<WaySegment>();
    private final ListenerList<HighlightUpdateListener> highlightUpdateListeners = ListenerList.create();
    private int updateCount;
    private final List<AbstractDatasetChangedEvent> cachedEvents = new ArrayList<AbstractDatasetChangedEvent>();
    private String name;
    private UploadPolicy uploadPolicy;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Object selectionLock = new Object();
    private Set<OsmPrimitive> currentSelectedPrimitives = Collections.emptySet();
    private final ListenerList<DataSelectionListener> selectionListeners = ListenerList.create();
    private Area cachedDataSourceArea;
    private List<Bounds> cachedDataSourceBounds;
    private final Collection<DataSource> dataSources = new LinkedList<DataSource>();
    private final ConflictCollection conflicts = new ConflictCollection();
    private final LinkedList<Collection<? extends OsmPrimitive>> selectionHistory = new LinkedList();
    private String version;
    private final Map<String, String> changeSetTags = new HashMap<String, String>();
    private static final Collection<SelectionChangedListener> selListeners = new CopyOnWriteArrayList<SelectionChangedListener>();

    public DataSet() {
        Main.addProjectionChangeListener(this);
        this.addSelectionListener(e -> DataSet.fireDeprecatedSelectionChange(e.getSelection()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet(DataSet copyFrom) {
        this();
        copyFrom.getReadLock().lock();
        try {
            Relation newRelation;
            HashMap<OsmPrimitive, OsmPrimitive> primMap = new HashMap<OsmPrimitive, OsmPrimitive>();
            for (Node n : copyFrom.getNodes()) {
                Node newNode = new Node(n);
                primMap.put(n, newNode);
                this.addPrimitive(newNode);
            }
            for (Way w : copyFrom.getWays()) {
                Way newWay = new Way(w);
                primMap.put(w, newWay);
                ArrayList<Node> newNodes = new ArrayList<Node>();
                for (Node n : w.getNodes()) {
                    newNodes.add((Node)primMap.get(n));
                }
                newWay.setNodes(newNodes);
                this.addPrimitive(newWay);
            }
            Collection<Relation> relations = copyFrom.getRelations();
            for (Relation r : relations) {
                newRelation = new Relation(r);
                newRelation.setMembers(null);
                primMap.put(r, newRelation);
                this.addPrimitive(newRelation);
            }
            for (Relation r : relations) {
                newRelation = (Relation)primMap.get(r);
                ArrayList<RelationMember> newMembers = new ArrayList<RelationMember>();
                for (RelationMember rm : r.getMembers()) {
                    newMembers.add(new RelationMember(rm.getRole(), (OsmPrimitive)primMap.get(rm.getMember())));
                }
                newRelation.setMembers(newMembers);
            }
            for (DataSource source : copyFrom.dataSources) {
                this.dataSources.add(new DataSource(source));
            }
            this.version = copyFrom.version;
            this.uploadPolicy = copyFrom.uploadPolicy;
        }
        finally {
            copyFrom.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet(OsmPrimitive ... osmPrimitives) {
        this();
        this.beginUpdate();
        try {
            for (OsmPrimitive o : osmPrimitives) {
                this.addPrimitive(o);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public synchronized boolean addDataSource(DataSource source) {
        return this.addDataSources(Collections.singleton(source));
    }

    public synchronized boolean addDataSources(Collection<DataSource> sources) {
        boolean changed = this.dataSources.addAll(sources);
        if (changed) {
            this.cachedDataSourceArea = null;
            this.cachedDataSourceBounds = null;
        }
        return changed;
    }

    public Lock getReadLock() {
        return this.lock.readLock();
    }

    public LinkedList<Collection<? extends OsmPrimitive>> getSelectionHistory() {
        return this.selectionHistory;
    }

    public void clearSelectionHistory() {
        this.selectionHistory.clear();
    }

    @Deprecated
    public AutoCompletionManager getAutoCompletionManager() {
        return AutoCompletionManager.of(this);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Deprecated
    public boolean isUploadDiscouraged() {
        return this.uploadPolicy == UploadPolicy.DISCOURAGED || this.uploadPolicy == UploadPolicy.BLOCKED;
    }

    @Deprecated
    public void setUploadDiscouraged(boolean uploadDiscouraged) {
        if (this.uploadPolicy != UploadPolicy.BLOCKED) {
            this.uploadPolicy = uploadDiscouraged ? UploadPolicy.DISCOURAGED : UploadPolicy.NORMAL;
        }
    }

    public UploadPolicy getUploadPolicy() {
        return this.uploadPolicy;
    }

    public void setUploadPolicy(UploadPolicy uploadPolicy) {
        this.uploadPolicy = uploadPolicy;
    }

    public Map<String, String> getChangeSetTags() {
        return this.changeSetTags;
    }

    public void addChangeSetTag(String k, String v) {
        this.changeSetTags.put(k, v);
    }

    public <T extends OsmPrimitive> Collection<T> getPrimitives(Predicate<? super OsmPrimitive> predicate) {
        return new SubclassFilteredCollection(this.allPrimitives, predicate);
    }

    public Collection<Node> getNodes() {
        return this.getPrimitives(Node.class::isInstance);
    }

    @Override
    public List<Node> searchNodes(BBox bbox) {
        this.lock.readLock().lock();
        try {
            List<Node> list = super.searchNodes(bbox);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Collection<Way> getWays() {
        return this.getPrimitives(Way.class::isInstance);
    }

    @Override
    public List<Way> searchWays(BBox bbox) {
        this.lock.readLock().lock();
        try {
            List<Way> list = super.searchWays(bbox);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public List<Relation> searchRelations(BBox bbox) {
        this.lock.readLock().lock();
        try {
            List<Relation> list = super.searchRelations(bbox);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Collection<Relation> getRelations() {
        return this.getPrimitives(Relation.class::isInstance);
    }

    public Collection<OsmPrimitive> allPrimitives() {
        return this.getPrimitives(o -> true);
    }

    public Collection<OsmPrimitive> allNonDeletedPrimitives() {
        return this.getPrimitives(p -> !p.isDeleted());
    }

    public Collection<OsmPrimitive> allNonDeletedCompletePrimitives() {
        return this.getPrimitives(primitive -> !primitive.isDeleted() && !primitive.isIncomplete());
    }

    public Collection<OsmPrimitive> allNonDeletedPhysicalPrimitives() {
        return this.getPrimitives(primitive -> !primitive.isDeleted() && !primitive.isIncomplete() && !(primitive instanceof Relation));
    }

    public Collection<OsmPrimitive> allModifiedPrimitives() {
        return this.getPrimitives(AbstractPrimitive::isModified);
    }

    @Override
    public void addPrimitive(OsmPrimitive primitive) {
        Objects.requireNonNull(primitive, "primitive");
        this.beginUpdate();
        try {
            if (this.getPrimitiveById(primitive) != null) {
                throw new DataIntegrityProblemException(I18n.tr("Unable to add primitive {0} to the dataset because it is already included", primitive.toString()));
            }
            this.allPrimitives.add(primitive);
            primitive.setDataset(this);
            primitive.updatePosition();
            super.addPrimitive(primitive);
            this.firePrimitivesAdded(Collections.singletonList(primitive), false);
        }
        finally {
            this.endUpdate();
        }
    }

    public void removePrimitive(PrimitiveId primitiveId) {
        this.beginUpdate();
        try {
            OsmPrimitive primitive = this.getPrimitiveByIdChecked(primitiveId);
            if (primitive == null) {
                return;
            }
            this.removePrimitiveImpl(primitive);
            this.firePrimitivesRemoved(Collections.singletonList(primitive), false);
        }
        finally {
            this.endUpdate();
        }
    }

    private void removePrimitiveImpl(OsmPrimitive primitive) {
        this.clearSelection(primitive.getPrimitiveId());
        if (primitive.isSelected()) {
            throw new DataIntegrityProblemException("Primitive was re-selected by a selection listener: " + primitive);
        }
        super.removePrimitive(primitive);
        this.allPrimitives.remove(primitive);
        primitive.setDataset(null);
    }

    @Override
    protected void removePrimitive(OsmPrimitive primitive) {
        this.beginUpdate();
        try {
            this.removePrimitiveImpl(primitive);
            this.firePrimitivesRemoved(Collections.singletonList(primitive), false);
        }
        finally {
            this.endUpdate();
        }
    }

    public void addSelectionListener(DataSelectionListener listener) {
        this.selectionListeners.addListener(listener);
    }

    public void removeSelectionListener(DataSelectionListener listener) {
        this.selectionListeners.removeListener(listener);
    }

    public static void addSelectionListener(SelectionChangedListener listener) {
        ((CopyOnWriteArrayList)selListeners).addIfAbsent(listener);
    }

    public static void removeSelectionListener(SelectionChangedListener listener) {
        selListeners.remove(listener);
    }

    @Deprecated
    public void fireSelectionChanged() {
        DataSet.fireDeprecatedSelectionChange(this.getAllSelected());
    }

    private static void fireDeprecatedSelectionChange(Collection<? extends OsmPrimitive> currentSelection) {
        for (SelectionChangedListener l : selListeners) {
            l.selectionChanged(currentSelection);
        }
    }

    public Collection<OsmPrimitive> getSelectedNodesAndWays() {
        return new SubclassFilteredCollection(this.getSelected(), primitive -> primitive instanceof Node || primitive instanceof Way);
    }

    public Collection<WaySegment> getHighlightedVirtualNodes() {
        return Collections.unmodifiableCollection(this.highlightedVirtualNodes);
    }

    public Collection<WaySegment> getHighlightedWaySegments() {
        return Collections.unmodifiableCollection(this.highlightedWaySegments);
    }

    public void addHighlightUpdateListener(HighlightUpdateListener listener) {
        this.highlightUpdateListeners.addListener(listener);
    }

    public void removeHighlightUpdateListener(HighlightUpdateListener listener) {
        this.highlightUpdateListeners.removeListener(listener);
    }

    public Collection<OsmPrimitive> getSelected() {
        return new SubclassFilteredCollection(this.getAllSelected(), p -> !p.isDeleted());
    }

    public Collection<OsmPrimitive> getAllSelected() {
        return this.currentSelectedPrimitives;
    }

    public Collection<Node> getSelectedNodes() {
        return new SubclassFilteredCollection(this.getSelected(), Node.class::isInstance);
    }

    public Collection<Way> getSelectedWays() {
        return new SubclassFilteredCollection(this.getSelected(), Way.class::isInstance);
    }

    public Collection<Relation> getSelectedRelations() {
        return new SubclassFilteredCollection(this.getSelected(), Relation.class::isInstance);
    }

    public boolean selectionEmpty() {
        return this.currentSelectedPrimitives.isEmpty();
    }

    public boolean isSelected(OsmPrimitive osm) {
        return this.currentSelectedPrimitives.contains(osm);
    }

    public void setHighlightedVirtualNodes(Collection<WaySegment> waySegments) {
        if (this.highlightedVirtualNodes.isEmpty() && waySegments.isEmpty()) {
            return;
        }
        this.highlightedVirtualNodes = waySegments;
        this.fireHighlightingChanged();
    }

    public void setHighlightedWaySegments(Collection<WaySegment> waySegments) {
        if (this.highlightedWaySegments.isEmpty() && waySegments.isEmpty()) {
            return;
        }
        this.highlightedWaySegments = waySegments;
        this.fireHighlightingChanged();
    }

    @Deprecated
    public void setSelected(Collection<? extends PrimitiveId> selection, boolean fireSelectionChangeEvent) {
        this.setSelected(selection);
    }

    public void setSelected(Collection<? extends PrimitiveId> selection) {
        this.setSelected(selection.stream());
    }

    public void setSelected(PrimitiveId ... osm) {
        this.setSelected(Stream.of(osm).filter(Objects::nonNull));
    }

    private void setSelected(Stream<? extends PrimitiveId> stream) {
        this.doSelectionChange(old -> new DataSelectionListener.SelectionReplaceEvent(this, (Set<OsmPrimitive>)old, stream.map(this::getPrimitiveByIdChecked).filter(Objects::nonNull)));
    }

    public void addSelected(Collection<? extends PrimitiveId> selection) {
        this.addSelected(selection.stream());
    }

    public void addSelected(PrimitiveId ... osm) {
        this.addSelected(Stream.of(osm));
    }

    private void addSelected(Stream<? extends PrimitiveId> stream) {
        this.doSelectionChange(old -> new DataSelectionListener.SelectionAddEvent(this, (Set<OsmPrimitive>)old, stream.map(this::getPrimitiveByIdChecked).filter(Objects::nonNull)));
    }

    public void clearSelection(PrimitiveId ... osm) {
        this.clearSelection(Stream.of(osm));
    }

    public void clearSelection(Collection<? extends PrimitiveId> list) {
        this.clearSelection(list.stream());
    }

    public void clearSelection() {
        this.setSelected(Stream.empty());
    }

    private void clearSelection(Stream<? extends PrimitiveId> stream) {
        this.doSelectionChange(old -> new DataSelectionListener.SelectionRemoveEvent(this, (Set<OsmPrimitive>)old, stream.map(this::getPrimitiveByIdChecked).filter(Objects::nonNull)));
    }

    public void toggleSelected(Collection<? extends PrimitiveId> osm) {
        this.toggleSelected(osm.stream());
    }

    public void toggleSelected(PrimitiveId ... osm) {
        this.toggleSelected(Stream.of(osm));
    }

    private void toggleSelected(Stream<? extends PrimitiveId> stream) {
        this.doSelectionChange(old -> new DataSelectionListener.SelectionToggleEvent(this, (Set<OsmPrimitive>)old, stream.map(this::getPrimitiveByIdChecked).filter(Objects::nonNull)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doSelectionChange(Function<Set<OsmPrimitive>, DataSelectionListener.SelectionChangeEvent> command) {
        Object object = this.selectionLock;
        synchronized (object) {
            DataSelectionListener.SelectionChangeEvent event = command.apply(this.currentSelectedPrimitives);
            if (event.isNop()) {
                return false;
            }
            this.currentSelectedPrimitives = event.getSelection();
            this.selectionListeners.fireEvent((T l) -> l.selectionChanged(event));
            return true;
        }
    }

    public void clearHighlightedVirtualNodes() {
        this.setHighlightedVirtualNodes(new ArrayList<WaySegment>());
    }

    public void clearHighlightedWaySegments() {
        this.setHighlightedWaySegments(new ArrayList<WaySegment>());
    }

    @Override
    public synchronized Area getDataSourceArea() {
        if (this.cachedDataSourceArea == null) {
            this.cachedDataSourceArea = Data.super.getDataSourceArea();
        }
        return this.cachedDataSourceArea;
    }

    @Override
    public synchronized List<Bounds> getDataSourceBounds() {
        if (this.cachedDataSourceBounds == null) {
            this.cachedDataSourceBounds = Data.super.getDataSourceBounds();
        }
        return Collections.unmodifiableList(this.cachedDataSourceBounds);
    }

    @Override
    public synchronized Collection<DataSource> getDataSources() {
        return Collections.unmodifiableCollection(this.dataSources);
    }

    public OsmPrimitive getPrimitiveById(long id, OsmPrimitiveType type) {
        return this.getPrimitiveById(new SimplePrimitiveId(id, type));
    }

    public OsmPrimitive getPrimitiveById(PrimitiveId primitiveId) {
        return primitiveId != null ? this.primitivesMap.get(primitiveId) : null;
    }

    private OsmPrimitive getPrimitiveByIdChecked(PrimitiveId primitiveId) {
        OsmPrimitive result = this.getPrimitiveById(primitiveId);
        if (result == null && primitiveId != null) {
            Logging.warn(I18n.tr("JOSM expected to find primitive [{0} {1}] in dataset but it is not there. Please report this at {2}. This is not a critical error, it should be safe to continue in your work.", new Object[]{primitiveId.getType(), Long.toString(primitiveId.getUniqueId()), Main.getJOSMWebsite()}));
            Logging.error(new Exception());
        }
        return result;
    }

    private static void deleteWay(Way way) {
        way.setNodes(null);
        way.setDeleted(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Way> unlinkNodeFromWays(Node node) {
        HashSet<Way> result = new HashSet<Way>();
        this.beginUpdate();
        try {
            for (Way way : node.getParentWays()) {
                List<Node> wayNodes = way.getNodes();
                if (!wayNodes.remove(node)) continue;
                if (wayNodes.size() < 2) {
                    DataSet.deleteWay(way);
                } else {
                    way.setNodes(wayNodes);
                }
                result.add(way);
            }
        }
        finally {
            this.endUpdate();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Relation> unlinkPrimitiveFromRelations(OsmPrimitive primitive) {
        HashSet<Relation> result = new HashSet<Relation>();
        this.beginUpdate();
        try {
            for (Relation relation : this.getRelations()) {
                List<RelationMember> members = relation.getMembers();
                Iterator<RelationMember> it = members.iterator();
                boolean removed = false;
                while (it.hasNext()) {
                    RelationMember member = it.next();
                    if (!member.getMember().equals(primitive)) continue;
                    it.remove();
                    removed = true;
                }
                if (!removed) continue;
                relation.setMembers(members);
                result.add(relation);
            }
        }
        finally {
            this.endUpdate();
        }
        return result;
    }

    public Set<OsmPrimitive> unlinkReferencesToPrimitive(OsmPrimitive referencedPrimitive) {
        HashSet<OsmPrimitive> result = new HashSet<OsmPrimitive>();
        this.beginUpdate();
        try {
            if (referencedPrimitive instanceof Node) {
                result.addAll(this.unlinkNodeFromWays((Node)referencedPrimitive));
            }
            result.addAll(this.unlinkPrimitiveFromRelations(referencedPrimitive));
        }
        finally {
            this.endUpdate();
        }
        return result;
    }

    public boolean isModified() {
        for (OsmPrimitive p : this.allPrimitives) {
            if (!p.isModified()) continue;
            return true;
        }
        return false;
    }

    public boolean requiresUploadToServer() {
        for (OsmPrimitive p : this.allPrimitives) {
            if (APIDataSet.APIOperation.of(p) == null) continue;
            return true;
        }
        return false;
    }

    public void addDataSetListener(DataSetListener dsl) {
        this.listeners.addIfAbsent(dsl);
    }

    public void removeDataSetListener(DataSetListener dsl) {
        this.listeners.remove(dsl);
    }

    public void beginUpdate() {
        this.lock.writeLock().lock();
        ++this.updateCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endUpdate() {
        if (this.updateCount > 0) {
            --this.updateCount;
            List<AbstractDatasetChangedEvent> eventsToFire = Collections.emptyList();
            if (this.updateCount == 0) {
                eventsToFire = new ArrayList<AbstractDatasetChangedEvent>(this.cachedEvents);
                this.cachedEvents.clear();
            }
            if (!eventsToFire.isEmpty()) {
                this.lock.readLock().lock();
                this.lock.writeLock().unlock();
                try {
                    if (eventsToFire.size() < 30) {
                        for (AbstractDatasetChangedEvent event : eventsToFire) {
                            this.fireEventToListeners(event);
                        }
                    }
                    if (eventsToFire.size() == 1000) {
                        this.fireEventToListeners(new DataChangedEvent(this));
                    }
                    this.fireEventToListeners(new DataChangedEvent(this, eventsToFire));
                }
                finally {
                    this.lock.readLock().unlock();
                }
            } else {
                this.lock.writeLock().unlock();
            }
        } else {
            throw new AssertionError((Object)"endUpdate called without beginUpdate");
        }
    }

    private void fireEventToListeners(AbstractDatasetChangedEvent event) {
        for (DataSetListener listener : this.listeners) {
            event.fire(listener);
        }
    }

    private void fireEvent(AbstractDatasetChangedEvent event) {
        if (this.updateCount == 0) {
            throw new AssertionError((Object)"dataset events can be fired only when dataset is locked");
        }
        if (this.cachedEvents.size() < 1000) {
            this.cachedEvents.add(event);
        }
    }

    void firePrimitivesAdded(Collection<? extends OsmPrimitive> added, boolean wasIncomplete) {
        this.fireEvent(new PrimitivesAddedEvent(this, added, wasIncomplete));
    }

    void firePrimitivesRemoved(Collection<? extends OsmPrimitive> removed, boolean wasComplete) {
        this.fireEvent(new PrimitivesRemovedEvent(this, removed, wasComplete));
    }

    void fireTagsChanged(OsmPrimitive prim, Map<String, String> originalKeys) {
        this.fireEvent(new TagsChangedEvent(this, prim, originalKeys));
    }

    void fireRelationMembersChanged(Relation r) {
        DataSet.reindexRelation(r);
        this.fireEvent(new RelationMembersChangedEvent(this, r));
    }

    void fireNodeMoved(Node node, LatLon newCoor, EastNorth eastNorth) {
        this.reindexNode(node, newCoor, eastNorth);
        this.fireEvent(new NodeMovedEvent(this, node));
    }

    void fireWayNodesChanged(Way way) {
        this.reindexWay(way);
        this.fireEvent(new WayNodesChangedEvent(this, way));
    }

    void fireChangesetIdChanged(OsmPrimitive primitive, int oldChangesetId, int newChangesetId) {
        this.fireEvent(new ChangesetIdChangedEvent(this, Collections.singletonList(primitive), oldChangesetId, newChangesetId));
    }

    void firePrimitiveFlagsChanged(OsmPrimitive primitive) {
        this.fireEvent(new PrimitiveFlagsChangedEvent(this, primitive));
    }

    void fireHighlightingChanged() {
        HighlightUpdateListener.HighlightUpdateEvent e = new HighlightUpdateListener.HighlightUpdateEvent(this);
        this.highlightUpdateListeners.fireEvent((T l) -> l.highlightUpdated(e));
    }

    public void invalidateEastNorthCache() {
        if (Main.getProjection() == null) {
            return;
        }
        this.beginUpdate();
        try {
            for (Node n : this.getNodes()) {
                n.invalidateEastNorthCache();
            }
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupDeletedPrimitives() {
        this.beginUpdate();
        try {
            Collection toCleanUp = this.getPrimitives(primitive -> primitive.isDeleted() && (!primitive.isVisible() || primitive.isNew()));
            if (!toCleanUp.isEmpty()) {
                this.clearSelection(toCleanUp.stream().map(AbstractPrimitive::getPrimitiveId));
                for (OsmPrimitive primitive2 : toCleanUp) {
                    this.removePrimitiveImpl(primitive2);
                }
                this.firePrimitivesRemoved(toCleanUp, false);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    @Override
    public void clear() {
        this.beginUpdate();
        try {
            this.clearSelection();
            for (OsmPrimitive primitive : this.allPrimitives) {
                primitive.setDataset(null);
            }
            super.clear();
            this.allPrimitives.clear();
        }
        finally {
            this.endUpdate();
        }
    }

    public void deleteInvisible() {
        for (OsmPrimitive primitive : this.allPrimitives) {
            if (primitive.isVisible()) continue;
            primitive.setDeleted(true);
        }
    }

    public void mergeFrom(DataSet from) {
        this.mergeFrom(from, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void mergeFrom(DataSet from, ProgressMonitor progressMonitor) {
        if (from != null) {
            new DataSetMerger(this, from).merge(progressMonitor);
            DataSet dataSet = from;
            synchronized (dataSet) {
                if (!from.dataSources.isEmpty()) {
                    if (this.dataSources.addAll(from.dataSources)) {
                        this.cachedDataSourceArea = null;
                        this.cachedDataSourceBounds = null;
                    }
                    from.dataSources.clear();
                    from.cachedDataSourceArea = null;
                    from.cachedDataSourceBounds = null;
                }
            }
        }
    }

    public ConflictCollection getConflicts() {
        return this.conflicts;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void projectionChanged(Projection oldValue, Projection newValue) {
        this.invalidateEastNorthCache();
    }

    public synchronized ProjectionBounds getDataSourceBoundingBox() {
        BoundingXYVisitor bbox = new BoundingXYVisitor();
        for (DataSource source : this.dataSources) {
            bbox.visit(source.bounds);
        }
        if (bbox.hasExtend()) {
            return bbox.getBounds();
        }
        return null;
    }

    public static enum UploadPolicy {
        NORMAL("true"),
        DISCOURAGED("false"),
        BLOCKED("never");

        final String xmlFlag;

        private UploadPolicy(String xmlFlag) {
            this.xmlFlag = xmlFlag;
        }

        public String getXmlFlag() {
            return this.xmlFlag;
        }
    }
}

