/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol;

import java.util.Arrays;
import java.util.List;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;

public class PermissionPrefWithDefault {
    public static final PermissionPrefWithDefault LOAD_DATA = new PermissionPrefWithDefault("remotecontrol.permission.load-data", true, I18n.tr("Load data from API", new Object[0]));
    public static final PermissionPrefWithDefault IMPORT_DATA = new PermissionPrefWithDefault("remotecontrol.permission.import", true, I18n.tr("Import data from URL", new Object[0]));
    public static final PermissionPrefWithDefault OPEN_FILES = new PermissionPrefWithDefault("remotecontrol.permission.open-files", false, I18n.tr("Open local files", new Object[0]));
    public static final PermissionPrefWithDefault LOAD_IMAGERY = new PermissionPrefWithDefault("remotecontrol.permission.imagery", true, I18n.tr("Load imagery layers", new Object[0]));
    public static final PermissionPrefWithDefault CHANGE_SELECTION = new PermissionPrefWithDefault("remotecontrol.permission.change-selection", true, I18n.tr("Change the selection", new Object[0]));
    public static final PermissionPrefWithDefault CHANGE_VIEWPORT = new PermissionPrefWithDefault("remotecontrol.permission.change-viewport", true, I18n.tr("Change the viewport", new Object[0]));
    public static final PermissionPrefWithDefault CREATE_OBJECTS = new PermissionPrefWithDefault("remotecontrol.permission.create-objects", true, I18n.tr("Create new objects", new Object[0]));
    public static final PermissionPrefWithDefault READ_PROTOCOL_VERSION = new PermissionPrefWithDefault("remotecontrol.permission.read-protocolversion", true, I18n.tr("Read protocol version", new Object[0]));
    public final String pref;
    public final boolean defaultVal;
    public final String preferenceText;

    public PermissionPrefWithDefault(String pref2, boolean defaultVal, String preferenceText) {
        this.pref = pref2;
        this.defaultVal = defaultVal;
        this.preferenceText = preferenceText;
    }

    public boolean isAllowed() {
        return Config.getPref().getBoolean(this.pref, this.defaultVal);
    }

    public static List<PermissionPrefWithDefault> getPermissionPrefs() {
        return Arrays.asList(LOAD_DATA, IMPORT_DATA, OPEN_FILES, LOAD_IMAGERY, CHANGE_SELECTION, CHANGE_VIEWPORT, CREATE_OBJECTS, READ_PROTOCOL_VERSION);
    }
}

