/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import org.jruby.RubyRational;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.ImmutableLiteral;
import org.jruby.ir.operands.OperandType;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class Rational
extends ImmutableLiteral {
    private final ImmutableLiteral numerator;
    private final ImmutableLiteral denominator;

    public Rational(ImmutableLiteral numerator2, ImmutableLiteral denominator2) {
        this.numerator = numerator2;
        this.denominator = denominator2;
    }

    @Override
    public OperandType getOperandType() {
        return OperandType.RATIONAL;
    }

    @Override
    public Object createCacheObject(ThreadContext context) {
        return RubyRational.newRationalRaw(context.runtime, (IRubyObject)this.numerator.cachedObject(context), (IRubyObject)this.denominator.cachedObject(context));
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        this.numerator.encode(e);
        this.denominator.encode(e);
    }

    public static Rational decode(IRReaderDecoder d) {
        return new Rational((ImmutableLiteral)d.decodeOperand(), (ImmutableLiteral)d.decodeOperand());
    }

    public String toString() {
        return "Rational:" + this.numerator + "/1";
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.Rational(this);
    }

    public ImmutableLiteral getNumerator() {
        return this.numerator;
    }

    public ImmutableLiteral getDenominator() {
        return this.denominator;
    }
}

