/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import java.util.List;
import org.jruby.RubyString;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.FrozenString;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.OperandType;
import org.jruby.ir.operands.Stringable;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class StringLiteral
extends Operand
implements Stringable {
    public static final StringLiteral EMPTY_STRING = new StringLiteral("");
    public final FrozenString frozenString;

    public StringLiteral(ByteList val, int coderange, String file2, int line) {
        this.frozenString = new FrozenString(val, coderange, file2, line);
    }

    protected StringLiteral(String string2, ByteList bytelist, int coderange, String file2, int line) {
        this.frozenString = new FrozenString(string2, bytelist, coderange, file2, line);
    }

    public StringLiteral(String s2) {
        this.frozenString = new FrozenString(s2);
    }

    private StringLiteral(FrozenString frozenString) {
        this.frozenString = frozenString;
    }

    @Override
    public OperandType getOperandType() {
        return OperandType.STRING_LITERAL;
    }

    @Override
    public boolean hasKnownValue() {
        return true;
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
    }

    public int hashCode() {
        return this.frozenString.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof StringLiteral && this.frozenString.equals(((StringLiteral)other).frozenString);
    }

    public String toString() {
        return "strdup(" + this.frozenString.toString() + ")";
    }

    @Override
    public Operand cloneForInlining(CloneInfo ii) {
        return this;
    }

    @Override
    public Object retrieve(ThreadContext context, IRubyObject self2, StaticScope currScope, DynamicScope currDynScope, Object[] temp) {
        RubyString string2 = (RubyString)this.frozenString.retrieve(context, self2, currScope, currDynScope, temp);
        return string2.strDup(context.runtime);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.StringLiteral(this);
    }

    public ByteList getByteList() {
        return this.frozenString.getByteList();
    }

    @Override
    public String getString() {
        return this.frozenString.getString();
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.frozenString);
    }

    public static StringLiteral decode(IRReaderDecoder d) {
        return new StringLiteral((FrozenString)d.decodeOperand());
    }

    public int getCodeRange() {
        return this.frozenString.getCodeRange();
    }
}

