/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.ProjectAwareFileFilter;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GlobalSearchScope
extends SearchScope
implements ProjectAwareFileFilter {
    @Nullable
    private final Project myProject;
    public static final GlobalSearchScope EMPTY_SCOPE = new EmptyScope();

    protected GlobalSearchScope(@Nullable Project project) {
        this.myProject = project;
    }

    protected GlobalSearchScope() {
        this(null);
    }

    @Override
    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    public abstract int compare(@NotNull VirtualFile var1, @NotNull VirtualFile var2);

    public abstract boolean isSearchInModuleContent(@NotNull Module var1);

    public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
        if (aModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/psi/search/GlobalSearchScope", "isSearchInModuleContent"));
        }
        return this.isSearchInModuleContent(aModule);
    }

    @Override
    public final boolean accept(VirtualFile file) {
        return this.contains(file);
    }

    public abstract boolean isSearchInLibraries();

    public boolean isForceSearchingInLibrarySources() {
        return false;
    }

    public boolean isSearchOutsideRootModel() {
        return false;
    }

    public Collection<Object> getUnloadedModulesBelongingToScope() {
        return Collections.emptySet();
    }

    @NotNull
    public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/GlobalSearchScope", "intersectWith"));
        }
        if (scope == this) {
            GlobalSearchScope globalSearchScope = this;
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope", "intersectWith"));
            }
            return globalSearchScope;
        }
        if (scope instanceof IntersectionScope && ((IntersectionScope)scope).containsScope(this)) {
            GlobalSearchScope globalSearchScope = scope;
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope", "intersectWith"));
            }
            return globalSearchScope;
        }
        IntersectionScope intersectionScope = new IntersectionScope(this, scope, null);
        if (intersectionScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope", "intersectWith"));
        }
        return intersectionScope;
    }

    @Override
    @NotNull
    public SearchScope intersectWith(@NotNull SearchScope scope2) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope2", "com/intellij/psi/search/GlobalSearchScope", "intersectWith"));
        }
        if (scope2 instanceof LocalSearchScope) {
            LocalSearchScope localScope2 = (LocalSearchScope)scope2;
            SearchScope searchScope = this.intersectWith(localScope2);
            if (searchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope", "intersectWith"));
            }
            return searchScope;
        }
        GlobalSearchScope globalSearchScope = this.intersectWith((GlobalSearchScope)scope2);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope", "intersectWith"));
        }
        return globalSearchScope;
    }

    @NotNull
    public SearchScope intersectWith(@NotNull LocalSearchScope localScope2) {
        if (localScope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localScope2", "com/intellij/psi/search/GlobalSearchScope", "intersectWith"));
        }
        PsiElement[] elements2 = localScope2.getScope();
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>(elements2.length);
        for (PsiElement element2 : elements2) {
            if (!PsiSearchScopeUtil.isInScope(this, element2)) continue;
            result2.add(element2);
        }
        SearchScope searchScope = result2.isEmpty() ? EMPTY_SCOPE : new LocalSearchScope(result2.toArray(new PsiElement[result2.size()]), null, localScope2.isIgnoreInjectedPsi());
        if (searchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope", "intersectWith"));
        }
        return searchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope union(@NotNull SearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/GlobalSearchScope", "union"));
        }
        if (scope instanceof GlobalSearchScope) {
            GlobalSearchScope globalSearchScope = this.uniteWith((GlobalSearchScope)scope);
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope", "union"));
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = this.union((LocalSearchScope)scope);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope", "union"));
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope union(final @NotNull LocalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/GlobalSearchScope", "union"));
        }
        PsiElement[] localScopeElements = scope.getScope();
        if (localScopeElements.length == 0) {
            GlobalSearchScope globalSearchScope = this;
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope", "union"));
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = new GlobalSearchScope(localScopeElements[0].getProject()){

            @Override
            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/search/GlobalSearchScope$1", "contains"));
                }
                return GlobalSearchScope.this.contains(file) || scope.isInScope(file);
            }

            @Override
            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                if (file1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/psi/search/GlobalSearchScope$1", "compare"));
                }
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/psi/search/GlobalSearchScope$1", "compare"));
                }
                return GlobalSearchScope.this.contains(file1) && GlobalSearchScope.this.contains(file2) ? GlobalSearchScope.this.compare(file1, file2) : 0;
            }

            @Override
            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/psi/search/GlobalSearchScope$1", "isSearchInModuleContent"));
                }
                return GlobalSearchScope.this.isSearchInModuleContent(aModule);
            }

            @Override
            public boolean isSearchOutsideRootModel() {
                return GlobalSearchScope.this.isSearchOutsideRootModel();
            }

            @Override
            public boolean isSearchInLibraries() {
                return GlobalSearchScope.this.isSearchInLibraries();
            }

            @Override
            public Collection<Object> getUnloadedModulesBelongingToScope() {
                return GlobalSearchScope.this.getUnloadedModulesBelongingToScope();
            }

            @NonNls
            public String toString() {
                return "UnionToLocal: (" + GlobalSearchScope.this + ", " + scope + ")";
            }
        };
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope", "union"));
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/GlobalSearchScope", "uniteWith"));
        }
        if (scope == this) {
            GlobalSearchScope globalSearchScope = scope;
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope", "uniteWith"));
            }
            return globalSearchScope;
        }
        UnionScope unionScope = new UnionScope(this, scope);
        if (unionScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope", "uniteWith"));
        }
        return unionScope;
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope union(@NotNull GlobalSearchScope[] scopes) {
        if (scopes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopes", "com/intellij/psi/search/GlobalSearchScope", "union"));
        }
        if (scopes.length == 0) {
            throw new IllegalArgumentException("Empty scope array");
        }
        if (scopes.length == 1) {
            GlobalSearchScope globalSearchScope = scopes[0];
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope", "union"));
            }
            return globalSearchScope;
        }
        UnionScope unionScope = new UnionScope(scopes);
        if (unionScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope", "union"));
        }
        return unionScope;
    }

    @NotNull
    public static GlobalSearchScope allScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/GlobalSearchScope", "allScope"));
        }
        GlobalSearchScope globalSearchScope = ProjectScope.getAllScope(project);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope", "allScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope projectScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/GlobalSearchScope", "projectScope"));
        }
        GlobalSearchScope globalSearchScope = ProjectScope.getProjectScope(project);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope", "projectScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope everythingScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/GlobalSearchScope", "everythingScope"));
        }
        GlobalSearchScope globalSearchScope = ProjectScope.getEverythingScope(project);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope", "everythingScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope notScope(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/GlobalSearchScope", "notScope"));
        }
        NotScope notScope = new NotScope(scope);
        if (notScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope", "notScope"));
        }
        return notScope;
    }

    @NotNull
    public static GlobalSearchScope moduleScope(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/psi/search/GlobalSearchScope", "moduleScope"));
        }
        GlobalSearchScope globalSearchScope = module2.getModuleScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope", "moduleScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope moduleWithLibrariesScope(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/psi/search/GlobalSearchScope", "moduleWithLibrariesScope"));
        }
        GlobalSearchScope globalSearchScope = module2.getModuleWithLibrariesScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope", "moduleWithLibrariesScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope moduleWithDependenciesScope(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/psi/search/GlobalSearchScope", "moduleWithDependenciesScope"));
        }
        GlobalSearchScope globalSearchScope = module2.getModuleWithDependenciesScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope", "moduleWithDependenciesScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope moduleRuntimeScope(@NotNull Module module2, boolean includeTests) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/psi/search/GlobalSearchScope", "moduleRuntimeScope"));
        }
        GlobalSearchScope globalSearchScope = module2.getModuleRuntimeScope(includeTests);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope", "moduleRuntimeScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope moduleWithDependenciesAndLibrariesScope(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/psi/search/GlobalSearchScope", "moduleWithDependenciesAndLibrariesScope"));
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope(module2, true);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope", "moduleWithDependenciesAndLibrariesScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope moduleWithDependenciesAndLibrariesScope(@NotNull Module module2, boolean includeTests) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/psi/search/GlobalSearchScope", "moduleWithDependenciesAndLibrariesScope"));
        }
        GlobalSearchScope globalSearchScope = module2.getModuleWithDependenciesAndLibrariesScope(includeTests);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope", "moduleWithDependenciesAndLibrariesScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope moduleWithDependentsScope(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/psi/search/GlobalSearchScope", "moduleWithDependentsScope"));
        }
        GlobalSearchScope globalSearchScope = module2.getModuleWithDependentsScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope", "moduleWithDependentsScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope moduleTestsWithDependentsScope(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/psi/search/GlobalSearchScope", "moduleTestsWithDependentsScope"));
        }
        GlobalSearchScope globalSearchScope = module2.getModuleTestsWithDependentsScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope", "moduleTestsWithDependentsScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope fileScope(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/psi/search/GlobalSearchScope", "fileScope"));
        }
        FileScope fileScope = new FileScope(psiFile.getProject(), psiFile.getVirtualFile());
        if (fileScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope", "fileScope"));
        }
        return fileScope;
    }

    @NotNull
    public static GlobalSearchScope fileScope(@NotNull Project project, VirtualFile virtualFile2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/GlobalSearchScope", "fileScope"));
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope(project, virtualFile2, null);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope", "fileScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope fileScope(@NotNull Project project, @Nullable VirtualFile virtualFile2, final @Nullable String displayName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/GlobalSearchScope", "fileScope"));
        }
        FileScope fileScope = new FileScope(project, virtualFile2){

            @Override
            @NotNull
            public String getDisplayName() {
                String string = displayName == null ? super.getDisplayName() : displayName;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope$2", "getDisplayName"));
                }
                return string;
            }
        };
        if (fileScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope", "fileScope"));
        }
        return fileScope;
    }

    @NotNull
    public static GlobalSearchScope filesScope(@NotNull Project project, @NotNull Collection<VirtualFile> files2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/GlobalSearchScope", "filesScope"));
        }
        if (files2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/psi/search/GlobalSearchScope", "filesScope"));
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.filesScope(project, files2, null);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope", "filesScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope filesWithoutLibrariesScope(@NotNull Project project, @NotNull Collection<VirtualFile> files2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/GlobalSearchScope", "filesWithoutLibrariesScope"));
        }
        if (files2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/psi/search/GlobalSearchScope", "filesWithoutLibrariesScope"));
        }
        if (files2.isEmpty()) {
            GlobalSearchScope globalSearchScope = EMPTY_SCOPE;
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope", "filesWithoutLibrariesScope"));
            }
            return globalSearchScope;
        }
        FilesScope filesScope = new FilesScope(project, files2, false);
        if (filesScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope", "filesWithoutLibrariesScope"));
        }
        return filesScope;
    }

    @NotNull
    public static GlobalSearchScope filesWithLibrariesScope(@NotNull Project project, @NotNull Collection<VirtualFile> files2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/GlobalSearchScope", "filesWithLibrariesScope"));
        }
        if (files2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/psi/search/GlobalSearchScope", "filesWithLibrariesScope"));
        }
        if (files2.isEmpty()) {
            GlobalSearchScope globalSearchScope = EMPTY_SCOPE;
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope", "filesWithLibrariesScope"));
            }
            return globalSearchScope;
        }
        FilesScope filesScope = new FilesScope(project, files2, true);
        if (filesScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope", "filesWithLibrariesScope"));
        }
        return filesScope;
    }

    @NotNull
    public static GlobalSearchScope filesScope(@NotNull Project project, @NotNull Collection<VirtualFile> files2, final @Nullable String displayName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/GlobalSearchScope", "filesScope"));
        }
        if (files2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/psi/search/GlobalSearchScope", "filesScope"));
        }
        if (files2.isEmpty()) {
            GlobalSearchScope globalSearchScope = EMPTY_SCOPE;
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope", "filesScope"));
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = files2.size() == 1 ? GlobalSearchScope.fileScope(project, files2.iterator().next(), displayName) : new FilesScope(project, files2){

            @Override
            @NotNull
            public String getDisplayName() {
                String string = displayName == null ? super.getDisplayName() : displayName;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope$3", "getDisplayName"));
                }
                return string;
            }
        };
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope", "filesScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope getScopeRestrictedByFileTypes(@NotNull GlobalSearchScope scope, FileType ... fileTypes) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/GlobalSearchScope", "getScopeRestrictedByFileTypes"));
        }
        if (fileTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTypes", "com/intellij/psi/search/GlobalSearchScope", "getScopeRestrictedByFileTypes"));
        }
        if (scope == EMPTY_SCOPE) {
            GlobalSearchScope globalSearchScope = EMPTY_SCOPE;
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope", "getScopeRestrictedByFileTypes"));
            }
            return globalSearchScope;
        }
        if (fileTypes.length == 0) {
            throw new IllegalArgumentException("empty fileTypes");
        }
        FileTypeRestrictionScope fileTypeRestrictionScope = new FileTypeRestrictionScope(scope, fileTypes);
        if (fileTypeRestrictionScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope", "getScopeRestrictedByFileTypes"));
        }
        return fileTypeRestrictionScope;
    }

    public static class FilesScope
    extends GlobalSearchScope
    implements Iterable<VirtualFile> {
        private final Collection<VirtualFile> myFiles;
        private volatile Boolean myHasFilesOutOfProjectRoots;

        public FilesScope(@Nullable Project project, @NotNull Collection<VirtualFile> files2) {
            if (files2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/psi/search/GlobalSearchScope$FilesScope", "<init>"));
            }
            this(project, files2, null);
        }

        private FilesScope(@Nullable Project project, @NotNull Collection<VirtualFile> files2, @Nullable Boolean hasFilesOutOfProjectRoots) {
            if (files2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/psi/search/GlobalSearchScope$FilesScope", "<init>"));
            }
            super(project);
            this.myFiles = files2;
            this.myHasFilesOutOfProjectRoots = hasFilesOutOfProjectRoots;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/search/GlobalSearchScope$FilesScope", "contains"));
            }
            return this.myFiles.contains(file);
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/psi/search/GlobalSearchScope$FilesScope", "compare"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/psi/search/GlobalSearchScope$FilesScope", "compare"));
            }
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/psi/search/GlobalSearchScope$FilesScope", "isSearchInModuleContent"));
            }
            return true;
        }

        @Override
        public boolean isSearchInLibraries() {
            return this.hasFilesOutOfProjectRoots();
        }

        public boolean equals(Object o) {
            return this == o || o instanceof FilesScope && this.myFiles.equals(((FilesScope)o).myFiles);
        }

        @Override
        public int hashCode() {
            return this.myFiles.hashCode();
        }

        private boolean hasFilesOutOfProjectRoots() {
            Boolean result2 = this.myHasFilesOutOfProjectRoots;
            if (result2 == null) {
                Project project = this.getProject();
                this.myHasFilesOutOfProjectRoots = result2 = Boolean.valueOf(project != null && !project.isDefault() && this.myFiles.stream().anyMatch(file -> FileIndexFacade.getInstance(project).getModuleForFile((VirtualFile)file) == null));
            }
            return result2;
        }

        public String toString() {
            ArrayList<VirtualFile> files2 = this.myFiles.size() <= 20 ? new ArrayList<VirtualFile>(this.myFiles) : new ArrayList<VirtualFile>(this.myFiles).subList(0, 20);
            return "Files: (" + files2 + "); search in libraries: " + (this.myHasFilesOutOfProjectRoots != null ? this.myHasFilesOutOfProjectRoots : "unknown");
        }

        @Override
        @NotNull
        public Iterator<VirtualFile> iterator() {
            Iterator<VirtualFile> iterator2 = this.myFiles.iterator();
            if (iterator2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope$FilesScope", "iterator"));
            }
            return iterator2;
        }
    }

    private static class FileScope
    extends GlobalSearchScope
    implements Iterable<VirtualFile> {
        private final VirtualFile myVirtualFile;
        private final Module myModule;
        private final boolean mySearchOutsideContent;

        private FileScope(@NotNull Project project, @Nullable VirtualFile virtualFile2) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/GlobalSearchScope$FileScope", "<init>"));
            }
            super(project);
            this.myVirtualFile = virtualFile2;
            FileIndexFacade facade = FileIndexFacade.getInstance(project);
            this.myModule = virtualFile2 == null || project.isDefault() ? null : facade.getModuleForFile(virtualFile2);
            this.mySearchOutsideContent = virtualFile2 != null && this.myModule == null && !facade.isInLibraryClasses(virtualFile2) && !facade.isInLibrarySource(virtualFile2);
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/search/GlobalSearchScope$FileScope", "contains"));
            }
            return Comparing.equal(this.myVirtualFile, file);
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/psi/search/GlobalSearchScope$FileScope", "compare"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/psi/search/GlobalSearchScope$FileScope", "compare"));
            }
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/psi/search/GlobalSearchScope$FileScope", "isSearchInModuleContent"));
            }
            return aModule == this.myModule;
        }

        @Override
        public boolean isSearchInLibraries() {
            return this.myModule == null;
        }

        public String toString() {
            return "File :" + this.myVirtualFile;
        }

        @Override
        @NotNull
        public Iterator<VirtualFile> iterator() {
            Iterator<VirtualFile> iterator2 = Collections.singletonList(this.myVirtualFile).iterator();
            if (iterator2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope$FileScope", "iterator"));
            }
            return iterator2;
        }

        @Override
        public boolean isSearchOutsideRootModel() {
            return this.mySearchOutsideContent;
        }
    }

    private static class EmptyScope
    extends GlobalSearchScope {
        private EmptyScope() {
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/search/GlobalSearchScope$EmptyScope", "contains"));
            }
            return false;
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/psi/search/GlobalSearchScope$EmptyScope", "compare"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/psi/search/GlobalSearchScope$EmptyScope", "compare"));
            }
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/psi/search/GlobalSearchScope$EmptyScope", "isSearchInModuleContent"));
            }
            return false;
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }

        @Override
        @NotNull
        public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/GlobalSearchScope$EmptyScope", "intersectWith"));
            }
            EmptyScope emptyScope = this;
            if (emptyScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope$EmptyScope", "intersectWith"));
            }
            return emptyScope;
        }

        @Override
        @NotNull
        public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/GlobalSearchScope$EmptyScope", "uniteWith"));
            }
            GlobalSearchScope globalSearchScope = scope;
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope$EmptyScope", "uniteWith"));
            }
            return globalSearchScope;
        }

        public String toString() {
            return "EMPTY";
        }
    }

    private static class FileTypeRestrictionScope
    extends DelegatingGlobalSearchScope {
        private final FileType[] myFileTypes;

        private FileTypeRestrictionScope(@NotNull GlobalSearchScope scope, @NotNull FileType[] fileTypes) {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/GlobalSearchScope$FileTypeRestrictionScope", "<init>"));
            }
            if (fileTypes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTypes", "com/intellij/psi/search/GlobalSearchScope$FileTypeRestrictionScope", "<init>"));
            }
            super(scope);
            this.myFileTypes = fileTypes;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/search/GlobalSearchScope$FileTypeRestrictionScope", "contains"));
            }
            if (!super.contains(file)) {
                return false;
            }
            FileType fileType = file.getFileType();
            for (FileType otherFileType : this.myFileTypes) {
                if (!fileType.equals(otherFileType)) continue;
                return true;
            }
            return false;
        }

        @Override
        @NotNull
        public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/GlobalSearchScope$FileTypeRestrictionScope", "intersectWith"));
            }
            if (scope instanceof FileTypeRestrictionScope) {
                FileTypeRestrictionScope restrict = (FileTypeRestrictionScope)scope;
                if (restrict.myBaseScope == this.myBaseScope) {
                    ArrayList<FileType> intersection = new ArrayList<FileType>(Arrays.asList(restrict.myFileTypes));
                    intersection.retainAll(Arrays.asList(this.myFileTypes));
                    FileTypeRestrictionScope fileTypeRestrictionScope = new FileTypeRestrictionScope(this.myBaseScope, intersection.toArray(new FileType[intersection.size()]));
                    if (fileTypeRestrictionScope == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope$FileTypeRestrictionScope", "intersectWith"));
                    }
                    return fileTypeRestrictionScope;
                }
            }
            GlobalSearchScope globalSearchScope = super.intersectWith(scope);
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope$FileTypeRestrictionScope", "intersectWith"));
            }
            return globalSearchScope;
        }

        @Override
        @NotNull
        public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/GlobalSearchScope$FileTypeRestrictionScope", "uniteWith"));
            }
            if (scope instanceof FileTypeRestrictionScope) {
                FileTypeRestrictionScope restrict = (FileTypeRestrictionScope)scope;
                if (restrict.myBaseScope == this.myBaseScope) {
                    FileTypeRestrictionScope fileTypeRestrictionScope = new FileTypeRestrictionScope(this.myBaseScope, ArrayUtil.mergeArrays(this.myFileTypes, restrict.myFileTypes));
                    if (fileTypeRestrictionScope == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope$FileTypeRestrictionScope", "uniteWith"));
                    }
                    return fileTypeRestrictionScope;
                }
            }
            GlobalSearchScope globalSearchScope = super.uniteWith(scope);
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope$FileTypeRestrictionScope", "uniteWith"));
            }
            return globalSearchScope;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FileTypeRestrictionScope)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FileTypeRestrictionScope that = (FileTypeRestrictionScope)o;
            return Arrays.equals(this.myFileTypes, that.myFileTypes);
        }

        @Override
        public int hashCode() {
            int result2 = super.hashCode();
            result2 = 31 * result2 + Arrays.hashCode(this.myFileTypes);
            return result2;
        }

        @Override
        public String toString() {
            return "(restricted by file types: " + Arrays.asList(this.myFileTypes) + " in " + this.myBaseScope + ")";
        }
    }

    private static class UnionScope
    extends GlobalSearchScope {
        private final GlobalSearchScope[] myScopes;
        private final int myNestingLevel;

        private UnionScope(@NotNull GlobalSearchScope scope1, @NotNull GlobalSearchScope scope2) {
            if (scope1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope1", "com/intellij/psi/search/GlobalSearchScope$UnionScope", "<init>"));
            }
            if (scope2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope2", "com/intellij/psi/search/GlobalSearchScope$UnionScope", "<init>"));
            }
            this(new GlobalSearchScope[]{scope1, scope2});
        }

        private UnionScope(@NotNull GlobalSearchScope[] scopes) {
            if (scopes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopes", "com/intellij/psi/search/GlobalSearchScope$UnionScope", "<init>"));
            }
            super(ContainerUtil.getFirstItem(ContainerUtil.mapNotNull(scopes, scope -> scope.getProject()), null));
            if (scopes.length <= 1) {
                throw new IllegalArgumentException("Too few scopes: " + Arrays.asList(scopes));
            }
            this.myScopes = scopes;
            final int[] nested = new int[]{0};
            ContainerUtil.process(scopes, new Processor<GlobalSearchScope>(){

                @Override
                public boolean process(GlobalSearchScope scope) {
                    nested[0] = Math.max(nested[0], scope instanceof UnionScope ? ((UnionScope)scope).myNestingLevel : 0);
                    return true;
                }
            });
            this.myNestingLevel = 1 + nested[0];
            if (this.myNestingLevel > 1000) {
                throw new IllegalStateException("Too many scopes combined: " + this.myNestingLevel + StringUtil.last(this.toString(), 500, true));
            }
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string = PsiBundle.message("psi.search.scope.union", this.myScopes[0].getDisplayName(), this.myScopes[1].getDisplayName());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope$UnionScope", "getDisplayName"));
            }
            return string;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/search/GlobalSearchScope$UnionScope", "contains"));
            }
            return ContainerUtil.find(this.myScopes, scope -> {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/search/GlobalSearchScope$UnionScope", "lambda$contains$1"));
                }
                return scope.contains(file);
            }) != null;
        }

        @Override
        public boolean isSearchOutsideRootModel() {
            return ContainerUtil.find(this.myScopes, scope -> scope.isSearchOutsideRootModel()) != null;
        }

        @Override
        public Collection<Object> getUnloadedModulesBelongingToScope() {
            LinkedHashSet<Object> result2 = new LinkedHashSet<Object>();
            for (GlobalSearchScope scope : this.myScopes) {
                result2.addAll(scope.getUnloadedModulesBelongingToScope());
            }
            return result2;
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/psi/search/GlobalSearchScope$UnionScope", "compare"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/psi/search/GlobalSearchScope$UnionScope", "compare"));
            }
            int[] result2 = new int[]{0};
            ContainerUtil.process(this.myScopes, scope -> {
                int res1;
                if (file1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/psi/search/GlobalSearchScope$UnionScope", "lambda$compare$3"));
                }
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/psi/search/GlobalSearchScope$UnionScope", "lambda$compare$3"));
                }
                int n = res1 = scope.contains(file1) && scope.contains(file2) ? scope.compare(file1, file2) : 0;
                if (result2[0] == 0) {
                    result2[0] = res1;
                    return true;
                }
                if (result2[0] > 0 != res1 > 0) {
                    result2[0] = 0;
                    return false;
                }
                return true;
            });
            return result2[0];
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module module2) {
            if (module2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/psi/search/GlobalSearchScope$UnionScope", "isSearchInModuleContent"));
            }
            return ContainerUtil.find(this.myScopes, scope -> {
                if (module2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/psi/search/GlobalSearchScope$UnionScope", "lambda$isSearchInModuleContent$4"));
                }
                return scope.isSearchInModuleContent(module2);
            }) != null;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module module2, boolean testSources) {
            if (module2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/psi/search/GlobalSearchScope$UnionScope", "isSearchInModuleContent"));
            }
            return ContainerUtil.find(this.myScopes, scope -> {
                if (module2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/psi/search/GlobalSearchScope$UnionScope", "lambda$isSearchInModuleContent$5"));
                }
                return scope.isSearchInModuleContent(module2, testSources);
            }) != null;
        }

        @Override
        public boolean isSearchInLibraries() {
            return ContainerUtil.find(this.myScopes, scope -> scope.isSearchInLibraries()) != null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UnionScope)) {
                return false;
            }
            UnionScope that = (UnionScope)o;
            return new HashSet<GlobalSearchScope>(Arrays.asList(this.myScopes)).equals(new HashSet<GlobalSearchScope>(Arrays.asList(that.myScopes)));
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.myScopes);
        }

        @NonNls
        public String toString() {
            return "Union: (" + StringUtil.join(Arrays.asList(this.myScopes), ",") + ")";
        }

        @Override
        @NotNull
        public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/GlobalSearchScope$UnionScope", "uniteWith"));
            }
            if (scope instanceof UnionScope) {
                GlobalSearchScope[] newScopes = ArrayUtil.mergeArrays(this.myScopes, ((UnionScope)scope).myScopes);
                UnionScope unionScope = new UnionScope(newScopes);
                if (unionScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope$UnionScope", "uniteWith"));
                }
                return unionScope;
            }
            GlobalSearchScope globalSearchScope = super.uniteWith(scope);
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope$UnionScope", "uniteWith"));
            }
            return globalSearchScope;
        }
    }

    private static class IntersectionScope
    extends GlobalSearchScope {
        private final GlobalSearchScope myScope1;
        private final GlobalSearchScope myScope2;
        private final String myDisplayName;

        private IntersectionScope(@NotNull GlobalSearchScope scope1, @NotNull GlobalSearchScope scope2, String displayName) {
            if (scope1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope1", "com/intellij/psi/search/GlobalSearchScope$IntersectionScope", "<init>"));
            }
            if (scope2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope2", "com/intellij/psi/search/GlobalSearchScope$IntersectionScope", "<init>"));
            }
            super(scope1.getProject() == null ? scope2.getProject() : scope1.getProject());
            this.myScope1 = scope1;
            this.myScope2 = scope2;
            this.myDisplayName = displayName;
        }

        @Override
        @NotNull
        public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/GlobalSearchScope$IntersectionScope", "intersectWith"));
            }
            IntersectionScope intersectionScope = this.containsScope(scope) ? this : new IntersectionScope(this, scope, null);
            if (intersectionScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope$IntersectionScope", "intersectWith"));
            }
            return intersectionScope;
        }

        private boolean containsScope(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/GlobalSearchScope$IntersectionScope", "containsScope"));
            }
            if (this.myScope1.equals(scope) || this.myScope2.equals(scope) || this.equals(scope)) {
                return true;
            }
            if (this.myScope1 instanceof IntersectionScope && ((IntersectionScope)this.myScope1).containsScope(scope)) {
                return true;
            }
            return this.myScope2 instanceof IntersectionScope && ((IntersectionScope)this.myScope2).containsScope(scope);
        }

        @Override
        @NotNull
        public String getDisplayName() {
            if (this.myDisplayName == null) {
                String string = PsiBundle.message("psi.search.scope.intersection", this.myScope1.getDisplayName(), this.myScope2.getDisplayName());
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope$IntersectionScope", "getDisplayName"));
                }
                return string;
            }
            String string = this.myDisplayName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope$IntersectionScope", "getDisplayName"));
            }
            return string;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/search/GlobalSearchScope$IntersectionScope", "contains"));
            }
            return this.myScope1.contains(file) && this.myScope2.contains(file);
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/psi/search/GlobalSearchScope$IntersectionScope", "compare"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/psi/search/GlobalSearchScope$IntersectionScope", "compare"));
            }
            int res1 = this.myScope1.compare(file1, file2);
            int res2 = this.myScope2.compare(file1, file2);
            if (res1 == 0) {
                return res2;
            }
            if (res2 == 0) {
                return res1;
            }
            if ((res1 /= Math.abs(res1)) == (res2 /= Math.abs(res2))) {
                return res1;
            }
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/psi/search/GlobalSearchScope$IntersectionScope", "isSearchInModuleContent"));
            }
            return this.myScope1.isSearchInModuleContent(aModule) && this.myScope2.isSearchInModuleContent(aModule);
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
            if (aModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/psi/search/GlobalSearchScope$IntersectionScope", "isSearchInModuleContent"));
            }
            return this.myScope1.isSearchInModuleContent(aModule, testSources) && this.myScope2.isSearchInModuleContent(aModule, testSources);
        }

        @Override
        public boolean isSearchInLibraries() {
            return this.myScope1.isSearchInLibraries() && this.myScope2.isSearchInLibraries();
        }

        @Override
        public boolean isSearchOutsideRootModel() {
            return this.myScope1.isSearchOutsideRootModel() && this.myScope2.isSearchOutsideRootModel();
        }

        @Override
        public Collection<Object> getUnloadedModulesBelongingToScope() {
            return ContainerUtil.intersection(this.myScope1.getUnloadedModulesBelongingToScope(), this.myScope2.getUnloadedModulesBelongingToScope());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IntersectionScope)) {
                return false;
            }
            IntersectionScope that = (IntersectionScope)o;
            return this.myScope1.equals(that.myScope1) && this.myScope2.equals(that.myScope2);
        }

        @Override
        public int hashCode() {
            return 31 * this.myScope1.hashCode() + this.myScope2.hashCode();
        }

        @NonNls
        public String toString() {
            return "Intersection: (" + this.myScope1 + ", " + this.myScope2 + ")";
        }
    }

    private static class NotScope
    extends DelegatingGlobalSearchScope {
        private NotScope(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/GlobalSearchScope$NotScope", "<init>"));
            }
            super(scope);
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/search/GlobalSearchScope$NotScope", "contains"));
            }
            return !this.myBaseScope.contains(file);
        }

        @Override
        public boolean isSearchInLibraries() {
            return true;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
            if (aModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/psi/search/GlobalSearchScope$NotScope", "isSearchInModuleContent"));
            }
            return true;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/psi/search/GlobalSearchScope$NotScope", "isSearchInModuleContent"));
            }
            return true;
        }

        @Override
        public boolean isSearchOutsideRootModel() {
            return true;
        }

        @Override
        public String toString() {
            return "NOT: " + this.myBaseScope;
        }
    }
}

