/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.common;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TableSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0018\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0002\u0010\nJ\u0019\u0010&\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\r0\f\u00a2\u0006\u0002\u0010\u000fJ\b\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020\u0007H\u0002J\u0016\u0010+\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\r2\u0006\u0010,\u001a\u00020-J\u0018\u0010.\u001a\u00020(2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u0007H\u0014J&\u0010/\u001a\u00020(2\f\u00100\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010*\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u001e\u00101\u001a\u00020(2\u0006\u0010,\u001a\u00020\u001e2\f\u00102\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u0002J\u001e\u00103\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u00104\u001a\u00020\u001e2\u0006\u00105\u001a\u00020\u001eH\u0014J\u001e\u00103\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u000e\u00106\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\rH\u0014J&\u00107\u001a\u00020(2\f\u00100\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010,\u001a\u00020\u001e2\u0006\u00108\u001a\u00020\u001eH\u0002J\u0018\u00109\u001a\u00020:2\u0006\u0010,\u001a\u00020\u001e2\u0006\u0010;\u001a\u00020\u001eH\u0014J\u0018\u0010<\u001a\u00020:2\u0006\u0010,\u001a\u00020\u001e2\u0006\u0010;\u001a\u00020\u001eH\u0014J\u0018\u0010<\u001a\u00020:2\u0006\u0010,\u001a\u00020\u001e2\u0006\u0010=\u001a\u00020\u0013H\u0014J.\u0010>\u001a\u00020(2\u0006\u0010?\u001a\u00020@2\f\u00100\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010,\u001a\u00020\u001e2\u0006\u0010A\u001a\u00020\u001eH\u0002J&\u0010B\u001a\u00020(2\u0006\u0010?\u001a\u00020C2\f\u00100\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010,\u001a\u00020\u001eH\u0002J\u001e\u0010D\u001a\u00020(2\f\u0010E\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010,\u001a\u00020\u001eH\u0002J\u001e\u0010F\u001a\u00020(2\f\u00100\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010,\u001a\u00020\u001eH\u0002J&\u0010G\u001a\u00020(2\u0006\u0010?\u001a\u00020H2\f\u00100\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010,\u001a\u00020\u001eH\u0002R!\u0010\u000b\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\r0\f\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00120\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/common/MethodAnalyzer;", "V", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Value;", "", "owner", "", "method", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "interpreter", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Interpreter;", "(Ljava/lang/String;Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;Lorg/jetbrains/org/objectweb/asm/tree/analysis/Interpreter;)V", "frames", "", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "getFrames", "()[Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "[Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "handlers", "", "Lorg/jetbrains/org/objectweb/asm/tree/TryCatchBlockNode;", "[Ljava/util/List;", "instructions", "Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "getInstructions", "()Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "getInterpreter", "()Lorg/jetbrains/org/objectweb/asm/tree/analysis/Interpreter;", "getMethod", "()Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "nInsns", "", "getOwner", "()Ljava/lang/String;", "queue", "", "queued", "", "top", "analyze", "checkAssertions", "", "computeExceptionHandlersForEachInsn", "m", "getFrame", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "init", "initControlFlowAnalysis", "current", "mergeControlFlowEdge", "frame", "newFrame", "nLocals", "nStack", "src", "processControlFlowEdge", "jump", "visitControlFlowEdge", "", "successor", "visitControlFlowExceptionEdge", "tcb", "visitJumpInsnNode", "insnNode", "Lorg/jetbrains/org/objectweb/asm/tree/JumpInsnNode;", "insnOpcode", "visitLookupSwitchInsnNode", "Lorg/jetbrains/org/objectweb/asm/tree/LookupSwitchInsnNode;", "visitNopInsn", "f", "visitOpInsn", "visitTableSwitchInsnNode", "Lorg/jetbrains/org/objectweb/asm/tree/TableSwitchInsnNode;", "backend"})
public class MethodAnalyzer<V extends Value> {
    @NotNull
    private final InsnList instructions;
    private final int nInsns;
    @NotNull
    private final Frame<V>[] frames;
    private final List<TryCatchBlockNode>[] handlers;
    private final boolean[] queued;
    private final int[] queue;
    private int top;
    @NotNull
    private final String owner;
    @NotNull
    private final MethodNode method;
    @NotNull
    private final Interpreter<V> interpreter;

    @NotNull
    public final InsnList getInstructions() {
        return this.instructions;
    }

    @NotNull
    public final Frame<V>[] getFrames() {
        return this.frames;
    }

    protected void init(@NotNull String owner, @NotNull MethodNode m) {
        Intrinsics.checkParameterIsNotNull(owner, "owner");
        Intrinsics.checkParameterIsNotNull(m, "m");
    }

    @NotNull
    protected Frame<V> newFrame(int nLocals, int nStack) {
        return new Frame(nLocals, nStack);
    }

    @NotNull
    protected Frame<V> newFrame(@NotNull Frame<? extends V> src) {
        Intrinsics.checkParameterIsNotNull(src, "src");
        Frame<V> frame = this.newFrame(src.getLocals(), src.getMaxStackSize());
        frame.init(src);
        return frame;
    }

    protected boolean visitControlFlowEdge(int insn, int successor) {
        return true;
    }

    protected boolean visitControlFlowExceptionEdge(int insn, int successor) {
        return true;
    }

    protected boolean visitControlFlowExceptionEdge(int insn, @NotNull TryCatchBlockNode tcb) {
        Intrinsics.checkParameterIsNotNull(tcb, "tcb");
        return this.visitControlFlowExceptionEdge(insn, this.instructions.indexOf(tcb.handler));
    }

    @NotNull
    public final Frame<V>[] analyze() {
        if (this.nInsns == 0) {
            return this.frames;
        }
        this.checkAssertions();
        this.computeExceptionHandlersForEachInsn(this.method);
        Frame<V> current = this.newFrame(this.method.maxLocals, this.method.maxStack);
        Frame<V> handler2 = this.newFrame(this.method.maxLocals, this.method.maxStack);
        this.initControlFlowAnalysis(current, this.method, this.owner);
        while (this.top > 0) {
            MethodAnalyzer methodAnalyzer = this;
            methodAnalyzer.top += -1;
            int insn = this.queue[methodAnalyzer.top];
            if (this.frames[insn] == null) {
                Intrinsics.throwNpe();
            }
            this.queued[insn] = false;
            AbstractInsnNode insnNode = this.method.instructions.get(insn);
            try {
                Frame<V> f;
                AbstractInsnNode abstractInsnNode = insnNode;
                Intrinsics.checkExpressionValueIsNotNull(abstractInsnNode, "insnNode");
                int insnOpcode = abstractInsnNode.getOpcode();
                int insnType = insnNode.getType();
                if (insnType == 8 || insnType == 15 || insnType == 14) {
                    this.visitNopInsn(f, insn);
                } else {
                    current.init(f).execute(insnNode, this.interpreter);
                    if (insnNode instanceof JumpInsnNode) {
                        this.visitJumpInsnNode((JumpInsnNode)insnNode, current, insn, insnOpcode);
                    } else if (insnNode instanceof LookupSwitchInsnNode) {
                        this.visitLookupSwitchInsnNode((LookupSwitchInsnNode)insnNode, current, insn);
                    } else if (insnNode instanceof TableSwitchInsnNode) {
                        this.visitTableSwitchInsnNode((TableSwitchInsnNode)insnNode, current, insn);
                    } else if (insnOpcode != 191 && (insnOpcode < 172 || insnOpcode > 177)) {
                        this.visitOpInsn(current, insn);
                    }
                }
                List<TryCatchBlockNode> list2 = this.handlers[insn];
                if (list2 == null) continue;
                Iterable $receiver$iv = list2;
                for (Object element$iv : $receiver$iv) {
                    TryCatchBlockNode tcb = (TryCatchBlockNode)element$iv;
                    String string = tcb.type;
                    if (string == null) {
                        string = "java/lang/Throwable";
                    }
                    Type exnType = Type.getObjectType(string);
                    int jump = this.instructions.indexOf(tcb.handler);
                    if (!this.visitControlFlowExceptionEdge(insn, tcb)) continue;
                    handler2.init(f);
                    handler2.clearStack();
                    handler2.push(this.interpreter.newValue(exnType));
                    this.mergeControlFlowEdge(jump, handler2);
                }
            }
            catch (AnalyzerException e) {
                throw (Throwable)new AnalyzerException(e.node, "Error at instruction #" + insn + ' ' + InlineCodegenUtilsKt.getInsnText(insnNode) + ": " + e.getMessage(), e);
            }
            catch (Exception e) {
                throw (Throwable)new AnalyzerException(insnNode, "Error at instruction #" + insn + ' ' + InlineCodegenUtilsKt.getInsnText(insnNode) + ": " + e.getMessage(), e);
            }
        }
        return this.frames;
    }

    @Nullable
    public final Frame<V> getFrame(@NotNull AbstractInsnNode insn) {
        Intrinsics.checkParameterIsNotNull(insn, "insn");
        return this.frames[this.instructions.indexOf(insn)];
    }

    private final void checkAssertions() {
        boolean bl;
        block2: {
            AbstractInsnNode[] abstractInsnNodeArray = this.instructions.toArray();
            Intrinsics.checkExpressionValueIsNotNull(abstractInsnNodeArray, "instructions.toArray()");
            Object[] $receiver$iv = abstractInsnNodeArray;
            for (int i = 0; i < $receiver$iv.length; ++i) {
                AbstractInsnNode it;
                Object element$iv = $receiver$iv[i];
                AbstractInsnNode abstractInsnNode = it = (AbstractInsnNode)element$iv;
                Intrinsics.checkExpressionValueIsNotNull(abstractInsnNode, "it");
                if (!(abstractInsnNode.getOpcode() == 168 || it.getOpcode() == 169)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        if (bl) {
            throw (Throwable)((Object)new AssertionError((Object)"Subroutines are deprecated since Java 6"));
        }
    }

    private final void visitOpInsn(Frame<V> current, int insn) {
        this.processControlFlowEdge(current, insn, insn + 1);
    }

    private final void visitTableSwitchInsnNode(TableSwitchInsnNode insnNode, Frame<V> current, int insn) {
        int jump = this.instructions.indexOf(insnNode.dflt);
        this.processControlFlowEdge(current, insn, jump);
        List<LabelNode> list2 = insnNode.labels;
        Intrinsics.checkExpressionValueIsNotNull(list2, "insnNode.labels");
        for (LabelNode label : CollectionsKt.reversed((Iterable)list2)) {
            jump = this.instructions.indexOf(label);
            this.processControlFlowEdge(current, insn, jump);
        }
    }

    private final void visitLookupSwitchInsnNode(LookupSwitchInsnNode insnNode, Frame<V> current, int insn) {
        int jump = this.instructions.indexOf(insnNode.dflt);
        this.processControlFlowEdge(current, insn, jump);
        for (LabelNode label : insnNode.labels) {
            jump = this.instructions.indexOf(label);
            this.processControlFlowEdge(current, insn, jump);
        }
    }

    private final void visitJumpInsnNode(JumpInsnNode insnNode, Frame<V> current, int insn, int insnOpcode) {
        if (insnOpcode != 167 && insnOpcode != 168) {
            this.processControlFlowEdge(current, insn, insn + 1);
        }
        int jump = this.instructions.indexOf(insnNode.label);
        this.processControlFlowEdge(current, insn, jump);
    }

    private final void visitNopInsn(Frame<V> f, int insn) {
        this.processControlFlowEdge(f, insn, insn + 1);
    }

    private final void processControlFlowEdge(Frame<V> current, int insn, int jump) {
        if (this.visitControlFlowEdge(insn, jump)) {
            this.mergeControlFlowEdge(jump, current);
        }
    }

    private final void initControlFlowAnalysis(Frame<V> current, MethodNode m, String owner) {
        current.setReturn(this.interpreter.newValue(Type.getReturnType(m.desc)));
        Type[] args = Type.getArgumentTypes(m.desc);
        int local = 0;
        if ((m.access & 8) == 0) {
            Type ctype = Type.getObjectType(owner);
            current.setLocal(local++, this.interpreter.newValue(ctype));
        }
        for (int i = 0; i < args.length; ++i) {
            Type arg = args[i];
            current.setLocal(local++, this.interpreter.newValue(arg));
            Type type2 = arg;
            Intrinsics.checkExpressionValueIsNotNull(type2, "arg");
            if (type2.getSize() != 2) continue;
            current.setLocal(local++, this.interpreter.newValue(null));
        }
        while (local < m.maxLocals) {
            current.setLocal(local++, this.interpreter.newValue(null));
        }
        this.mergeControlFlowEdge(0, current);
        this.init(owner, m);
    }

    /*
     * WARNING - void declaration
     */
    private final void computeExceptionHandlersForEachInsn(MethodNode m) {
        for (TryCatchBlockNode tcb : m.tryCatchBlocks) {
            int begin = this.instructions.indexOf(tcb.start);
            int end = this.instructions.indexOf(tcb.end);
            int n = begin;
            int n2 = end;
            while (n < n2) {
                void j;
                List insnHandlers = this.handlers[j];
                if (insnHandlers == null) {
                    this.handlers[j] = insnHandlers = (List)new ArrayList();
                }
                TryCatchBlockNode tryCatchBlockNode = tcb;
                Intrinsics.checkExpressionValueIsNotNull(tryCatchBlockNode, "tcb");
                insnHandlers.add(tryCatchBlockNode);
                ++j;
            }
        }
    }

    private final void mergeControlFlowEdge(int insn, Frame<V> frame) {
        boolean changes;
        boolean bl;
        Frame<V> oldFrame = this.frames[insn];
        if (oldFrame != null) {
            bl = oldFrame.merge(frame, this.interpreter);
        } else {
            this.frames[insn] = this.newFrame(frame);
            bl = changes = true;
        }
        if (changes && !this.queued[insn]) {
            this.queued[insn] = true;
            int n = this.top;
            this.top = n + 1;
            this.queue[n] = insn;
        }
    }

    @NotNull
    public final String getOwner() {
        return this.owner;
    }

    @NotNull
    public final MethodNode getMethod() {
        return this.method;
    }

    @NotNull
    protected final Interpreter<V> getInterpreter() {
        return this.interpreter;
    }

    public MethodAnalyzer(@NotNull String owner, @NotNull MethodNode method, @NotNull Interpreter<V> interpreter) {
        Intrinsics.checkParameterIsNotNull(owner, "owner");
        Intrinsics.checkParameterIsNotNull(method, "method");
        Intrinsics.checkParameterIsNotNull(interpreter, "interpreter");
        this.owner = owner;
        this.method = method;
        this.interpreter = interpreter;
        InsnList insnList = this.method.instructions;
        Intrinsics.checkExpressionValueIsNotNull(insnList, "method.instructions");
        this.instructions = insnList;
        this.nInsns = this.instructions.size();
        this.frames = new Frame[this.nInsns];
        this.handlers = new List[this.nInsns];
        this.queued = new boolean[this.nInsns];
        this.queue = new int[this.nInsns];
    }
}

