/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.load.java.structure.reflect.ReflectClassUtilKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/reflect/SignatureSerializer;", "", "()V", "constructorDesc", "", "constructor", "Ljava/lang/reflect/Constructor;", "fieldDesc", "field", "Ljava/lang/reflect/Field;", "methodDesc", "method", "Ljava/lang/reflect/Method;", "core"})
final class SignatureSerializer {
    public static final SignatureSerializer INSTANCE;

    @NotNull
    public final String methodDesc(@NotNull Method method) {
        Intrinsics.checkParameterIsNotNull(method, "method");
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        Class<?>[] classArray = method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            Class<?> parameterType;
            Class<?> clazz = parameterType = classArray[i];
            Intrinsics.checkExpressionValueIsNotNull(clazz, "parameterType");
            sb.append(ReflectClassUtilKt.getDesc(clazz));
        }
        sb.append(")");
        Class<?> clazz = method.getReturnType();
        Intrinsics.checkExpressionValueIsNotNull(clazz, "method.returnType");
        sb.append(ReflectClassUtilKt.getDesc(clazz));
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "sb.toString()");
        return string;
    }

    @NotNull
    public final String constructorDesc(@NotNull Constructor<?> constructor) {
        Intrinsics.checkParameterIsNotNull(constructor, "constructor");
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        Class<?>[] classArray = constructor.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            Class<?> parameterType;
            Class<?> clazz = parameterType = classArray[i];
            Intrinsics.checkExpressionValueIsNotNull(clazz, "parameterType");
            sb.append(ReflectClassUtilKt.getDesc(clazz));
        }
        sb.append(")V");
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "sb.toString()");
        return string;
    }

    @NotNull
    public final String fieldDesc(@NotNull Field field) {
        Intrinsics.checkParameterIsNotNull(field, "field");
        Class<?> clazz = field.getType();
        Intrinsics.checkExpressionValueIsNotNull(clazz, "field.type");
        return ReflectClassUtilKt.getDesc(clazz);
    }

    private SignatureSerializer() {
    }

    static {
        SignatureSerializer signatureSerializer;
        INSTANCE = signatureSerializer = new SignatureSerializer();
    }
}

