ms17_010_eternalblue is a remote exploit against Microsoft Windows, originally written by the
Equation Group (NSA) and leaked by Shadow Brokers (an unknown hacking entity). It is
considered a reliable exploit, and allows you to gain access not only as SYSTEM - the highest Windows
user mode privilege, but also full control of the kernel in ring 0. In modern day penetration test,
this exploit can be found in internal and external environments.

As far as remote kernel exploits go, this one is highly reliable and safe to use.

The check command of ms17_010_eternalblue is also highly accurate, because Microsoft's patch
inadvertently added an information disclosure with extra checks on vulnerable code paths.


## Vulnerable Application

This exploit works against a vulnerable SMB service from one of these Windows systems:

[//]: # (https://stackoverflow.com/questions/4823468/comments-in-markdown)

[//]: # (* Windows XP x86 (All Service Packs))

[//]: # (* Windows 2003 x86 (All Service Packs))

[//]: # (* Windows 7 x86 (All Service Packs))
* Windows 7 x64 (All Service Packs)
* Windows 2008 R2 x64 (All Service Packs)

To reliability determine whether the machine is vulnerable, you will have to either examine
the system's patch level, or use a vulnerability check.

## Verification Steps

- [x] Start `msfconsole`
- [x] `use exploit/windows/smb/ms17_010_eternalblue`
- [x] `set RHOST` to Windows 7/2008 x64
- [x] `set PAYLOAD`
- [x] `exploit`
- [x] **Verify** that you get a shell
- [x] **Verify** that you do not crash (post an Issue with core dump if you do)

## Options

```
set ProcessName [string]
```

This is the usermode process that an APC containing shellcode will be queued into.
This should probably be a SYSTEM process, such as `lsass.exe` or `spoolsv.exe`.

```
set MaxExploitAttempts [integer]
```

Grooming the kernel does not always succeed, so this is the amount of times to retry
the exploit.

```
set GroomAllocations [integer]
```

This is the base number of groom packets that will be sent per exploit.

```
set GroomDelta [integer]
```

This is the number the grooms will increase per exploit try, if previous try failed.

**Unsafe configuration of Target**
It is not possible to determine the Architecture (x86 or x64) of a machine from its
SMB headers. The exploit has safeguards to silently fail if you use the wrong arch.
If the shells aren't poppin', try to change the architecture.
