/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.annotation.SdkProtectedApi;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XpathUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@SdkProtectedApi
public class DefaultErrorResponseHandler
implements HttpResponseHandler<AmazonServiceException> {
    private static final Log log = LogFactory.getLog(DefaultErrorResponseHandler.class);
    private List<Unmarshaller<AmazonServiceException, Node>> unmarshallerList;

    public DefaultErrorResponseHandler(List<Unmarshaller<AmazonServiceException, Node>> unmarshallerList) {
        this.unmarshallerList = unmarshallerList;
    }

    @Override
    public AmazonServiceException handle(HttpResponse errorResponse) throws Exception {
        AmazonServiceException ase = this.createAse(errorResponse);
        if (ase == null) {
            throw new AmazonClientException("Unable to unmarshall error response from service");
        }
        ase.setHttpHeaders(errorResponse.getHeaders());
        if (StringUtils.isNullOrEmpty(ase.getErrorCode())) {
            ase.setErrorCode(errorResponse.getStatusCode() + " " + errorResponse.getStatusText());
        }
        return ase;
    }

    private AmazonServiceException createAse(HttpResponse errorResponse) throws Exception {
        Document document = this.parseContentAsXml(errorResponse.getContent());
        for (Unmarshaller<AmazonServiceException, Node> unmarshaller : this.unmarshallerList) {
            AmazonServiceException ase = unmarshaller.unmarshall(document);
            if (ase == null) continue;
            ase.setStatusCode(errorResponse.getStatusCode());
            return ase;
        }
        return null;
    }

    private Document parseContentAsXml(InputStream content) throws ParserConfigurationException, SAXException, IOException {
        try {
            return XpathUtils.documentFrom(IOUtils.toString(content));
        }
        catch (Exception e2) {
            log.info("Unable to parse HTTP response content.", e2);
            return XpathUtils.documentFrom("<empty/>");
        }
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }
}

