/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.Explanation;

public class CachingDoubleValueSource
extends DoubleValuesSource {
    final DoubleValuesSource source;
    final Map<Integer, Double> cache;

    public CachingDoubleValueSource(DoubleValuesSource source) {
        this.source = source;
        this.cache = new HashMap<Integer, Double>();
    }

    public String toString() {
        return "Cached[" + this.source.toString() + "]";
    }

    public DoubleValues getValues(LeafReaderContext readerContext, DoubleValues scores) throws IOException {
        final int base = readerContext.docBase;
        final DoubleValues vals = this.source.getValues(readerContext, scores);
        return new DoubleValues(){
            int doc = -1;

            public double doubleValue() throws IOException {
                int key = base + this.doc;
                Double v = CachingDoubleValueSource.this.cache.get(key);
                if (v == null) {
                    v = vals.doubleValue();
                    CachingDoubleValueSource.this.cache.put(key, v);
                }
                return v;
            }

            public boolean advanceExact(int doc) throws IOException {
                this.doc = doc;
                return vals.advanceExact(doc);
            }
        };
    }

    public boolean needsScores() {
        return false;
    }

    public Explanation explain(LeafReaderContext ctx, int docId, Explanation scoreExplanation) throws IOException {
        return this.source.explain(ctx, docId, scoreExplanation);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CachingDoubleValueSource that = (CachingDoubleValueSource)((Object)o);
        return !(this.source != null ? !this.source.equals((Object)that.source) : that.source != null);
    }

    public int hashCode() {
        return this.source != null ? this.source.hashCode() : 0;
    }
}

