/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent.support;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;

public abstract class AbstractXContentParser
implements XContentParser {
    public static final boolean DEFAULT_NUMBER_COERCE_POLICY = true;
    private final NamedXContentRegistry xContentRegistry;
    static final MapFactory SIMPLE_MAP_FACTORY = HashMap::new;
    static final MapFactory ORDERED_MAP_FACTORY = LinkedHashMap::new;
    static final MapStringsFactory SIMPLE_MAP_STRINGS_FACTORY = HashMap::new;
    static final MapStringsFactory ORDERED_MAP_STRINGS_FACTORY = LinkedHashMap::new;

    private static void checkCoerceString(boolean coerce, Class<? extends Number> clazz) {
        if (!coerce) {
            throw new IllegalArgumentException(clazz.getSimpleName() + " value passed as String");
        }
    }

    public AbstractXContentParser(NamedXContentRegistry xContentRegistry) {
        this.xContentRegistry = xContentRegistry;
    }

    void ensureNumberConversion(boolean coerce, long result, Class<? extends Number> clazz) throws IOException {
        double fullVal;
        if (!coerce && (double)result != (fullVal = this.doDoubleValue())) {
            throw new IllegalArgumentException(fullVal + " cannot be converted to " + clazz.getSimpleName() + " without data loss");
        }
    }

    @Override
    public boolean isBooleanValue() throws IOException {
        switch (this.currentToken()) {
            case VALUE_BOOLEAN: {
                return true;
            }
            case VALUE_STRING: {
                return Booleans.isBoolean(this.textCharacters(), this.textOffset(), this.textLength());
            }
        }
        return false;
    }

    @Override
    public boolean booleanValue() throws IOException {
        XContentParser.Token token = this.currentToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            return Booleans.parseBoolean(this.textCharacters(), this.textOffset(), this.textLength(), false);
        }
        return this.doBooleanValue();
    }

    @Override
    @Deprecated
    public boolean isBooleanValueLenient() throws IOException {
        switch (this.currentToken()) {
            case VALUE_BOOLEAN: {
                return true;
            }
            case VALUE_NUMBER: {
                XContentParser.NumberType numberType = this.numberType();
                return numberType == XContentParser.NumberType.LONG || numberType == XContentParser.NumberType.INT;
            }
            case VALUE_STRING: {
                return Booleans.isBooleanLenient(this.textCharacters(), this.textOffset(), this.textLength());
            }
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean booleanValueLenient() throws IOException {
        XContentParser.Token token = this.currentToken();
        if (token == XContentParser.Token.VALUE_NUMBER) {
            return this.intValue() != 0;
        }
        if (token == XContentParser.Token.VALUE_STRING) {
            return Booleans.parseBooleanLenient(this.textCharacters(), this.textOffset(), this.textLength(), false);
        }
        return this.doBooleanValue();
    }

    protected abstract boolean doBooleanValue() throws IOException;

    @Override
    public short shortValue() throws IOException {
        return this.shortValue(true);
    }

    @Override
    public short shortValue(boolean coerce) throws IOException {
        XContentParser.Token token = this.currentToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            AbstractXContentParser.checkCoerceString(coerce, Short.class);
            return (short)Double.parseDouble(this.text());
        }
        short result = this.doShortValue();
        this.ensureNumberConversion(coerce, result, Short.class);
        return result;
    }

    protected abstract short doShortValue() throws IOException;

    @Override
    public int intValue() throws IOException {
        return this.intValue(true);
    }

    @Override
    public int intValue(boolean coerce) throws IOException {
        XContentParser.Token token = this.currentToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            AbstractXContentParser.checkCoerceString(coerce, Integer.class);
            return (int)Double.parseDouble(this.text());
        }
        int result = this.doIntValue();
        this.ensureNumberConversion(coerce, result, Integer.class);
        return result;
    }

    protected abstract int doIntValue() throws IOException;

    @Override
    public long longValue() throws IOException {
        return this.longValue(true);
    }

    @Override
    public long longValue(boolean coerce) throws IOException {
        XContentParser.Token token = this.currentToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            AbstractXContentParser.checkCoerceString(coerce, Long.class);
            String stringValue = this.text();
            try {
                return Long.parseLong(stringValue);
            }
            catch (NumberFormatException e) {
                return (long)Double.parseDouble(stringValue);
            }
        }
        long result = this.doLongValue();
        this.ensureNumberConversion(coerce, result, Long.class);
        return result;
    }

    protected abstract long doLongValue() throws IOException;

    @Override
    public float floatValue() throws IOException {
        return this.floatValue(true);
    }

    @Override
    public float floatValue(boolean coerce) throws IOException {
        XContentParser.Token token = this.currentToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            AbstractXContentParser.checkCoerceString(coerce, Float.class);
            return Float.parseFloat(this.text());
        }
        return this.doFloatValue();
    }

    protected abstract float doFloatValue() throws IOException;

    @Override
    public double doubleValue() throws IOException {
        return this.doubleValue(true);
    }

    @Override
    public double doubleValue(boolean coerce) throws IOException {
        XContentParser.Token token = this.currentToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            AbstractXContentParser.checkCoerceString(coerce, Double.class);
            return Double.parseDouble(this.text());
        }
        return this.doDoubleValue();
    }

    protected abstract double doDoubleValue() throws IOException;

    @Override
    public final String textOrNull() throws IOException {
        if (this.currentToken() == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        return this.text();
    }

    @Override
    public BytesRef utf8BytesOrNull() throws IOException {
        if (this.currentToken() == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        return this.utf8Bytes();
    }

    @Override
    public Map<String, Object> map() throws IOException {
        return AbstractXContentParser.readMap(this);
    }

    @Override
    public Map<String, Object> mapOrdered() throws IOException {
        return AbstractXContentParser.readOrderedMap(this);
    }

    @Override
    public Map<String, String> mapStrings() throws IOException {
        return AbstractXContentParser.readMapStrings(this);
    }

    @Override
    public Map<String, String> mapStringsOrdered() throws IOException {
        return AbstractXContentParser.readOrderedMapStrings(this);
    }

    @Override
    public List<Object> list() throws IOException {
        return AbstractXContentParser.readList(this);
    }

    @Override
    public List<Object> listOrderedMap() throws IOException {
        return AbstractXContentParser.readListOrderedMap(this);
    }

    static Map<String, Object> readMap(XContentParser parser) throws IOException {
        return AbstractXContentParser.readMap(parser, SIMPLE_MAP_FACTORY);
    }

    static Map<String, Object> readOrderedMap(XContentParser parser) throws IOException {
        return AbstractXContentParser.readMap(parser, ORDERED_MAP_FACTORY);
    }

    static Map<String, String> readMapStrings(XContentParser parser) throws IOException {
        return AbstractXContentParser.readMapStrings(parser, SIMPLE_MAP_STRINGS_FACTORY);
    }

    static Map<String, String> readOrderedMapStrings(XContentParser parser) throws IOException {
        return AbstractXContentParser.readMapStrings(parser, ORDERED_MAP_STRINGS_FACTORY);
    }

    static List<Object> readList(XContentParser parser) throws IOException {
        return AbstractXContentParser.readList(parser, SIMPLE_MAP_FACTORY);
    }

    static List<Object> readListOrderedMap(XContentParser parser) throws IOException {
        return AbstractXContentParser.readList(parser, ORDERED_MAP_FACTORY);
    }

    static Map<String, Object> readMap(XContentParser parser, MapFactory mapFactory) throws IOException {
        Map<String, Object> map = mapFactory.newMap();
        XContentParser.Token token = parser.currentToken();
        if (token == null) {
            token = parser.nextToken();
        }
        if (token == XContentParser.Token.START_OBJECT) {
            token = parser.nextToken();
        }
        while (token == XContentParser.Token.FIELD_NAME) {
            String fieldName = parser.currentName();
            token = parser.nextToken();
            Object value = AbstractXContentParser.readValue(parser, mapFactory, token);
            map.put(fieldName, value);
            token = parser.nextToken();
        }
        return map;
    }

    static Map<String, String> readMapStrings(XContentParser parser, MapStringsFactory mapStringsFactory) throws IOException {
        Map<String, String> map = mapStringsFactory.newMap();
        XContentParser.Token token = parser.currentToken();
        if (token == null) {
            token = parser.nextToken();
        }
        if (token == XContentParser.Token.START_OBJECT) {
            token = parser.nextToken();
        }
        while (token == XContentParser.Token.FIELD_NAME) {
            String fieldName = parser.currentName();
            parser.nextToken();
            String value = parser.text();
            map.put(fieldName, value);
            token = parser.nextToken();
        }
        return map;
    }

    static List<Object> readList(XContentParser parser, MapFactory mapFactory) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == null) {
            token = parser.nextToken();
        }
        if (token == XContentParser.Token.FIELD_NAME) {
            token = parser.nextToken();
        }
        if (token != XContentParser.Token.START_ARRAY) {
            throw new ElasticsearchParseException("Failed to parse list:  expecting " + (Object)((Object)XContentParser.Token.START_ARRAY) + " but got " + (Object)((Object)token), new Object[0]);
        }
        token = parser.nextToken();
        ArrayList<Object> list = new ArrayList<Object>();
        while (token != null && token != XContentParser.Token.END_ARRAY) {
            list.add(AbstractXContentParser.readValue(parser, mapFactory, token));
            token = parser.nextToken();
        }
        return list;
    }

    static Object readValue(XContentParser parser, MapFactory mapFactory, XContentParser.Token token) throws IOException {
        if (token == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        if (token == XContentParser.Token.VALUE_STRING) {
            return parser.text();
        }
        if (token == XContentParser.Token.VALUE_NUMBER) {
            return parser.numberValue();
        }
        if (token == XContentParser.Token.VALUE_BOOLEAN) {
            return parser.booleanValue();
        }
        if (token == XContentParser.Token.START_OBJECT) {
            return AbstractXContentParser.readMap(parser, mapFactory);
        }
        if (token == XContentParser.Token.START_ARRAY) {
            return AbstractXContentParser.readList(parser, mapFactory);
        }
        if (token == XContentParser.Token.VALUE_EMBEDDED_OBJECT) {
            return parser.binaryValue();
        }
        return null;
    }

    @Override
    public <T> T namedObject(Class<T> categoryClass, String name, Object context) throws IOException {
        return this.xContentRegistry.parseNamedObject(categoryClass, name, this, context);
    }

    @Override
    public NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    @Override
    public abstract boolean isClosed();

    static interface MapStringsFactory {
        public Map<String, String> newMap();
    }

    static interface MapFactory {
        public Map<String, Object> newMap();
    }
}

