/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.codegen.BlockInfo;
import org.jetbrains.kotlin.backend.jvm.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IrIntrinsicFunction;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IrIntrinsicFunctionKt;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrPrimitiveCallBase;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IrCompareTo;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethod;", "()V", "toCallable", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IrIntrinsicFunction;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "signature", "Lorg/jetbrains/kotlin/resolve/jvm/jvmSignature/JvmMethodSignature;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "kotlin-compiler"})
public final class IrCompareTo
extends IntrinsicMethod {
    @Override
    @NotNull
    public IrIntrinsicFunction toCallable(@NotNull IrMemberAccessExpression expression2, @NotNull JvmMethodSignature signature2, @NotNull JvmBackendContext context) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(signature2, "signature");
        Intrinsics.checkParameterIsNotNull(context, "context");
        boolean bl = expression2 instanceof IrPrimitiveCallBase;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        IrExpression irExpression = expression2.getValueArgument(0);
        if (irExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrCall");
        }
        IrCall compareCall = (IrCall)irExpression;
        List<IrExpression> args = IrIntrinsicFunctionKt.receiverAndArgs(compareCall);
        List<Type> argTypes = IrIntrinsicFunctionKt.asmTypes(args, context);
        Type leftType = argTypes.get(0);
        Type rightType = argTypes.get(1);
        Type parameterType = AsmUtil.comparisonOperandType(leftType, rightType);
        JvmMethodSignature newSignature = context.getState().getTypeMapper().mapSignatureSkipGeneric(compareCall.getDescriptor(), OwnerKind.IMPLEMENTATION);
        IrMemberAccessExpression irMemberAccessExpression = compareCall;
        JvmMethodSignature jvmMethodSignature = newSignature;
        Intrinsics.checkExpressionValueIsNotNull(jvmMethodSignature, "newSignature");
        return new IrIntrinsicFunction(compareCall, leftType, rightType, args, expression2, newSignature, context, parameterType, irMemberAccessExpression, jvmMethodSignature, context, CollectionsKt.listOf(new Type[]{parameterType, parameterType})){
            final /* synthetic */ IrCall $compareCall;
            final /* synthetic */ Type $leftType;
            final /* synthetic */ Type $rightType;
            final /* synthetic */ List $args;
            final /* synthetic */ IrMemberAccessExpression $expression;
            final /* synthetic */ JvmMethodSignature $newSignature;
            final /* synthetic */ JvmBackendContext $context;
            final /* synthetic */ Type $parameterType;

            @NotNull
            public StackValue invoke(@NotNull InstructionAdapter v, @NotNull ExpressionCodegen codegen, @NotNull BlockInfo data2) {
                KtSingleValueToken ktSingleValueToken;
                IrStatementOrigin origin;
                StackValue rightValue;
                StackValue leftValue;
                Type operationType;
                boolean isPrimitiveIntrinsic;
                Intrinsics.checkParameterIsNotNull(v, "v");
                Intrinsics.checkParameterIsNotNull(codegen, "codegen");
                Intrinsics.checkParameterIsNotNull(data2, "data");
                boolean bl = isPrimitiveIntrinsic = codegen.getIntrinsics().getIntrinsics().getIntrinsic(this.$compareCall.getDescriptor()) != null;
                if (AsmUtil.isPrimitive(this.$leftType) && AsmUtil.isPrimitive(this.$rightType) && isPrimitiveIntrinsic) {
                    Type type2 = AsmUtil.comparisonOperandType(this.$leftType, this.$rightType);
                    Intrinsics.checkExpressionValueIsNotNull(type2, "comparisonOperandType(leftType, rightType)");
                    operationType = type2;
                    leftValue = codegen.gen((IrElement)this.$args.get(0), operationType, data2);
                    rightValue = codegen.gen((IrElement)this.$args.get(1), operationType, data2);
                } else {
                    Type type3 = Type.INT_TYPE;
                    Intrinsics.checkExpressionValueIsNotNull(type3, "Type.INT_TYPE");
                    operationType = type3;
                    leftValue = codegen.gen(this.$compareCall, data2);
                    StackValue stackValue = StackValue.constant(0, operationType);
                    Intrinsics.checkExpressionValueIsNotNull(stackValue, "StackValue.constant(0, operationType)");
                    rightValue = stackValue;
                }
                IrStatementOrigin irStatementOrigin = origin = this.$expression.getOrigin();
                if (Intrinsics.areEqual(irStatementOrigin, IrStatementOrigin.GT.INSTANCE)) {
                    ktSingleValueToken = KtTokens.GT;
                } else if (Intrinsics.areEqual(irStatementOrigin, IrStatementOrigin.GTEQ.INSTANCE)) {
                    ktSingleValueToken = KtTokens.GTEQ;
                } else if (Intrinsics.areEqual(irStatementOrigin, IrStatementOrigin.LT.INSTANCE)) {
                    ktSingleValueToken = KtTokens.LT;
                } else if (Intrinsics.areEqual(irStatementOrigin, IrStatementOrigin.LTEQ.INSTANCE)) {
                    ktSingleValueToken = KtTokens.LTEQ;
                } else {
                    throw (Throwable)new NotImplementedError(null, 1, null);
                }
                KtSingleValueToken token = ktSingleValueToken;
                StackValue.cmp(token, operationType, leftValue, rightValue).put(Type.BOOLEAN_TYPE, v);
                StackValue stackValue = StackValue.onStack(Type.BOOLEAN_TYPE);
                Intrinsics.checkExpressionValueIsNotNull(stackValue, "StackValue.onStack(Type.BOOLEAN_TYPE)");
                return stackValue;
            }
            {
                this.$compareCall = $captured_local_variable$0;
                this.$leftType = $captured_local_variable$1;
                this.$rightType = $captured_local_variable$2;
                this.$args = $captured_local_variable$3;
                this.$expression = $captured_local_variable$4;
                this.$newSignature = $captured_local_variable$5;
                this.$context = $captured_local_variable$6;
                this.$parameterType = $captured_local_variable$7;
                super($super_call_param$8, $super_call_param$9, $super_call_param$10, $super_call_param$11);
            }
        };
    }
}

