/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.extensions.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.AreaInstance;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.Extension;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPoint;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPointAndAreaListener;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPointListener;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionsArea;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.LoadingOrder;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginDescriptor;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.Condition;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.StringInterner;
import org.jetbrains.kotlin.org.jdom.Element;

public class ExtensionPointImpl<T>
implements ExtensionPoint<T> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.extensions.impl.ExtensionPointImpl");
    private final AreaInstance myArea;
    private final String myName;
    private final String myClassName;
    private final ExtensionPoint.Kind myKind;
    private volatile T[] myExtensionsCache;
    private final ExtensionsAreaImpl myOwner;
    private final PluginDescriptor myDescriptor;
    private Set<ExtensionComponentAdapter> myExtensionAdapters;
    private final List<ExtensionPointListener<T>> myEPListeners;
    private List<ExtensionComponentAdapter> myLoadedAdapters;
    private Class<T> myExtensionClass;
    private static final StringInterner INTERNER = new StringInterner();
    private boolean processingAdaptersNow;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExtensionPointImpl(@NotNull String name, @NotNull String className2, @NotNull ExtensionPoint.Kind kind, @NotNull ExtensionsAreaImpl owner, AreaInstance area, @NotNull PluginDescriptor descriptor2) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionPointImpl", "<init>"));
        }
        if (className2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionPointImpl", "<init>"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionPointImpl", "<init>"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionPointImpl", "<init>"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionPointImpl", "<init>"));
        }
        this.myEPListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        StringInterner stringInterner = INTERNER;
        synchronized (stringInterner) {
            this.myName = INTERNER.intern(name);
        }
        this.myClassName = className2;
        this.myKind = kind;
        this.myOwner = owner;
        this.myArea = area;
        this.myDescriptor = descriptor2;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionPointImpl", "getName"));
        }
        return string;
    }

    @NotNull
    public String getClassName() {
        String string = this.myClassName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionPointImpl", "getClassName"));
        }
        return string;
    }

    @NotNull
    public ExtensionPoint.Kind getKind() {
        ExtensionPoint.Kind kind = this.myKind;
        if (kind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionPointImpl", "getKind"));
        }
        return kind;
    }

    @Override
    public void registerExtension(@NotNull T extension) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionPointImpl", "registerExtension"));
        }
        this.registerExtension(extension, LoadingOrder.ANY);
    }

    @NotNull
    public PluginDescriptor getDescriptor() {
        PluginDescriptor pluginDescriptor = this.myDescriptor;
        if (pluginDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionPointImpl", "getDescriptor"));
        }
        return pluginDescriptor;
    }

    public synchronized void registerExtension(@NotNull T extension, @NotNull LoadingOrder order) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionPointImpl", "registerExtension"));
        }
        if (order == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "order", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionPointImpl", "registerExtension"));
        }
        ObjectComponentAdapter adapter = new ObjectComponentAdapter(extension, order);
        if (LoadingOrder.ANY == order) {
            ExtensionComponentAdapter lastAdapter;
            int index2;
            for (index2 = this.getLoadedAdaptersSize(); index2 > 0 && (lastAdapter = this.myLoadedAdapters.get(index2 - 1)).getOrder() == LoadingOrder.LAST; --index2) {
            }
            this.registerExtension(extension, adapter, index2, true);
        } else {
            this.registerExtensionAdapter(adapter);
            this.processAdapters();
        }
    }

    private int getLoadedAdaptersSize() {
        List<ExtensionComponentAdapter> loadedAdapters = this.myLoadedAdapters;
        return loadedAdapters == null ? 0 : loadedAdapters.size();
    }

    private void registerExtension(@NotNull T extension, @NotNull ExtensionComponentAdapter adapter, int index2, boolean runNotifications) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionPointImpl", "registerExtension"));
        }
        if (adapter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "adapter", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionPointImpl", "registerExtension"));
        }
        if (this.getExtensionIndex(extension) != -1) {
            this.myOwner.error("Extension was already added: " + extension);
            return;
        }
        Class<T> extensionClass = this.getExtensionClass();
        if (!extensionClass.isInstance(extension)) {
            this.myOwner.error("Extension " + extension.getClass() + " does not implement " + extensionClass);
            return;
        }
        if (this.myLoadedAdapters == null) {
            this.myLoadedAdapters = new ArrayList<ExtensionComponentAdapter>();
        }
        this.myLoadedAdapters.add(index2, adapter);
        if (runNotifications) {
            this.clearCache();
            if (!adapter.isNotificationSent()) {
                if (extension instanceof Extension) {
                    try {
                        ((Extension)extension).extensionAdded(this);
                    }
                    catch (Throwable e) {
                        this.myOwner.error(e);
                    }
                }
                this.notifyListenersOnAdd(extension, adapter.getPluginDescriptor());
                adapter.setNotificationSent(true);
            }
        }
    }

    private void notifyListenersOnAdd(@NotNull T extension, PluginDescriptor pluginDescriptor) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionPointImpl", "notifyListenersOnAdd"));
        }
        for (ExtensionPointListener<T> listener : this.myEPListeners) {
            try {
                listener.extensionAdded(extension, pluginDescriptor);
            }
            catch (Throwable e) {
                this.myOwner.error(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public T[] getExtensions() {
        Object[] result2 = this.myExtensionsCache;
        if (result2 == null) {
            ExtensionPointImpl extensionPointImpl = this;
            synchronized (extensionPointImpl) {
                result2 = this.myExtensionsCache;
                if (result2 == null) {
                    result2 = this.processAdapters();
                    if (result2 == null) {
                        result2 = (Object[])Array.newInstance(this.getExtensionClass(), 0);
                    }
                    this.myExtensionsCache = result2;
                }
            }
        }
        Object[] objectArray = result2.length == 0 ? result2 : (Object[])result2.clone();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionPointImpl", "getExtensions"));
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAnyExtensions() {
        T[] cache2 = this.myExtensionsCache;
        if (cache2 != null) {
            return cache2.length > 0;
        }
        ExtensionPointImpl extensionPointImpl = this;
        synchronized (extensionPointImpl) {
            return this.getExtensionAdaptersSize() + this.getLoadedAdaptersSize() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable(value="null means empty")
    private T[] processAdapters() {
        if (this.processingAdaptersNow) {
            throw new IllegalStateException("Recursive processAdapters() detected. You must have called 'getExtensions()' from within your extension constructor - don't. Either pass extension via constructor parameter or call getExtensions() later.");
        }
        int totalSize = this.getExtensionAdaptersSize() + this.getLoadedAdaptersSize();
        if (totalSize == 0) {
            return null;
        }
        this.processingAdaptersNow = true;
        try {
            Class<T> extensionClass = this.getExtensionClass();
            Object[] result2 = (Object[])Array.newInstance(extensionClass, totalSize);
            ArrayList adapters = ContainerUtil.newArrayListWithCapacity(totalSize);
            if (this.myExtensionAdapters != null) {
                adapters.addAll(this.myExtensionAdapters);
            }
            if (this.myLoadedAdapters != null) {
                adapters.addAll(this.myLoadedAdapters);
            }
            LoadingOrder.sort(adapters);
            this.myExtensionAdapters = new LinkedHashSet(adapters);
            Set<ExtensionComponentAdapter> loaded = ContainerUtil.newHashOrEmptySet(this.myLoadedAdapters);
            this.myLoadedAdapters = null;
            boolean errorHappened = false;
            for (int i = 0; i < adapters.size(); ++i) {
                ExtensionComponentAdapter adapter;
                block15: {
                    adapter = (ExtensionComponentAdapter)adapters.get(i);
                    try {
                        Object extension = adapter.getExtension();
                        if (extension == null) {
                            errorHappened = true;
                            LOG.error("null extension in: " + adapter + ";\ngetExtensionClass(): " + this.getExtensionClass() + ";\n");
                        }
                        if (i > 0 && extension == result2[i - 1]) {
                            errorHappened = true;
                            LOG.error("Duplicate extension found: " + extension + ";  Adapter:      " + adapter + ";\n Prev adapter: " + adapters.get(i - 1) + ";\n getExtensionClass(): " + this.getExtensionClass() + ";\n result:" + Arrays.asList(result2));
                        }
                        if (!extensionClass.isInstance(extension)) {
                            errorHappened = true;
                            this.myOwner.error("Extension " + (extension == null ? null : extension.getClass()) + " does not implement " + extensionClass + ". It came from " + adapter);
                            continue;
                        }
                        result2[i] = extension;
                        this.registerExtension(extension, adapter, this.getLoadedAdaptersSize(), !loaded.contains(adapter));
                    }
                    catch (ProcessCanceledException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        errorHappened = true;
                        if ("org.jetbrains.uast.kotlin.KotlinUastLanguagePlugin".equals(adapter.getAssignableToClassName()) || "org.jetbrains.uast.java.JavaUastLanguagePlugin".equals(adapter.getAssignableToClassName())) break block15;
                        LOG.error(e);
                    }
                }
                this.myExtensionAdapters.remove(adapter);
            }
            this.myExtensionAdapters = null;
            if (errorHappened) {
                result2 = ContainerUtil.findAllAsArray(result2, Condition.NOT_NULL);
            }
            Object[] objectArray = result2;
            return objectArray;
        }
        finally {
            this.processingAdaptersNow = false;
        }
    }

    private int getExtensionAdaptersSize() {
        return this.myExtensionAdapters == null ? 0 : this.myExtensionAdapters.size();
    }

    @Override
    public synchronized boolean hasExtension(@NotNull T extension) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionPointImpl", "hasExtension"));
        }
        T[] extensions = this.processAdapters();
        return extensions != null && ArrayUtil.contains(extension, extensions);
    }

    @Override
    public synchronized void unregisterExtension(@NotNull T extension) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionPointImpl", "unregisterExtension"));
        }
        int index2 = this.getExtensionIndex(extension);
        if (index2 == -1) {
            throw new IllegalArgumentException("Extension to be removed not found: " + extension);
        }
        ExtensionComponentAdapter adapter = this.myLoadedAdapters.get(index2);
        Object key = adapter.getComponentKey();
        this.myOwner.getPicoContainer().unregisterComponent(key);
        this.processAdapters();
        this.unregisterExtension(extension, null);
    }

    private int getExtensionIndex(@NotNull T extension) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionPointImpl", "getExtensionIndex"));
        }
        if (this.myLoadedAdapters == null) {
            return -1;
        }
        for (int i = 0; i < this.myLoadedAdapters.size(); ++i) {
            ExtensionComponentAdapter adapter = this.myLoadedAdapters.get(i);
            if (!Comparing.equal(adapter.getExtension(), extension)) continue;
            return i;
        }
        return -1;
    }

    private void unregisterExtension(@NotNull T extension, PluginDescriptor pluginDescriptor) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionPointImpl", "unregisterExtension"));
        }
        int index2 = this.getExtensionIndex(extension);
        if (index2 == -1) {
            throw new IllegalArgumentException("Extension to be removed not found: " + extension);
        }
        this.myLoadedAdapters.remove(index2);
        this.clearCache();
        this.notifyListenersOnRemove(extension, pluginDescriptor);
        if (extension instanceof Extension) {
            try {
                ((Extension)extension).extensionRemoved(this);
            }
            catch (Throwable e) {
                this.myOwner.error(e);
            }
        }
    }

    private void notifyListenersOnRemove(@NotNull T extensionObject, PluginDescriptor pluginDescriptor) {
        if (extensionObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionObject", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionPointImpl", "notifyListenersOnRemove"));
        }
        for (ExtensionPointListener<T> listener : this.myEPListeners) {
            try {
                listener.extensionRemoved(extensionObject, pluginDescriptor);
            }
            catch (Throwable e) {
                this.myOwner.error(e);
            }
        }
    }

    @Override
    public synchronized void addExtensionPointListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionPointImpl", "addExtensionPointListener"));
        }
        this.processAdapters();
        if (this.myEPListeners.add(listener)) {
            ExtensionComponentAdapter[] array;
            for (ExtensionComponentAdapter componentAdapter : array = this.myLoadedAdapters == null ? ExtensionComponentAdapter.EMPTY_ARRAY : this.myLoadedAdapters.toArray(new ExtensionComponentAdapter[this.myLoadedAdapters.size()])) {
                try {
                    Object extension = componentAdapter.getExtension();
                    listener.extensionAdded(extension, componentAdapter.getPluginDescriptor());
                }
                catch (Throwable e) {
                    this.myOwner.error(e);
                }
            }
        }
    }

    @Override
    public void removeExtensionPointListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionPointImpl", "removeExtensionPointListener"));
        }
        this.removeExtensionPointListener(listener, true);
    }

    private synchronized void removeExtensionPointListener(@NotNull ExtensionPointListener<T> listener, boolean invokeForLoadedExtensions) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionPointImpl", "removeExtensionPointListener"));
        }
        if (this.myEPListeners.remove(listener) && invokeForLoadedExtensions) {
            ExtensionComponentAdapter[] array;
            for (ExtensionComponentAdapter componentAdapter : array = this.myLoadedAdapters == null ? ExtensionComponentAdapter.EMPTY_ARRAY : this.myLoadedAdapters.toArray(new ExtensionComponentAdapter[this.myLoadedAdapters.size()])) {
                try {
                    Object extension = componentAdapter.getExtension();
                    listener.extensionRemoved(extension, componentAdapter.getPluginDescriptor());
                }
                catch (Throwable e) {
                    this.myOwner.error(e);
                }
            }
        }
    }

    @NotNull
    public Class<T> getExtensionClass() {
        Class<Object> extensionClass = this.myExtensionClass;
        if (extensionClass == null) {
            try {
                ClassLoader pluginClassLoader = this.myDescriptor.getPluginClassLoader();
                Class<?> extClass = pluginClassLoader == null ? Class.forName(this.myClassName) : Class.forName(this.myClassName, true, pluginClassLoader);
                this.myExtensionClass = extensionClass = extClass;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        Class<T> clazz = extensionClass;
        if (clazz == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionPointImpl", "getExtensionClass"));
        }
        return clazz;
    }

    public String toString() {
        return this.getName();
    }

    synchronized void registerExtensionAdapter(@NotNull ExtensionComponentAdapter adapter) {
        if (adapter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "adapter", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionPointImpl", "registerExtensionAdapter"));
        }
        if (this.myExtensionAdapters == null) {
            this.myExtensionAdapters = new LinkedHashSet<ExtensionComponentAdapter>();
        }
        this.myExtensionAdapters.add(adapter);
        this.clearCache();
    }

    private void clearCache() {
        this.myExtensionsCache = null;
    }

    final synchronized void notifyAreaReplaced(ExtensionsArea area) {
        for (ExtensionPointListener<T> listener : this.myEPListeners) {
            if (!(listener instanceof ExtensionPointAndAreaListener)) continue;
            ((ExtensionPointAndAreaListener)listener).areaReplaced(area);
        }
    }

    private static class ObjectComponentAdapter
    extends ExtensionComponentAdapter {
        private final Object myExtension;
        private final LoadingOrder myLoadingOrder;

        private ObjectComponentAdapter(@NotNull Object extension, @NotNull LoadingOrder loadingOrder) {
            if (extension == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionPointImpl$ObjectComponentAdapter", "<init>"));
            }
            if (loadingOrder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loadingOrder", "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionPointImpl$ObjectComponentAdapter", "<init>"));
            }
            super(extension.getClass().getName(), null, null, null, false);
            this.myExtension = extension;
            this.myLoadingOrder = loadingOrder;
        }

        @Override
        public Object getExtension() {
            return this.myExtension;
        }

        @Override
        public LoadingOrder getOrder() {
            return this.myLoadingOrder;
        }

        @Override
        @Nullable
        public String getOrderId() {
            return null;
        }

        @Override
        @NonNls
        public Element getDescribingElement() {
            return new Element("RuntimeExtension: " + this.myExtension);
        }
    }
}

