/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.relation;

import java.awt.event.ActionEvent;
import org.openstreetmap.josm.actions.relation.AbstractRelationAction;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class DuplicateRelationAction
extends AbstractRelationAction {
    public DuplicateRelationAction() {
        this.putValue("ShortDescription", I18n.tr("Create a copy of this relation and open it in another editor window", new Object[0]));
        new ImageProvider("duplicate").getResource().attachImageIcon(this, true);
        this.putValue("Name", I18n.tr("Duplicate", new Object[0]));
    }

    public static void duplicateRelationAndLaunchEditor(Relation original) {
        Relation copy = new Relation(original, true);
        copy.setModified(true);
        RelationEditor editor = RelationEditor.getEditor(MainApplication.getLayerManager().getEditLayer(), copy, null);
        editor.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled() || this.relations.isEmpty()) {
            return;
        }
        Relation r = (Relation)this.relations.iterator().next();
        DuplicateRelationAction.duplicateRelationAndLaunchEditor(r);
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.relations.size() == 1);
    }
}

