/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.datum;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.data.projection.datum.NTV2GridShiftFileSource;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Platform;
import org.openstreetmap.josm.tools.PlatformVisitor;

public final class NTV2Proj4DirGridShiftFileSource
implements NTV2GridShiftFileSource,
PlatformVisitor<List<File>> {
    private NTV2Proj4DirGridShiftFileSource() {
    }

    public static NTV2Proj4DirGridShiftFileSource getInstance() {
        return InstanceHolder.INSTANCE;
    }

    @Override
    public InputStream getNTV2GridShiftFile(String gridFileName) {
        String projLib;
        File file;
        File dir2;
        File grid = null;
        for (File dir2 : Platform.determinePlatform().accept(this)) {
            file = new File(dir2, gridFileName);
            if (!file.exists() || !file.isFile()) continue;
            grid = file;
            break;
        }
        if (grid == null && (projLib = System.getProperty("PROJ_LIB")) != null && !projLib.isEmpty() && (dir2 = new File(projLib)).exists() && dir2.isDirectory() && (file = new File(dir2, gridFileName)).exists() && file.isFile()) {
            grid = file;
        }
        if (grid != null) {
            try {
                return new FileInputStream(grid.getAbsoluteFile());
            }
            catch (FileNotFoundException ex) {
                Logging.warn("NTV2 grid shift file not found: " + grid);
                Logging.trace(ex);
            }
        }
        return null;
    }

    @Override
    public List<File> visitUnixoid() {
        return Arrays.asList(new File("/usr/local/share/proj"), new File("/usr/share/proj"));
    }

    @Override
    public List<File> visitWindows() {
        return Arrays.asList(new File("C:\\PROJ\\NAD"));
    }

    @Override
    public List<File> visitOsx() {
        return Collections.emptyList();
    }

    private static class InstanceHolder {
        static final NTV2Proj4DirGridShiftFileSource INSTANCE = new NTV2Proj4DirGridShiftFileSource();

        private InstanceHolder() {
        }
    }
}

