/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.widgets.MultiSplitLayout;
import org.openstreetmap.josm.gui.widgets.MultiSplitPane;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.bugreport.BugReport;

public class DialogsPanel
extends JPanel
implements Destroyable {
    private final List<ToggleDialog> allDialogs = new ArrayList<ToggleDialog>();
    private final MultiSplitPane mSpltPane = new MultiSplitPane();
    private static final int DIVIDER_SIZE = 5;
    private final List<JPanel> panels = new ArrayList<JPanel>();
    public boolean initialized;
    private final JSplitPane parent;

    public DialogsPanel(JSplitPane parent) {
        this.parent = parent;
    }

    public void initialize(List<ToggleDialog> pAllDialogs) {
        if (this.initialized) {
            throw new IllegalStateException("Panel can only be initialized once.");
        }
        this.initialized = true;
        this.allDialogs.clear();
        for (ToggleDialog dialog : pAllDialogs) {
            this.add(dialog, false);
        }
        this.add(this.mSpltPane);
        this.reconstruct(Action.ELEMENT_SHRINKS, null);
    }

    public void add(ToggleDialog dlg) {
        this.add(dlg, true);
    }

    public void add(ToggleDialog dlg, boolean doReconstruct) {
        this.allDialogs.add(dlg);
        dlg.setDialogsPanel(this);
        dlg.setVisible(false);
        MinSizePanel p = new MinSizePanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setVisible(false);
        int dialogIndex = this.allDialogs.size() - 1;
        this.mSpltPane.add((Component)p, 'L' + Integer.toString(dialogIndex));
        this.panels.add(p);
        if (dlg.isDialogShowing()) {
            dlg.showDialog();
            if (dlg.isDialogInCollapsedView()) {
                dlg.isCollapsed = false;
                dlg.collapse();
            }
            if (doReconstruct) {
                this.reconstruct(Action.INVISIBLE_TO_DEFAULT, dlg);
            }
            dlg.showNotify();
        } else {
            dlg.hideDialog();
        }
    }

    public void reconstruct(Action action, ToggleDialog triggeredBy) {
        int n = this.allDialogs.size();
        for (JPanel p : this.panels) {
            p.removeAll();
            p.setVisible(false);
        }
        JPanel p = this.panels.get(n - 1);
        int k = -1;
        for (int i = n - 1; i >= 0; --i) {
            ToggleDialog dlg = this.allDialogs.get(i);
            if (dlg.isDialogInDefaultView()) {
                if (k == -1) {
                    k = n - 1;
                } else {
                    p = this.panels.get(--k);
                }
                p.add((Component)dlg, 0);
                p.setVisible(true);
                continue;
            }
            if (!dlg.isDialogInCollapsedView()) continue;
            p.add((Component)dlg, 0);
            p.setVisible(true);
        }
        if (k == -1) {
            k = n - 1;
        }
        int numPanels = n - k;
        if (action == Action.ELEMENT_SHRINKS) {
            for (int i = 0; i < n; ++i) {
                ToggleDialog dlg = this.allDialogs.get(i);
                if (!dlg.isDialogInDefaultView()) continue;
                int ph = dlg.getPreferredHeight();
                int ah = dlg.getSize().height;
                dlg.setPreferredSize(new Dimension(Integer.MAX_VALUE, ah < 20 ? ph : ah));
            }
        } else {
            int hn;
            int he;
            int h0;
            int ha;
            ToggleDialog dlg;
            int i;
            CheckParameterUtil.ensureParameterNotNull(triggeredBy, "triggeredBy");
            int sumP = 0;
            int sumA = 0;
            int sumC = 0;
            for (ToggleDialog dlg2 : this.allDialogs) {
                if (dlg2.isDialogInDefaultView()) {
                    if (dlg2 == triggeredBy) continue;
                    sumP += dlg2.getPreferredHeight();
                    sumA += dlg2.getHeight();
                    continue;
                }
                if (!dlg2.isDialogInCollapsedView()) continue;
                sumC += dlg2.getHeight();
            }
            if (sumA == 0) {
                this.reconstruct(Action.ELEMENT_SHRINKS, null);
                return;
            }
            int h = this.mSpltPane.getMultiSplitLayout().getModel().getBounds().getSize().height;
            int s2 = h - (numPanels - 1) * 5 - sumC;
            int hpTrig = triggeredBy.getPreferredHeight();
            if (hpTrig <= 0) {
                throw new IllegalStateException();
            }
            int hnTrig = hpTrig * s2 / (hpTrig + sumP);
            triggeredBy.setPreferredSize(new Dimension(Integer.MAX_VALUE, hnTrig));
            int r = s2 - hnTrig;
            int dm = 0;
            int dp = 0;
            for (i = 0; i < n; ++i) {
                dlg = this.allDialogs.get(i);
                if (dlg == triggeredBy || !dlg.isDialogInDefaultView()) continue;
                ha = dlg.getSize().height;
                h0 = ha * r / sumA;
                he = dlg.getPreferredHeight() * s2 / (sumP + hpTrig);
                if (h0 < he) {
                    hn = Math.min(ha, he);
                    dm += hn - h0;
                    continue;
                }
                dp += h0 - he;
            }
            for (i = 0; i < n; ++i) {
                dlg = this.allDialogs.get(i);
                if (dlg == triggeredBy || !dlg.isDialogInDefaultView()) continue;
                ha = dlg.getHeight();
                h0 = ha * r / sumA;
                if (h0 < (he = dlg.getPreferredHeight() * s2 / (sumP + hpTrig))) {
                    hn = Math.min(ha, he);
                    dlg.setPreferredSize(new Dimension(Integer.MAX_VALUE, hn));
                    continue;
                }
                int d = dp == 0 ? 0 : (h0 - he) * dm / dp;
                dlg.setPreferredSize(new Dimension(Integer.MAX_VALUE, h0 - d));
            }
        }
        ArrayList<MultiSplitLayout.Node> ch = new ArrayList<MultiSplitLayout.Node>();
        for (int i = k; i <= n - 1; ++i) {
            if (i != k) {
                ch.add(new MultiSplitLayout.Divider());
            }
            MultiSplitLayout.Leaf l = new MultiSplitLayout.Leaf('L' + Integer.toString(i));
            l.setWeight(1.0 / (double)numPanels);
            ch.add(l);
        }
        if (numPanels == 1) {
            MultiSplitLayout.Node model = (MultiSplitLayout.Node)ch.get(0);
            this.mSpltPane.getMultiSplitLayout().setModel(model);
        } else {
            MultiSplitLayout.Split model = new MultiSplitLayout.Split();
            model.setRowLayout(false);
            model.setChildren(ch);
            this.mSpltPane.getMultiSplitLayout().setModel(model);
        }
        this.mSpltPane.getMultiSplitLayout().setDividerSize(5);
        this.mSpltPane.getMultiSplitLayout().setFloatingDividers(true);
        this.mSpltPane.revalidate();
        if (numPanels == 1 && this.panels.get(n - 1).getComponents().length == 0) {
            this.parent.setDividerSize(0);
            this.setVisible(false);
        } else {
            if (this.getWidth() != 0) {
                this.setPreferredSize(new Dimension(this.getWidth(), 0));
            }
            this.setVisible(true);
            this.parent.setDividerSize(5);
            this.parent.resetToPreferredSizes();
        }
    }

    @Override
    public void destroy() {
        for (ToggleDialog t : this.allDialogs) {
            try {
                t.destroy();
            }
            catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException e) {
                throw BugReport.intercept(e).put("dialog", t).put("dialog-class", t.getClass());
            }
        }
    }

    public <T> T getToggleDialog(Class<T> type) {
        for (ToggleDialog td : this.allDialogs) {
            if (!type.isInstance(td)) continue;
            return type.cast(td);
        }
        return null;
    }

    public static enum Action {
        INVISIBLE_TO_DEFAULT,
        COLLAPSED_TO_DEFAULT,
        ELEMENT_SHRINKS;

    }

    static final class MinSizePanel
    extends JPanel {
        MinSizePanel() {
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(0, 40);
        }
    }
}

