/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.CyclicUploadDependencyException;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.io.AbstractIOTask;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmApiPrimitiveGoneException;
import org.openstreetmap.josm.io.OsmServerWriter;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.UploadStrategySpecification;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class UploadLayerTask
extends AbstractIOTask {
    private OsmServerWriter writer;
    private final OsmDataLayer layer;
    private final ProgressMonitor monitor;
    private final Changeset changeset;
    private Collection<OsmPrimitive> toUpload;
    private final Set<IPrimitive> processedPrimitives;
    private final UploadStrategySpecification strategy;

    public UploadLayerTask(UploadStrategySpecification strategy, OsmDataLayer layer, ProgressMonitor monitor, Changeset changeset) {
        CheckParameterUtil.ensureParameterNotNull(layer, "layer");
        CheckParameterUtil.ensureParameterNotNull(strategy, "strategy");
        this.layer = layer;
        this.monitor = Optional.ofNullable(monitor).orElse(NullProgressMonitor.INSTANCE);
        this.changeset = changeset;
        this.strategy = strategy;
        this.processedPrimitives = new HashSet<IPrimitive>();
    }

    protected OsmPrimitive getPrimitive(OsmPrimitiveType type, long id) {
        for (OsmPrimitive p : this.toUpload) {
            if (!OsmPrimitiveType.from(p).equals((Object)type) || p.getId() != id) continue;
            return p;
        }
        return null;
    }

    protected void recoverFromGoneOnServer(OsmApiPrimitiveGoneException e) throws OsmTransferException {
        if (!e.isKnownPrimitive()) {
            throw e;
        }
        OsmPrimitive p = this.getPrimitive(e.getPrimitiveType(), e.getPrimitiveId());
        if (p == null) {
            throw e;
        }
        if (p.isDeleted()) {
            Logging.warn(I18n.tr("Object ''{0}'' is already deleted on the server. Skipping this object and retrying to upload.", p.getDisplayName(DefaultNameFormatter.getInstance())));
            this.processedPrimitives.addAll(this.writer.getProcessedPrimitives());
            this.processedPrimitives.add(p);
            this.toUpload.removeAll(this.processedPrimitives);
            return;
        }
        throw e;
    }

    @Override
    public void run() {
        this.monitor.indeterminateSubTask(I18n.tr("Preparing objects to upload ...", new Object[0]));
        APIDataSet ds = new APIDataSet(this.layer.data);
        try {
            ds.adjustRelationUploadOrder();
        }
        catch (CyclicUploadDependencyException e) {
            this.setLastException(e);
            return;
        }
        this.toUpload = ds.getPrimitives();
        if (this.toUpload.isEmpty()) {
            return;
        }
        this.writer = new OsmServerWriter();
        try {
            while (true) {
                try {
                    ProgressMonitor m = this.monitor.createSubTaskMonitor(-1, false);
                    if (this.isCanceled()) {
                        return;
                    }
                    this.writer.uploadOsm(this.strategy, this.toUpload, this.changeset, m);
                    this.processedPrimitives.addAll(this.writer.getProcessedPrimitives());
                }
                catch (OsmApiPrimitiveGoneException e) {
                    this.recoverFromGoneOnServer(e);
                    continue;
                }
                break;
            }
            if (this.strategy.isCloseChangesetAfterUpload() && this.changeset != null && this.changeset.getId() > 0) {
                OsmApi.getOsmApi().closeChangeset(this.changeset, this.monitor.createSubTaskMonitor(0, false));
            }
        }
        catch (OsmTransferException sxe) {
            if (this.isCanceled()) {
                Logging.info("Ignoring exception caught because upload is canceled. Exception is: " + sxe);
                return;
            }
            this.setLastException(sxe);
        }
        if (this.isCanceled()) {
            return;
        }
        this.layer.cleanupAfterUpload(this.processedPrimitives);
        this.layer.onPostUploadToServer();
    }

    @Override
    public void cancel() {
        this.setCanceled(true);
        if (this.writer != null) {
            this.writer.cancel();
        }
    }
}

