/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public abstract class AbstractTextComponentValidator
implements ActionListener,
FocusListener,
DocumentListener,
PropertyChangeListener {
    private static final Border ERROR_BORDER = BorderFactory.createLineBorder(Color.RED, 1);
    private static final Color ERROR_BACKGROUND = new Color(255, 224, 224);
    private JTextComponent tc;
    private Boolean valid;
    private String msg;

    protected void feedbackInvalid(String msg) {
        if (this.valid == null || this.valid.booleanValue() || !Objects.equals(msg, this.msg)) {
            this.tc.setBorder(ERROR_BORDER);
            this.tc.setBackground(ERROR_BACKGROUND);
            this.tc.setToolTipText(msg);
            this.valid = Boolean.FALSE;
            this.msg = msg;
        }
    }

    protected void feedbackDisabled() {
        this.feedbackValid(null);
    }

    protected void feedbackValid(String msg) {
        if (this.valid == null || !this.valid.booleanValue() || !Objects.equals(msg, this.msg)) {
            this.tc.setBorder(UIManager.getBorder("TextField.border"));
            this.tc.setBackground(UIManager.getColor("TextField.background"));
            this.tc.setToolTipText(msg == null ? "" : msg);
            this.valid = Boolean.TRUE;
            this.msg = msg;
        }
    }

    public JTextComponent getComponent() {
        return this.tc;
    }

    public AbstractTextComponentValidator(JTextComponent tc) {
        this(tc, true);
    }

    public AbstractTextComponentValidator(JTextComponent tc, boolean addActionListener) {
        this(tc, true, true, addActionListener);
    }

    public AbstractTextComponentValidator(JTextComponent tc, boolean addFocusListener, boolean addDocumentListener, boolean addActionListener) {
        CheckParameterUtil.ensureParameterNotNull(tc, "tc");
        this.tc = tc;
        if (addFocusListener) {
            tc.addFocusListener(this);
        }
        if (addDocumentListener) {
            tc.getDocument().addDocumentListener(this);
        }
        if (addActionListener && tc instanceof JosmTextField) {
            ((JosmTextField)tc).addActionListener(this);
        }
        tc.addPropertyChangeListener("enabled", this);
    }

    public abstract void validate();

    public abstract boolean isValid();

    @Override
    public void focusGained(FocusEvent arg0) {
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        this.validate();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.validate();
    }

    @Override
    public void changedUpdate(DocumentEvent arg0) {
        this.validate();
    }

    @Override
    public void insertUpdate(DocumentEvent arg0) {
        this.validate();
    }

    @Override
    public void removeUpdate(DocumentEvent arg0) {
        this.validate();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("enabled".equals(evt.getPropertyName())) {
            boolean enabled = (Boolean)evt.getNewValue();
            if (enabled) {
                this.validate();
            } else {
                this.feedbackDisabled();
            }
        }
    }
}

