/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools.bugreport;

import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Supplier;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.StreamUtils;
import org.openstreetmap.josm.tools.bugreport.BugReport;
import org.openstreetmap.josm.tools.bugreport.BugReportQueue;

public class ReportedException
extends RuntimeException {
    private static final int MAX_COLLECTION_ENTRIES = 30;
    private static final long serialVersionUID = 737333873766201033L;
    private final transient Map<Thread, StackTraceElement[]> allStackTraces;
    private final LinkedList<Section> sections = new LinkedList();
    private final transient Thread caughtOnThread;
    private String methodWarningFrom;

    ReportedException(Throwable exception) {
        this(exception, Thread.currentThread());
    }

    ReportedException(Throwable exception, Thread caughtOnThread) {
        super(exception);
        this.allStackTraces = Thread.getAllStackTraces();
        this.caughtOnThread = caughtOnThread;
    }

    public void warn() {
        this.methodWarningFrom = BugReport.getCallingMethod(2);
        try {
            BugReportQueue.getInstance().submit(this);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    public void startSection(String sectionName) {
        this.sections.add(new Section(sectionName));
    }

    public void printReportDataTo(PrintWriter out) {
        out.println("=== REPORTED CRASH DATA ===");
        for (Section s : this.sections) {
            s.printSection(out);
            out.println();
        }
        if (this.methodWarningFrom != null) {
            out.println("Warning issued by: " + this.methodWarningFrom);
            out.println();
        }
    }

    public void printReportStackTo(PrintWriter out) {
        out.println("=== STACK TRACE ===");
        out.println(ReportedException.niceThreadName(this.caughtOnThread));
        this.getCause().printStackTrace(out);
        out.println();
    }

    public void printReportThreadsTo(PrintWriter out) {
        out.println("=== RUNNING THREADS ===");
        for (Map.Entry<Thread, StackTraceElement[]> thread : this.allStackTraces.entrySet()) {
            out.println(ReportedException.niceThreadName(thread.getKey()));
            if (this.caughtOnThread.equals(thread.getKey())) {
                out.println("Stacktrace see above.");
            } else {
                for (StackTraceElement e : thread.getValue()) {
                    out.println(e);
                }
            }
            out.println();
        }
    }

    private static String niceThreadName(Thread thread) {
        StringBuilder name = new StringBuilder("Thread: ").append(thread.getName()).append(" (").append(thread.getId()).append(')');
        ThreadGroup threadGroup = thread.getThreadGroup();
        if (threadGroup != null) {
            name.append(" of ").append(threadGroup.getName());
        }
        return name.toString();
    }

    public boolean isSame(ReportedException e) {
        if (!this.getMessage().equals(e.getMessage())) {
            return false;
        }
        return ReportedException.hasSameStackTrace(new CauseTraceIterator(), e.getCause());
    }

    private static boolean hasSameStackTrace(CauseTraceIterator causeTraceIterator, Throwable e2) {
        Throwable c2;
        Object[] t2;
        if (!causeTraceIterator.hasNext()) {
            return true;
        }
        Throwable e1 = causeTraceIterator.next();
        Object[] t1 = e1.getStackTrace();
        if (!Arrays.equals(t1, t2 = e2.getStackTrace())) {
            return false;
        }
        Throwable c1 = e1.getCause();
        if (c1 == null != ((c2 = e2.getCause()) == null)) {
            return false;
        }
        if (c1 != null) {
            return ReportedException.hasSameStackTrace(causeTraceIterator, c2);
        }
        return true;
    }

    public ReportedException put(String key, Object value) {
        return this.put(key, () -> value);
    }

    public ReportedException put(String key, Supplier<Object> valueSupplier) {
        String string;
        try {
            Object value = valueSupplier.get();
            string = value == null ? "null" : (value instanceof Collection ? ReportedException.makeCollectionNice((Collection)value) : (value.getClass().isArray() ? ReportedException.makeCollectionNice(Arrays.asList(value)) : value.toString()));
        }
        catch (RuntimeException t) {
            Logging.warn(t);
            string = "<Error calling toString()>";
        }
        this.sections.getLast().put(key, string);
        return this;
    }

    private static String makeCollectionNice(Collection<?> value) {
        int lines = 0;
        StringBuilder str = new StringBuilder(32);
        for (Object e : value) {
            str.append("\n    - ");
            if (lines <= 30) {
                str.append(e);
                continue;
            }
            str.append("\n    ... (").append(value.size()).append(" entries)");
            break;
        }
        return str.toString();
    }

    @Override
    public String toString() {
        return "ReportedException [thread=" + this.caughtOnThread + ", exception=" + this.getCause() + ", methodWarningFrom=" + this.methodWarningFrom + ']';
    }

    public boolean mayHaveConcurrentSource() {
        return StreamUtils.toStream(() -> new CauseTraceIterator()).anyMatch(t -> t instanceof ConcurrentModificationException || t instanceof InvocationTargetException);
    }

    public boolean isOutOfMemory() {
        return StreamUtils.toStream(() -> new CauseTraceIterator()).anyMatch(t -> t instanceof OutOfMemoryError);
    }

    private static class Section
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String sectionName;
        private final ArrayList<SectionEntry> entries = new ArrayList();

        Section(String sectionName) {
            this.sectionName = sectionName;
        }

        public void put(String key, String value) {
            this.entries.add(new SectionEntry(key, value));
        }

        public void printSection(PrintWriter out) {
            out.println(this.sectionName + ':');
            if (this.entries.isEmpty()) {
                out.println("No data collected.");
            } else {
                for (SectionEntry e : this.entries) {
                    e.print(out);
                }
            }
        }
    }

    private static class SectionEntry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String key;
        private final String value;

        SectionEntry(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public void print(PrintWriter out) {
            out.print(" - ");
            out.print(this.key);
            out.print(": ");
            out.println(this.value);
        }
    }

    private final class CauseTraceIterator
    implements Iterator<Throwable> {
        private Throwable current;
        private final Set<Throwable> dejaVu;

        private CauseTraceIterator() {
            this.current = ReportedException.this.getCause();
            this.dejaVu = Collections.newSetFromMap(new IdentityHashMap());
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public Throwable next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Throwable toReturn = this.current;
            this.advance();
            return toReturn;
        }

        private void advance() {
            this.dejaVu.add(this.current);
            this.current = this.current.getCause();
            if (this.current != null && this.dejaVu.contains(this.current)) {
                this.current = null;
            }
        }
    }
}

