/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import jnr.constants.platform.Signal;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubySignal;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.TypeConverter;

@JRubyClass(name={"SignalException"}, parent="Exception")
public class RubySignalException
extends RubyException {
    private static final ObjectAllocator SIGNAL_EXCEPTION_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubySignalException(runtime, klass);
        }
    };
    private IRubyObject signo;

    protected RubySignalException(Ruby runtime, RubyClass exceptionClass) {
        super(runtime, exceptionClass);
    }

    static RubyClass createSignalExceptionClass(Ruby runtime, RubyClass exceptionClass) {
        RubyClass signalExceptionClass = runtime.defineClass("SignalException", exceptionClass, SIGNAL_EXCEPTION_ALLOCATOR);
        signalExceptionClass.defineAnnotatedMethods(RubySignalException.class);
        return signalExceptionClass;
    }

    @JRubyMethod(optional=2, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2, Block block) {
        long _signo;
        Ruby runtime = context.runtime;
        int argnum = 1;
        IRubyObject sig = context.nil;
        int argc = args2.length;
        if (argc > 0) {
            sig = TypeConverter.checkIntegerType(runtime, args2[0], "to_int");
            if (sig.isNil()) {
                sig = args2[0];
            } else {
                argnum = 2;
            }
        }
        Arity.checkArgumentCount(runtime, args2, 1, argnum);
        if (argnum == 2) {
            _signo = sig.convertToInteger().getLongValue();
            if (_signo < 0L || _signo > Signal.NSIG.longValue()) {
                throw runtime.newArgumentError("invalid signal number (" + _signo + ")");
            }
            sig = argc > 1 ? args2[1] : runtime.newString(RubySignal.signmWithPrefix(RubySignal.signo2signm(_signo)));
        } else {
            String signm = sig.toString();
            _signo = RubySignal.signm2signo(RubySignal.signmWithoutPrefix(signm));
            if (_signo == 0L) {
                throw runtime.newArgumentError("unsupported name " + sig);
            }
            sig = runtime.newString(RubySignal.signmWithPrefix(signm));
        }
        super.initialize(new IRubyObject[]{sig}, block);
        this.signo = runtime.newFixnum(_signo);
        return this;
    }

    @JRubyMethod
    public IRubyObject signo(ThreadContext context) {
        assert (this.signo != null);
        if (this.signo == RubyBasicObject.UNDEF) {
            return context.nil;
        }
        return this.signo;
    }

    @Override
    @JRubyMethod(name={"message", "signm"})
    public IRubyObject message(ThreadContext context) {
        return super.message(context);
    }
}

