/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.text.CharSequenceWithStringHash;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.text.CharSequenceSubSequence;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class ByteArrayCharSequence
implements CharSequenceWithStringHash {
    private final int myStart;
    private final int myEnd;
    private transient int hash;
    private final byte[] myChars;

    private ByteArrayCharSequence(@NotNull byte[] chars) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/util/text/ByteArrayCharSequence", "<init>"));
        }
        this(chars, 0, chars.length);
    }

    public ByteArrayCharSequence(@NotNull byte[] chars, int start, int end) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/util/text/ByteArrayCharSequence", "<init>"));
        }
        this.myChars = chars;
        this.myStart = start;
        this.myEnd = end;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            this.hash = h = StringUtil.stringHashCode(this, this.myStart, this.myEnd);
        }
        return h;
    }

    @Override
    public final int length() {
        return this.myEnd - this.myStart;
    }

    @Override
    public final char charAt(int index2) {
        return (char)this.myChars[index2 + this.myStart];
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start, int end) {
        CharSequenceWithStringHash charSequenceWithStringHash = start == 0 && end == this.length() ? this : new CharSequenceSubSequence(this, start, end);
        if (charSequenceWithStringHash == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/ByteArrayCharSequence", "subSequence"));
        }
        return charSequenceWithStringHash;
    }

    @Override
    @NotNull
    public String toString() {
        String string = new String(this.myChars, this.myStart, this.length(), CharsetToolkit.US_ASCII_CHARSET);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/ByteArrayCharSequence", "toString"));
        }
        return string;
    }

    @NotNull
    public static CharSequence convertToBytesIfAsciiString(@NotNull CharSequence name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/text/ByteArrayCharSequence", "convertToBytesIfAsciiString"));
        }
        int length = name.length();
        if (length == 0) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/ByteArrayCharSequence", "convertToBytesIfAsciiString"));
            }
            return "";
        }
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            if (c >= '\u0080') {
                String string = new String(name.toString());
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/ByteArrayCharSequence", "convertToBytesIfAsciiString"));
                }
                return string;
            }
            bytes[i] = (byte)c;
        }
        ByteArrayCharSequence byteArrayCharSequence = new ByteArrayCharSequence(bytes);
        if (byteArrayCharSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/ByteArrayCharSequence", "convertToBytesIfAsciiString"));
        }
        return byteArrayCharSequence;
    }

    @NotNull
    byte[] getBytes() {
        byte[] byArray = this.myStart == 0 && this.myEnd == this.myChars.length ? this.myChars : Arrays.copyOfRange(this.myChars, this.myStart, this.myEnd);
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/ByteArrayCharSequence", "getBytes"));
        }
        return byArray;
    }
}

