/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.io;

import com.eteks.sweethome3d.io.HomeURLContent;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.tools.ResourceURLContent;
import com.eteks.sweethome3d.tools.SimpleURLContent;
import com.eteks.sweethome3d.tools.URLContent;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentDigestManager {
    private static final String DIGEST_ALGORITHM = "SHA-1";
    private static final byte[] INVALID_CONTENT_DIGEST = new byte[0];
    private static ContentDigestManager instance;
    private Map<Content, byte[]> contentDigestsCache = new WeakHashMap<Content, byte[]>();
    private Map<URLContent, URL> zipUrlsCache = new WeakHashMap<URLContent, URL>();
    private Map<URL, List<ZipEntryData>> zipUrlEntriesCache = new WeakHashMap<URL, List<ZipEntryData>>();

    private ContentDigestManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ContentDigestManager getInstance() {
        if (instance != null) return instance;
        Class<ContentDigestManager> clazz = ContentDigestManager.class;
        synchronized (ContentDigestManager.class) {
            if (instance != null) return instance;
            instance = new ContentDigestManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public boolean equals(Content content, Content content2) {
        byte[] byArray = this.getContentDigest(content);
        if (byArray == INVALID_CONTENT_DIGEST) {
            return false;
        }
        return Arrays.equals(byArray, this.getContentDigest(content2));
    }

    public boolean isContentDigestEqual(Content content, byte[] byArray) {
        byte[] byArray2 = this.getContentDigest(content);
        if (byArray2 == INVALID_CONTENT_DIGEST) {
            return false;
        }
        return Arrays.equals(byArray2, byArray);
    }

    public synchronized void setContentDigest(Content content, byte[] byArray) {
        this.contentDigestsCache.put(content, byArray);
    }

    public synchronized byte[] getContentDigest(Content content) {
        byte[] byArray = this.contentDigestsCache.get(content);
        if (byArray == null) {
            try {
                URLContent uRLContent;
                byArray = content instanceof ResourceURLContent ? this.getResourceContentDigest((ResourceURLContent)content) : (content instanceof URLContent && !(content instanceof SimpleURLContent) && ((URLContent)content).isJAREntry() ? ((uRLContent = (URLContent)content) instanceof HomeURLContent ? this.getHomeContentDigest((HomeURLContent)uRLContent) : this.getZipContentDigest(uRLContent)) : this.computeContentDigest(content));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new InternalError("No SHA-1 message digest is available");
            }
            catch (IOException iOException) {
                byArray = INVALID_CONTENT_DIGEST;
            }
            this.contentDigestsCache.put(content, byArray);
        }
        return byArray;
    }

    private byte[] getResourceContentDigest(ResourceURLContent resourceURLContent) throws IOException, NoSuchAlgorithmException {
        if (resourceURLContent.isMultiPartResource()) {
            if (resourceURLContent.isJAREntry()) {
                URL uRL = resourceURLContent.getJAREntryURL();
                String string = resourceURLContent.getJAREntryName();
                int n = string.lastIndexOf(47);
                if (n != -1) {
                    MessageDigest messageDigest = MessageDigest.getInstance(DIGEST_ALGORITHM);
                    String string2 = string.substring(0, n + 1);
                    for (ZipEntryData zipEntryData : this.getZipURLEntries(resourceURLContent)) {
                        String string3 = zipEntryData.getName();
                        if (!string3.startsWith(string2) || string3.equals(string2) || !this.isSignificant(string3)) continue;
                        URLContent uRLContent = new URLContent(new URL("jar:" + uRL + "!/" + URLEncoder.encode(string3, "UTF-8").replace("+", "%20")));
                        this.updateMessageDigest(messageDigest, uRLContent);
                    }
                    return messageDigest.digest();
                }
                return this.computeContentDigest(resourceURLContent);
            }
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(DIGEST_ALGORITHM);
                File file = new File(resourceURLContent.getURL().toURI());
                File file2 = new File(file.getParent());
                Object[] objectArray = file2.listFiles();
                Arrays.sort(objectArray);
                for (Object object : objectArray) {
                    if (((File)object).isDirectory()) continue;
                    this.updateMessageDigest(messageDigest, new URLContent(((File)object).toURI().toURL()));
                }
                return messageDigest.digest();
            }
            catch (URISyntaxException uRISyntaxException) {
                IOException iOException = new IOException();
                iOException.initCause(uRISyntaxException);
                throw iOException;
            }
        }
        return this.computeContentDigest(resourceURLContent);
    }

    private byte[] getHomeContentDigest(HomeURLContent homeURLContent) throws IOException, NoSuchAlgorithmException {
        String string = homeURLContent.getJAREntryName();
        int n = string.indexOf(47);
        if (n > 0) {
            URL uRL = homeURLContent.getJAREntryURL();
            String string2 = string.substring(0, n + 1);
            MessageDigest messageDigest = MessageDigest.getInstance(DIGEST_ALGORITHM);
            for (ZipEntryData zipEntryData : this.getZipURLEntries(homeURLContent)) {
                String string3 = zipEntryData.getName();
                if (!string3.startsWith(string2) || string3.equals(string2) || !this.isSignificant(string3)) continue;
                URLContent uRLContent = new URLContent(new URL("jar:" + uRL + "!/" + URLEncoder.encode(string3, "UTF-8").replace("+", "%20")));
                this.updateMessageDigest(messageDigest, uRLContent);
            }
            return messageDigest.digest();
        }
        return this.computeContentDigest(homeURLContent);
    }

    private byte[] getZipContentDigest(URLContent uRLContent) throws IOException, NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(DIGEST_ALGORITHM);
        for (ZipEntryData zipEntryData : ContentDigestManager.getInstance().getZipURLEntries(uRLContent)) {
            if (!this.isSignificant(zipEntryData.getName())) continue;
            URLContent uRLContent2 = new URLContent(new URL("jar:" + uRLContent.getJAREntryURL() + "!/" + URLEncoder.encode(zipEntryData.getName(), "UTF-8").replace("+", "%20")));
            this.updateMessageDigest(messageDigest, uRLContent2);
        }
        return messageDigest.digest();
    }

    private boolean isSignificant(String string) {
        String string2 = string.toUpperCase();
        return !string2.equals("LICENSE.TXT") && !string2.endsWith("/LICENSE.TXT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized List<ZipEntryData> getZipURLEntries(URLContent uRLContent) throws IOException {
        Map.Entry<URL, List<ZipEntryData>> entry2;
        URL uRL = this.zipUrlsCache.get(uRLContent);
        if (uRL != null) {
            return this.zipUrlEntriesCache.get(uRL);
        }
        uRL = uRLContent.getJAREntryURL();
        for (Map.Entry<URL, List<ZipEntryData>> entry2 : this.zipUrlEntriesCache.entrySet()) {
            if (!uRL.equals(entry2.getKey())) continue;
            this.zipUrlsCache.put(uRLContent, entry2.getKey());
            return entry2.getValue();
        }
        ArrayList arrayList = new ArrayList();
        if (uRL.getProtocol().equals("file")) {
            entry2 = null;
            try {
                entry2 = new ZipFile(new File(uRL.toURI()));
                Enumeration<? extends ZipEntry> enumeration = ((ZipFile)((Object)entry2)).entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = enumeration.nextElement();
                    arrayList.add(new ZipEntryData(zipEntry.getName(), zipEntry.getSize()));
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                IOException iOException = new IOException("Can't retrieve zip file");
                iOException.initCause(uRISyntaxException);
                throw iOException;
            }
            finally {
                if (entry2 != null) {
                    ((ZipFile)((Object)entry2)).close();
                }
            }
        }
        entry2 = null;
        try {
            ZipEntry zipEntry;
            entry2 = new ZipInputStream(uRL.openStream());
            while ((zipEntry = ((ZipInputStream)((Object)entry2)).getNextEntry()) != null) {
                long l = zipEntry.getSize();
                if (l == -1L) {
                    int n;
                    l = 0L;
                    byte[] byArray = new byte[8192];
                    while ((n = ((FilterInputStream)((Object)entry2)).read(byArray)) != -1) {
                        l += (long)n;
                    }
                }
                arrayList.add(new ZipEntryData(zipEntry.getName(), l));
            }
        }
        finally {
            if (entry2 != null) {
                ((ZipInputStream)((Object)entry2)).close();
            }
        }
        Collections.sort(arrayList);
        this.zipUrlEntriesCache.put(uRL, arrayList);
        this.zipUrlsCache.put(uRLContent, uRL);
        return arrayList;
    }

    private byte[] computeContentDigest(Content content) throws IOException, NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(DIGEST_ALGORITHM);
        this.updateMessageDigest(messageDigest, content);
        return messageDigest.digest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMessageDigest(MessageDigest messageDigest, Content content) throws IOException {
        InputStream inputStream = null;
        try {
            int n;
            inputStream = content.openStream();
            byte[] byArray = new byte[8192];
            while ((n = inputStream.read(byArray)) != -1) {
                messageDigest.update(byArray, 0, n);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public synchronized Long getContentSize(Content content) {
        try {
            if (content instanceof ResourceURLContent) {
                return this.getResourceContentSize((ResourceURLContent)content);
            }
            if (content instanceof URLContent) {
                URLContent uRLContent = (URLContent)content;
                if (uRLContent.isJAREntry() && uRLContent instanceof HomeURLContent) {
                    return this.getHomeContentSize((HomeURLContent)uRLContent);
                }
                return uRLContent.getSize();
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private long getResourceContentSize(ResourceURLContent resourceURLContent) throws IOException {
        if (resourceURLContent.isMultiPartResource()) {
            if (resourceURLContent.isJAREntry()) {
                String string = resourceURLContent.getJAREntryName();
                int n = string.lastIndexOf(47);
                List<ZipEntryData> list = this.getZipURLEntries(resourceURLContent);
                if (n != -1) {
                    String string2 = string.substring(0, n + 1);
                    long l = 0L;
                    for (ZipEntryData zipEntryData : list) {
                        if (!zipEntryData.getName().startsWith(string2)) continue;
                        l += zipEntryData.getSize();
                    }
                    return l;
                }
                int n2 = Collections.binarySearch(list, new ZipEntryData(resourceURLContent.getJAREntryName()));
                return list.get(n2).getSize();
            }
            try {
                File file = new File(resourceURLContent.getURL().toURI());
                File file2 = new File(file.getParent());
                File[] fileArray = file2.listFiles();
                long l = 0L;
                for (File file3 : fileArray) {
                    if (file3.isDirectory()) continue;
                    l += file3.length();
                }
                return l;
            }
            catch (URISyntaxException uRISyntaxException) {
                IOException iOException = new IOException();
                iOException.initCause(uRISyntaxException);
                throw iOException;
            }
        }
        if (resourceURLContent.isJAREntry()) {
            List<ZipEntryData> list = this.getZipURLEntries(resourceURLContent);
            int n = Collections.binarySearch(list, new ZipEntryData(resourceURLContent.getJAREntryName()));
            return list.get(n).getSize();
        }
        return new SimpleURLContent(resourceURLContent.getURL()).getSize();
    }

    private long getHomeContentSize(HomeURLContent homeURLContent) throws IOException {
        String string = homeURLContent.getJAREntryName();
        List<ZipEntryData> list = this.getZipURLEntries(homeURLContent);
        int n = string.indexOf(47);
        if (n > 0) {
            String string2 = string.substring(0, n + 1);
            long l = 0L;
            for (ZipEntryData zipEntryData : this.getZipURLEntries(homeURLContent)) {
                if (!zipEntryData.getName().startsWith(string2)) continue;
                l += zipEntryData.getSize();
            }
            return l;
        }
        int n2 = Collections.binarySearch(list, new ZipEntryData(homeURLContent.getJAREntryName()));
        return list.get(n2).getSize();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ZipEntryData
    implements Comparable<ZipEntryData> {
        private String name;
        private long size;

        private ZipEntryData(String string) {
            this(string, -1L);
        }

        private ZipEntryData(String string, long l) {
            this.name = string;
            this.size = l;
        }

        public String getName() {
            return this.name;
        }

        public long getSize() {
            return this.size;
        }

        @Override
        public int compareTo(ZipEntryData zipEntryData) {
            return this.name.compareTo(zipEntryData.name);
        }
    }
}

