/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.tk.quantum.AbstractPainter;
import com.sun.javafx.tk.quantum.ViewScene;
import java.util.Locale;
import java.util.ResourceBundle;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.PauseTransition;
import javafx.animation.SequentialTransition;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Rectangle2D;
import javafx.scene.Group;
import javafx.scene.Scene;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.stage.Screen;
import javafx.util.Duration;

public class OverlayWarning {
    private static final Locale LOCALE = Locale.getDefault();
    private static final ResourceBundle RESOURCES = ResourceBundle.getBundle(OverlayWarning.class.getPackage().getName() + ".QuantumMessagesBundle", LOCALE);
    private static final float PAD = 40.0f;
    private static final float RECTW = 600.0f;
    private static final float RECTH = 100.0f;
    private static final float ARC = 20.0f;
    private static final int FONTSIZE = 24;
    private ViewScene view;
    private Group sceneRoot;
    private SequentialTransition overlayTransition;
    private AbstractPainter painter;
    private boolean warningTransition;
    private Text text;
    private Rectangle background;
    private Group root;

    public static String localize(String string) {
        return RESOURCES.getString(string);
    }

    public OverlayWarning(ViewScene viewScene) {
        this.view = viewScene;
        this.sceneRoot = this.createOverlayGroup();
        this.painter = this.view.getPen().getPainter();
        Scene.impl_setAllowPGAccess(true);
        this.painter.setOverlayRoot((NGNode)this.sceneRoot.impl_getPGNode());
        Scene.impl_setAllowPGAccess(false);
        PauseTransition pauseTransition = new PauseTransition(Duration.millis(4000.0));
        FadeTransition fadeTransition = new FadeTransition(Duration.millis(1000.0), this.sceneRoot);
        fadeTransition.setFromValue(1.0);
        fadeTransition.setToValue(0.0);
        this.overlayTransition = new SequentialTransition();
        this.overlayTransition.getChildren().add(pauseTransition);
        this.overlayTransition.getChildren().add(fadeTransition);
        this.overlayTransition.setOnFinished(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent actionEvent) {
                OverlayWarning.this.painter.setRenderOverlay(false);
                OverlayWarning.this.view.entireSceneNeedsRepaint();
                OverlayWarning.this.warningTransition = false;
            }
        });
    }

    protected ViewScene getView() {
        return this.view;
    }

    protected final void setView(ViewScene viewScene) {
        if (this.painter != null) {
            this.painter.setRenderOverlay(false);
            this.view.entireSceneNeedsRepaint();
        }
        this.view = viewScene;
        this.painter = viewScene.getPen().getPainter();
        Scene.impl_setAllowPGAccess(true);
        this.painter.setOverlayRoot((NGNode)this.sceneRoot.impl_getPGNode());
        Scene.impl_setAllowPGAccess(false);
        this.painter.setRenderOverlay(true);
        this.view.entireSceneNeedsRepaint();
        this.overlayTransition.setOnFinished(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent actionEvent) {
                OverlayWarning.this.painter.setRenderOverlay(false);
                OverlayWarning.this.view.entireSceneNeedsRepaint();
                OverlayWarning.this.warningTransition = false;
            }
        });
    }

    protected void warn() {
        this.warningTransition = true;
        this.painter.setRenderOverlay(true);
        this.overlayTransition.play();
    }

    protected void cancel() {
        if (this.overlayTransition != null && this.overlayTransition.getStatus() == Animation.Status.RUNNING) {
            this.overlayTransition.stop();
            this.painter.setRenderOverlay(false);
            this.view.entireSceneNeedsRepaint();
            this.warningTransition = false;
        }
    }

    protected boolean inWarningTransition() {
        return this.warningTransition;
    }

    private Group createOverlayGroup() {
        Scene scene = new Scene(new Group());
        Font font = new Font(Font.getDefault().getFamily(), 24.0);
        Text text = new Text();
        Rectangle2D rectangle2D = Screen.getPrimary().getBounds();
        scene.setFill(null);
        String string = "-fx-effect: dropshadow(two-pass-box, rgba(0,0,0,0.75), 3, 0.0, 0, 2);";
        text.setText(OverlayWarning.localize("OverlayWarningESC"));
        text.setStroke(Color.WHITE);
        text.setFill(Color.WHITE);
        text.setFont(font);
        text.setWrappingWidth(520.0);
        text.setStyle(string);
        text.setTextAlignment(TextAlignment.CENTER);
        Rectangle rectangle = this.createBackground(text, rectangle2D);
        Group group = (Group)scene.getRoot();
        group.getChildren().add(rectangle);
        group.getChildren().add(text);
        Scene.impl_setAllowPGAccess(true);
        text.impl_updatePG();
        rectangle.impl_updatePG();
        group.impl_updatePG();
        Scene.impl_setAllowPGAccess(false);
        return group;
    }

    private Rectangle createBackground(Text text, Rectangle2D rectangle2D) {
        Rectangle rectangle = new Rectangle();
        double d = text.getLayoutBounds().getWidth();
        double d2 = text.getLayoutBounds().getHeight();
        double d3 = (rectangle2D.getWidth() - 600.0) / 2.0;
        double d4 = rectangle2D.getHeight() / 2.0;
        rectangle.setWidth(600.0);
        rectangle.setHeight(100.0);
        rectangle.setX(d3);
        rectangle.setY(d4 - 100.0);
        rectangle.setArcWidth(20.0);
        rectangle.setArcHeight(20.0);
        rectangle.setFill(Color.gray(0.0, 0.6));
        text.setX(d3 + (600.0 - d) / 2.0);
        text.setY(d4 - 50.0 + (d2 - text.getBaselineOffset()) / 2.0);
        return rectangle;
    }
}

