/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.similarity;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.search.similarities.PerFieldSimilarityWrapper;
import org.apache.lucene.search.similarities.Similarity;
import org.elasticsearch.Version;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.similarity.BM25SimilarityProvider;
import org.elasticsearch.index.similarity.BooleanSimilarityProvider;
import org.elasticsearch.index.similarity.ClassicSimilarityProvider;
import org.elasticsearch.index.similarity.DFISimilarityProvider;
import org.elasticsearch.index.similarity.DFRSimilarityProvider;
import org.elasticsearch.index.similarity.IBSimilarityProvider;
import org.elasticsearch.index.similarity.LMDirichletSimilarityProvider;
import org.elasticsearch.index.similarity.LMJelinekMercerSimilarityProvider;
import org.elasticsearch.index.similarity.SimilarityProvider;

public final class SimilarityService
extends AbstractIndexComponent {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(Loggers.getLogger(SimilarityService.class));
    public static final String DEFAULT_SIMILARITY = "BM25";
    private final Similarity defaultSimilarity;
    private final Map<String, SimilarityProvider> similarities;
    private static final Map<String, TriFunction<String, Settings, Settings, SimilarityProvider>> DEFAULTS;
    public static final Map<String, TriFunction<String, Settings, Settings, SimilarityProvider>> BUILT_IN;

    public SimilarityService(IndexSettings indexSettings, Map<String, TriFunction<String, Settings, Settings, SimilarityProvider>> similarities) {
        super(indexSettings);
        HashMap<String, SimilarityProvider> providers = new HashMap<String, SimilarityProvider>(similarities.size());
        Map<String, Settings> similaritySettings = this.indexSettings.getSettings().getGroups("index.similarity");
        for (Map.Entry<String, Settings> entry : similaritySettings.entrySet()) {
            String name = entry.getKey();
            if (BUILT_IN.containsKey(name) && indexSettings.getIndexVersionCreated().onOrAfter(Version.V_5_0_0_alpha1)) {
                throw new IllegalArgumentException("Cannot redefine built-in Similarity [" + name + "]");
            }
            Settings providerSettings = entry.getValue();
            String typeName = providerSettings.get("type");
            if (typeName == null) {
                throw new IllegalArgumentException("Similarity [" + name + "] must have an associated type");
            }
            if (!(similarities.containsKey(typeName) || BUILT_IN.containsKey(typeName))) {
                throw new IllegalArgumentException("Unknown Similarity type [" + typeName + "] for [" + name + "]");
            }
            TriFunction<String, Settings, Settings, SimilarityProvider> defaultFactory = BUILT_IN.get(typeName);
            TriFunction<String, Settings, Settings, SimilarityProvider> factory = similarities.getOrDefault(typeName, defaultFactory);
            if (providerSettings == null) {
                providerSettings = Settings.Builder.EMPTY_SETTINGS;
            }
            providers.put(name, factory.apply(name, providerSettings, indexSettings.getSettings()));
        }
        Map<String, SimilarityProvider> providerMapping = this.addSimilarities(similaritySettings, indexSettings.getSettings(), DEFAULTS);
        for (Map.Entry<String, SimilarityProvider> entry : providerMapping.entrySet()) {
            if (providers.containsKey(entry.getKey()) && indexSettings.getIndexVersionCreated().before(Version.V_5_0_0_alpha1)) continue;
            providers.put(entry.getKey(), entry.getValue());
        }
        this.similarities = providers;
        Similarity similarity = this.defaultSimilarity = providers.get("default") != null ? ((SimilarityProvider)providers.get("default")).get() : ((SimilarityProvider)providers.get(DEFAULT_SIMILARITY)).get();
        if (providers.get("base") != null) {
            DEPRECATION_LOGGER.deprecated("The [base] similarity is ignored since query normalization and coords have been removed", new Object[0]);
        }
    }

    public Similarity similarity(MapperService mapperService) {
        return mapperService != null ? new PerFieldSimilarity(this.defaultSimilarity, mapperService) : this.defaultSimilarity;
    }

    private Map<String, SimilarityProvider> addSimilarities(Map<String, Settings> similaritySettings, Settings indexSettings, Map<String, TriFunction<String, Settings, Settings, SimilarityProvider>> similarities) {
        HashMap<String, SimilarityProvider> providers = new HashMap<String, SimilarityProvider>(similarities.size());
        for (Map.Entry<String, TriFunction<String, Settings, Settings, SimilarityProvider>> entry : similarities.entrySet()) {
            String name = entry.getKey();
            TriFunction<String, Settings, Settings, SimilarityProvider> factory = entry.getValue();
            Settings providerSettings = similaritySettings.get(name);
            if (providerSettings == null) {
                providerSettings = Settings.Builder.EMPTY_SETTINGS;
            }
            providers.put(name, factory.apply(name, providerSettings, indexSettings));
        }
        return providers;
    }

    public SimilarityProvider getSimilarity(String name) {
        return this.similarities.get(name);
    }

    Similarity getDefaultSimilarity() {
        return this.defaultSimilarity;
    }

    static {
        HashMap<String, TriFunction<String, Settings, Settings, SimilarityProvider>> defaults = new HashMap<String, TriFunction<String, Settings, Settings, SimilarityProvider>>();
        defaults.put("classic", ClassicSimilarityProvider::new);
        defaults.put(DEFAULT_SIMILARITY, BM25SimilarityProvider::new);
        defaults.put("boolean", BooleanSimilarityProvider::new);
        HashMap<String, TriFunction<String, Settings, Settings, SimilarityProvider>> builtIn = new HashMap<String, TriFunction<String, Settings, Settings, SimilarityProvider>>(defaults);
        builtIn.put("DFR", DFRSimilarityProvider::new);
        builtIn.put("IB", IBSimilarityProvider::new);
        builtIn.put("LMDirichlet", LMDirichletSimilarityProvider::new);
        builtIn.put("LMJelinekMercer", LMJelinekMercerSimilarityProvider::new);
        builtIn.put("DFI", DFISimilarityProvider::new);
        DEFAULTS = Collections.unmodifiableMap(defaults);
        BUILT_IN = Collections.unmodifiableMap(builtIn);
    }

    static class PerFieldSimilarity
    extends PerFieldSimilarityWrapper {
        private final Similarity defaultSimilarity;
        private final MapperService mapperService;

        PerFieldSimilarity(Similarity defaultSimilarity, MapperService mapperService) {
            this.defaultSimilarity = defaultSimilarity;
            this.mapperService = mapperService;
        }

        public Similarity get(String name) {
            MappedFieldType fieldType = this.mapperService.fullName(name);
            return fieldType != null && fieldType.similarity() != null ? fieldType.similarity().get() : this.defaultSimilarity;
        }
    }
}

