/*
 * Decompiled with CFR 0.152.
 */
package esmska.utils;

import esmska.utils.L10N;
import esmska.utils.RuntimeUtils;
import java.awt.Component;
import java.awt.HeadlessException;
import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;

public class ConfirmingFileChooser
extends JFileChooser {
    private static final ResourceBundle l10n = L10N.l10nBundle;
    private static String overwriteOption = l10n.getString("Replace");
    private static String cancelOption = l10n.getString("Cancel");
    private static Object[] options = RuntimeUtils.sortDialogOptions(cancelOption, overwriteOption);

    @Override
    public void approveSelection() {
        if (this.getDialogType() == 1 && this.fileExists()) {
            boolean overwrite = this.showConfirmOverwriteDialog();
            if (overwrite) {
                super.approveSelection();
            }
        } else {
            super.approveSelection();
        }
    }

    @Override
    protected JDialog createDialog(Component parent) throws HeadlessException {
        JDialog dialog = super.createDialog(parent);
        RuntimeUtils.setDocumentModalDialog(dialog);
        return dialog;
    }

    private boolean showConfirmOverwriteDialog() {
        String message = MessageFormat.format(l10n.getString("ConfirmingFileChooser.sure_to_replace"), this.getSelectedFile().getName(), this.getSelectedFile().getParent());
        JOptionPane pane = new JOptionPane(message, 3, -1, null, options, overwriteOption);
        JDialog confirmDialog = pane.createDialog(this.getParent(), null);
        RuntimeUtils.setDocumentModalDialog(confirmDialog);
        confirmDialog.setResizable(true);
        confirmDialog.pack();
        confirmDialog.setVisible(true);
        confirmDialog.dispose();
        Object value = pane.getValue();
        return overwriteOption.equals(value);
    }

    private boolean fileExists() {
        File file = this.getSelectedFile();
        if (file.exists()) {
            return true;
        }
        FileNameExtensionFilter choosedFilter = (FileNameExtensionFilter)this.getFileFilter();
        if (choosedFilter.getExtensions().length == 0) {
            return file.exists();
        }
        boolean hasExtension = false;
        String fileName = file.getAbsolutePath();
        for (String ext : choosedFilter.getExtensions()) {
            if (!fileName.endsWith("." + ext)) continue;
            hasExtension = true;
            break;
        }
        if (!hasExtension) {
            file = new File(fileName + "." + choosedFilter.getExtensions()[0]);
            this.setSelectedFile(file);
        }
        return file.exists();
    }
}

