/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32.COM.util;

import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.COM.COMException;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.COM.ConnectionPoint;
import com.sun.jna.platform.win32.COM.ConnectionPointContainer;
import com.sun.jna.platform.win32.COM.Dispatch;
import com.sun.jna.platform.win32.COM.IDispatch;
import com.sun.jna.platform.win32.COM.util.CallbackProxy;
import com.sun.jna.platform.win32.COM.util.ComEventCallbackCookie;
import com.sun.jna.platform.win32.COM.util.ComThread;
import com.sun.jna.platform.win32.COM.util.Convert;
import com.sun.jna.platform.win32.COM.util.Factory;
import com.sun.jna.platform.win32.COM.util.IComEnum;
import com.sun.jna.platform.win32.COM.util.IComEventCallbackCookie;
import com.sun.jna.platform.win32.COM.util.IComEventCallbackListener;
import com.sun.jna.platform.win32.COM.util.IConnectionPoint;
import com.sun.jna.platform.win32.COM.util.IConnectionPointContainer;
import com.sun.jna.platform.win32.COM.util.IRawDispatchHandle;
import com.sun.jna.platform.win32.COM.util.IUnknown;
import com.sun.jna.platform.win32.COM.util.annotation.ComInterface;
import com.sun.jna.platform.win32.COM.util.annotation.ComMethod;
import com.sun.jna.platform.win32.COM.util.annotation.ComProperty;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.OaIdl;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.Variant;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

public class ProxyObject
implements com.sun.jna.platform.win32.COM.util.IDispatch,
IRawDispatchHandle,
InvocationHandler {
    long unknownId;
    Class<?> theInterface;
    Factory factory;
    ComThread comThread;
    IDispatch rawDispatch;
    public static final WinDef.LCID LOCALE_USER_DEFAULT = Kernel32.INSTANCE.GetUserDefaultLCID();
    public static final WinDef.LCID LOCALE_SYSTEM_DEFAULT = Kernel32.INSTANCE.GetSystemDefaultLCID();

    public ProxyObject(Class<?> theInterface, IDispatch rawDispatch, Factory factory2) {
        this.unknownId = -1L;
        this.rawDispatch = rawDispatch;
        this.comThread = factory2.getComThread();
        this.theInterface = theInterface;
        this.factory = factory2;
        int n = this.rawDispatch.AddRef();
        this.getUnknownId();
        factory2.register(this);
    }

    ProxyObject(Class<?> theInterface, long unknownId, IDispatch rawDispatch, Factory factory2) {
        this.unknownId = unknownId;
        this.rawDispatch = rawDispatch;
        this.comThread = factory2.getComThread();
        this.theInterface = theInterface;
        this.factory = factory2;
        int n = this.rawDispatch.AddRef();
        factory2.register(this);
    }

    long getUnknownId() {
        if (-1L == this.unknownId) {
            try {
                final PointerByReference ppvObject = new PointerByReference();
                Thread current = Thread.currentThread();
                String tn = current.getName();
                WinNT.HRESULT hr = this.comThread.execute(new Callable<WinNT.HRESULT>(){

                    @Override
                    public WinNT.HRESULT call() throws Exception {
                        Guid.IID iid = com.sun.jna.platform.win32.COM.IUnknown.IID_IUNKNOWN;
                        return ProxyObject.this.getRawDispatch().QueryInterface(new Guid.GUID.ByValue(iid), ppvObject);
                    }
                });
                if (!WinNT.S_OK.equals(hr)) {
                    String formatMessageFromHR = Kernel32Util.formatMessage(hr);
                    throw new COMException("getUnknownId: " + formatMessageFromHR);
                }
                Dispatch dispatch = new Dispatch(ppvObject.getValue());
                this.unknownId = Pointer.nativeValue(dispatch.getPointer());
                int n = dispatch.Release();
            }
            catch (Exception e) {
                throw new COMException("Error occured when trying get Unknown Id ", e);
            }
        }
        return this.unknownId;
    }

    protected void finalize() throws Throwable {
        this.dispose(1);
    }

    public void dispose(int r) {
        if (!((Dispatch)this.rawDispatch).getPointer().equals(Pointer.NULL)) {
            for (int i = 0; i < r; ++i) {
                int n;
                int n2 = n = this.rawDispatch.Release();
            }
            this.factory.unregister(this, r);
            ((Dispatch)this.rawDispatch).setPointer(Pointer.NULL);
        }
    }

    @Override
    public IDispatch getRawDispatch() {
        return this.rawDispatch;
    }

    public boolean equals(Object arg) {
        if (null == arg) {
            return false;
        }
        if (arg instanceof ProxyObject) {
            ProxyObject other = (ProxyObject)arg;
            return this.getUnknownId() == other.getUnknownId();
        }
        if (Proxy.isProxyClass(arg.getClass())) {
            InvocationHandler handler2 = Proxy.getInvocationHandler(arg);
            if (handler2 instanceof ProxyObject) {
                try {
                    ProxyObject other = (ProxyObject)handler2;
                    return this.getUnknownId() == other.getUnknownId();
                }
                catch (Exception e) {
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return Long.valueOf(this.getUnknownId()).intValue();
    }

    public String toString() {
        return this.theInterface.getName() + "{unk=" + this.hashCode() + "}";
    }

    @Override
    public Object invoke(Object proxy2, Method method, Object[] args) throws Throwable {
        return this.invokeSynchronised(proxy2, method, args);
    }

    synchronized Object invokeSynchronised(Object proxy2, Method method, Object[] args) throws Throwable {
        if (method.equals(Object.class.getMethod("toString", new Class[0]))) {
            return this.toString();
        }
        if (method.equals(Object.class.getMethod("equals", Object.class))) {
            return this.equals(args[0]);
        }
        if (method.equals(Object.class.getMethod("hashCode", new Class[0]))) {
            return this.hashCode();
        }
        if (method.equals(IRawDispatchHandle.class.getMethod("getRawDispatch", new Class[0]))) {
            return this.getRawDispatch();
        }
        if (method.equals(IUnknown.class.getMethod("queryInterface", Class.class))) {
            return this.queryInterface((Class)args[0]);
        }
        if (method.equals(IConnectionPoint.class.getMethod("advise", Class.class, IComEventCallbackListener.class))) {
            return this.advise((Class)args[0], (IComEventCallbackListener)args[1]);
        }
        if (method.equals(IConnectionPoint.class.getMethod("unadvise", Class.class, IComEventCallbackCookie.class))) {
            this.unadvise((Class)args[0], (IComEventCallbackCookie)args[1]);
            return null;
        }
        Class<?> returnType = method.getReturnType();
        boolean isVoid = Void.TYPE.equals(returnType);
        ComProperty prop = method.getAnnotation(ComProperty.class);
        if (null != prop) {
            if (isVoid) {
                String propName = this.getMutatorName(method, prop);
                this.setProperty(propName, args[0]);
                return null;
            }
            String propName = this.getAccessorName(method, prop);
            return this.getProperty(returnType, propName, args);
        }
        ComMethod meth = method.getAnnotation(ComMethod.class);
        if (null != meth) {
            String methName = this.getMethodName(method, meth);
            Object res2 = this.invokeMethod(returnType, methName, args);
            return res2;
        }
        return null;
    }

    ConnectionPoint fetchRawConnectionPoint(Guid.IID iid) throws InterruptedException, ExecutionException, TimeoutException {
        IConnectionPointContainer cpc = this.queryInterface(IConnectionPointContainer.class);
        Dispatch rawCpcDispatch = (Dispatch)cpc.getRawDispatch();
        final ConnectionPointContainer rawCpc = new ConnectionPointContainer(rawCpcDispatch.getPointer());
        final Guid.REFIID adviseRiid = new Guid.REFIID(iid.getPointer());
        final PointerByReference ppCp = new PointerByReference();
        WinNT.HRESULT hr = this.factory.getComThread().execute(new Callable<WinNT.HRESULT>(){

            @Override
            public WinNT.HRESULT call() throws Exception {
                return rawCpc.FindConnectionPoint(adviseRiid, ppCp);
            }
        });
        COMUtils.checkRC(hr);
        ConnectionPoint rawCp = new ConnectionPoint(ppCp.getValue());
        return rawCp;
    }

    public IComEventCallbackCookie advise(Class<?> comEventCallbackInterface, IComEventCallbackListener comEventCallbackListener) {
        try {
            ComInterface comInterfaceAnnotation = comEventCallbackInterface.getAnnotation(ComInterface.class);
            if (null == comInterfaceAnnotation) {
                throw new COMException("advise: Interface must define a value for either iid via the ComInterface annotation");
            }
            Guid.IID iid = this.getIID(comInterfaceAnnotation);
            final ConnectionPoint rawCp = this.fetchRawConnectionPoint(iid);
            final CallbackProxy rawListener = new CallbackProxy(this.factory, comEventCallbackInterface, comEventCallbackListener);
            comEventCallbackListener.setDispatchCallbackListener(rawListener);
            final WinDef.DWORDByReference pdwCookie = new WinDef.DWORDByReference();
            WinNT.HRESULT hr = this.factory.getComThread().execute(new Callable<WinNT.HRESULT>(){

                @Override
                public WinNT.HRESULT call() throws Exception {
                    return rawCp.Advise(rawListener, pdwCookie);
                }
            });
            int n = rawCp.Release();
            COMUtils.checkRC(hr);
            return new ComEventCallbackCookie(pdwCookie.getValue());
        }
        catch (Exception e) {
            throw new COMException("Error occured in advise when trying to connect the listener " + comEventCallbackListener, e);
        }
    }

    public void unadvise(Class<?> comEventCallbackInterface, final IComEventCallbackCookie cookie) {
        try {
            ComInterface comInterfaceAnnotation = comEventCallbackInterface.getAnnotation(ComInterface.class);
            if (null == comInterfaceAnnotation) {
                throw new COMException("unadvise: Interface must define a value for iid via the ComInterface annotation");
            }
            Guid.IID iid = this.getIID(comInterfaceAnnotation);
            final ConnectionPoint rawCp = this.fetchRawConnectionPoint(iid);
            WinNT.HRESULT hr = this.factory.getComThread().execute(new Callable<WinNT.HRESULT>(){

                @Override
                public WinNT.HRESULT call() throws Exception {
                    return rawCp.Unadvise(((ComEventCallbackCookie)cookie).getValue());
                }
            });
            rawCp.Release();
            COMUtils.checkRC(hr);
        }
        catch (Exception e) {
            throw new COMException("Error occured in unadvise when trying to disconnect the listener from " + this, e);
        }
    }

    @Override
    public <T> void setProperty(String name, T value) {
        Variant.VARIANT v = Convert.toVariant(value);
        WinNT.HRESULT hr = this.oleMethod(4, null, this.getRawDispatch(), name, v);
        COMUtils.checkRC(hr);
    }

    @Override
    public <T> T getProperty(Class<T> returnType, String name, Object ... args) {
        Variant.VARIANT[] vargs = null == args ? new Variant.VARIANT[]{} : new Variant.VARIANT[args.length];
        for (int i = 0; i < vargs.length; ++i) {
            vargs[i] = Convert.toVariant(args[i]);
        }
        Variant.VARIANT.ByReference result2 = new Variant.VARIANT.ByReference();
        WinNT.HRESULT hr = this.oleMethod(2, result2, this.getRawDispatch(), name, vargs);
        COMUtils.checkRC(hr);
        Object jobj = Convert.toJavaObject(result2);
        if (IComEnum.class.isAssignableFrom(returnType)) {
            return Convert.toComEnum(returnType, jobj);
        }
        if (jobj instanceof IDispatch) {
            IDispatch d = (IDispatch)jobj;
            T t = this.factory.createProxy(returnType, d);
            int n = d.Release();
            return t;
        }
        return (T)jobj;
    }

    @Override
    public <T> T invokeMethod(Class<T> returnType, String name, Object ... args) {
        Variant.VARIANT[] vargs = null == args ? new Variant.VARIANT[]{} : new Variant.VARIANT[args.length];
        for (int i = 0; i < vargs.length; ++i) {
            vargs[i] = Convert.toVariant(args[i]);
        }
        Variant.VARIANT.ByReference result2 = new Variant.VARIANT.ByReference();
        WinNT.HRESULT hr = this.oleMethod(1, result2, this.getRawDispatch(), name, vargs);
        COMUtils.checkRC(hr);
        Object jobj = Convert.toJavaObject(result2);
        if (IComEnum.class.isAssignableFrom(returnType)) {
            return Convert.toComEnum(returnType, jobj);
        }
        if (jobj instanceof IDispatch) {
            IDispatch d = (IDispatch)jobj;
            T t = this.factory.createProxy(returnType, d);
            int n = d.Release();
            return t;
        }
        return (T)jobj;
    }

    @Override
    public <T> T queryInterface(Class<T> comInterface) throws COMException {
        try {
            PointerByReference ppvObject;
            ComInterface comInterfaceAnnotation = comInterface.getAnnotation(ComInterface.class);
            if (null == comInterfaceAnnotation) {
                throw new COMException("queryInterface: Interface must define a value for iid via the ComInterface annotation");
            }
            final Guid.IID iid = this.getIID(comInterfaceAnnotation);
            WinNT.HRESULT hr = this.comThread.execute(new Callable<WinNT.HRESULT>(ppvObject = new PointerByReference()){
                final /* synthetic */ PointerByReference val$ppvObject;
                {
                    this.val$ppvObject = pointerByReference;
                }

                @Override
                public WinNT.HRESULT call() throws Exception {
                    return ProxyObject.this.getRawDispatch().QueryInterface(new Guid.GUID.ByValue(iid), this.val$ppvObject);
                }
            });
            if (WinNT.S_OK.equals(hr)) {
                Dispatch dispatch = new Dispatch(ppvObject.getValue());
                T t = this.factory.createProxy(comInterface, dispatch);
                int n = dispatch.Release();
                return t;
            }
            String formatMessageFromHR = Kernel32Util.formatMessage(hr);
            throw new COMException("queryInterface: " + formatMessageFromHR);
        }
        catch (Exception e) {
            throw new COMException("Error occured when trying to query for interface " + comInterface.getName(), e);
        }
    }

    Guid.IID getIID(ComInterface annotation2) {
        String iidStr = annotation2.iid();
        if (null != iidStr && !iidStr.isEmpty()) {
            return new Guid.IID(iidStr);
        }
        throw new COMException("ComInterface must define a value for iid");
    }

    private String getAccessorName(Method method, ComProperty prop) {
        if (prop.name().isEmpty()) {
            String methName = method.getName();
            if (methName.startsWith("get")) {
                return methName.replaceFirst("get", "");
            }
            throw new RuntimeException("Property Accessor name must start with 'get', or set the anotation 'name' value");
        }
        return prop.name();
    }

    private String getMutatorName(Method method, ComProperty prop) {
        if (prop.name().isEmpty()) {
            String methName = method.getName();
            if (methName.startsWith("set")) {
                return methName.replaceFirst("set", "");
            }
            throw new RuntimeException("Property Mutator name must start with 'set', or set the anotation 'name' value");
        }
        return prop.name();
    }

    private String getMethodName(Method method, ComMethod meth) {
        if (meth.name().isEmpty()) {
            String methName = method.getName();
            return methName;
        }
        return meth.name();
    }

    protected WinNT.HRESULT oleMethod(int nType, Variant.VARIANT.ByReference pvResult, IDispatch pDisp, String name, Variant.VARIANT pArg) throws COMException {
        return this.oleMethod(nType, pvResult, pDisp, name, new Variant.VARIANT[]{pArg});
    }

    protected WinNT.HRESULT oleMethod(int nType, Variant.VARIANT.ByReference pvResult, IDispatch pDisp, OaIdl.DISPID dispId, Variant.VARIANT pArg) throws COMException {
        return this.oleMethod(nType, pvResult, pDisp, dispId, new Variant.VARIANT[]{pArg});
    }

    protected WinNT.HRESULT oleMethod(int nType, Variant.VARIANT.ByReference pvResult, IDispatch pDisp, String name) throws COMException {
        return this.oleMethod(nType, pvResult, pDisp, name, (Variant.VARIANT[])null);
    }

    protected WinNT.HRESULT oleMethod(int nType, Variant.VARIANT.ByReference pvResult, IDispatch pDisp, OaIdl.DISPID dispId) throws COMException {
        return this.oleMethod(nType, pvResult, pDisp, dispId, (Variant.VARIANT[])null);
    }

    protected WinNT.HRESULT oleMethod(int nType, Variant.VARIANT.ByReference pvResult, final IDispatch pDisp, String name, Variant.VARIANT[] pArgs) throws COMException {
        try {
            if (pDisp == null) {
                throw new COMException("pDisp (IDispatch) parameter is null!");
            }
            final WString[] ptName = new WString[]{new WString(name)};
            final OaIdl.DISPIDByReference pdispID = new OaIdl.DISPIDByReference();
            WinNT.HRESULT hr = this.comThread.execute(new Callable<WinNT.HRESULT>(){

                @Override
                public WinNT.HRESULT call() throws Exception {
                    WinNT.HRESULT hr = pDisp.GetIDsOfNames(new Guid.GUID.ByValue(Guid.IID_NULL), ptName, 1, LOCALE_USER_DEFAULT, pdispID);
                    return hr;
                }
            });
            COMUtils.checkRC(hr);
            return this.oleMethod(nType, pvResult, pDisp, pdispID.getValue(), pArgs);
        }
        catch (InterruptedException e) {
            throw new COMException(e);
        }
        catch (ExecutionException e) {
            throw new COMException(e);
        }
        catch (TimeoutException e) {
            throw new COMException(e);
        }
    }

    protected WinNT.HRESULT oleMethod(final int nType, final Variant.VARIANT.ByReference pvResult, final IDispatch pDisp, final OaIdl.DISPID dispId, Variant.VARIANT[] pArgs) throws COMException {
        if (pDisp == null) {
            throw new COMException("pDisp (IDispatch) parameter is null!");
        }
        int _argsLen = 0;
        Variant.VARIANT[] _args = null;
        final OleAuto.DISPPARAMS.ByReference dp = new OleAuto.DISPPARAMS.ByReference();
        final OaIdl.EXCEPINFO.ByReference pExcepInfo = new OaIdl.EXCEPINFO.ByReference();
        final IntByReference puArgErr = new IntByReference();
        if (pArgs != null && pArgs.length > 0) {
            _argsLen = pArgs.length;
            _args = new Variant.VARIANT[_argsLen];
            int revCount = _argsLen;
            for (int i = 0; i < _argsLen; ++i) {
                _args[i] = pArgs[--revCount];
            }
        }
        if (nType == 4) {
            dp.cNamedArgs = new WinDef.UINT((long)_argsLen);
            dp.rgdispidNamedArgs = new OaIdl.DISPIDByReference(OaIdl.DISPID_PROPERTYPUT);
        }
        if (_argsLen > 0) {
            dp.cArgs = new WinDef.UINT((long)_args.length);
            dp.rgvarg = new Variant.VariantArg.ByReference(_args);
            dp.write();
        }
        try {
            WinNT.HRESULT hr = this.comThread.execute(new Callable<WinNT.HRESULT>(){

                @Override
                public WinNT.HRESULT call() throws Exception {
                    return pDisp.Invoke(dispId, new Guid.GUID.ByValue(Guid.IID_NULL), LOCALE_SYSTEM_DEFAULT, new WinDef.WORD((long)nType), dp, pvResult, pExcepInfo, puArgErr);
                }
            });
            COMUtils.checkRC(hr, pExcepInfo, puArgErr);
            return hr;
        }
        catch (InterruptedException e) {
            throw new COMException(e);
        }
        catch (ExecutionException e) {
            throw new COMException(e);
        }
        catch (TimeoutException e) {
            throw new COMException(e);
        }
    }
}

