/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContext;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;

public class JsPropertyInitializer
extends SourceInfoAwareJsNode {
    @NotNull
    private JsExpression labelExpr;
    @NotNull
    private JsExpression valueExpr;

    public JsPropertyInitializer(@NotNull JsExpression labelExpr, @NotNull JsExpression valueExpr) {
        this.labelExpr = labelExpr;
        this.valueExpr = valueExpr;
    }

    @NotNull
    public JsExpression getLabelExpr() {
        return this.labelExpr;
    }

    @NotNull
    public JsExpression getValueExpr() {
        return this.valueExpr;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitPropertyInitializer(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        visitor2.accept(this.labelExpr);
        visitor2.accept(this.valueExpr);
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            JsExpression newLabel = v.accept(this.labelExpr);
            JsExpression newValue = v.accept(this.valueExpr);
            assert (newLabel != null) : "Label cannot be replaced with null";
            assert (newValue != null) : "Value cannot be replaced with null";
            this.labelExpr = newLabel;
            this.valueExpr = newValue;
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsPropertyInitializer deepCopy() {
        return new JsPropertyInitializer(this.labelExpr.deepCopy(), this.valueExpr.deepCopy()).withMetadataFrom(this);
    }
}

