/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.callTranslator;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.translate.callTranslator.CallInfoKt;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslatorKt$WhenMappings;
import org.jetbrains.kotlin.js.translate.callTranslator.ExplicitReceivers;
import org.jetbrains.kotlin.js.translate.callTranslator.FunctionCallCasesKt;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.reference.CallExpressionTranslator;
import org.jetbrains.kotlin.js.translate.utils.InlineUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u00008\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u0005\u001a(\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00022\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u0005H\u0002\u001a8\u0010\r\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00022\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\b2\u0006\u0010\n\u001a\u00020\u0005H\u0002\u001a\u0014\u0010\u0010\u001a\u00020\u0001*\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\bH\u0002\u001a\u0012\u0010\u0011\u001a\u00020\u0012*\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\b\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\u00a8\u0006\u0013"}, d2={"isInStateMachine", "", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)Z", "computeExplicitReceiversForInvoke", "Lorg/jetbrains/kotlin/js/translate/callTranslator/ExplicitReceivers;", "context", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "explicitReceivers", "translateCall", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "translateFunctionCall", "inlineResolvedCall", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "expectedReceivers", "getReturnType", "Lorg/jetbrains/kotlin/types/KotlinType;", "js.translator"})
public final class CallTranslatorKt {
    private static final boolean expectedReceivers(@NotNull ResolvedCall<? extends CallableDescriptor> $receiver) {
        return Intrinsics.areEqual((Object)$receiver.getExplicitReceiverKind(), (Object)ExplicitReceiverKind.NO_EXPLICIT_RECEIVER) ^ true;
    }

    private static final JsExpression translateCall(TranslationContext context, ResolvedCall<? extends FunctionDescriptor> resolvedCall2, ExplicitReceivers explicitReceivers) {
        Call call2;
        if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
            JsExpression jsExpression;
            boolean bl;
            boolean bl2 = bl = explicitReceivers.getExtensionReceiver() == null;
            if (_Assertions.ENABLED && !bl) {
                String string = "VariableAsFunctionResolvedCall must have one receiver";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            ResolvedCall<VariableDescriptor> variableCall = ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall();
            if (CallTranslatorKt.expectedReceivers(variableCall)) {
                JsExpression newReceiver = CallTranslator.INSTANCE.translateGet(context, variableCall, explicitReceivers.getExtensionOrDispatchReceiver());
                jsExpression = CallTranslatorKt.translateFunctionCall(context, ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getFunctionCall(), ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall(), new ExplicitReceivers(newReceiver, null, 2, null));
            } else {
                JsExpression dispatchReceiver = CallTranslator.INSTANCE.translateGet(context, variableCall, null);
                VariableDescriptor variableDescriptor = ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall().getResultingDescriptor();
                Intrinsics.checkExpressionValueIsNotNull(variableDescriptor, "resolvedCall.variableCall.resultingDescriptor");
                KotlinType kotlinType = variableDescriptor.getType();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "resolvedCall.variableCall.resultingDescriptor.type");
                boolean isFunctionType = FunctionTypesKt.isFunctionTypeOrSubtype(kotlinType);
                ResolvedCall<? extends FunctionDescriptor> inlineCall2 = isFunctionType ? ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall() : resolvedCall2;
                jsExpression = explicitReceivers.getExtensionOrDispatchReceiver() == null ? CallTranslatorKt.translateFunctionCall(context, ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getFunctionCall(), inlineCall2, new ExplicitReceivers(dispatchReceiver, null, 2, null)) : CallTranslatorKt.translateFunctionCall(context, ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getFunctionCall(), inlineCall2, new ExplicitReceivers(dispatchReceiver, explicitReceivers.getExtensionOrDispatchReceiver()));
            }
            JsExpression result2 = jsExpression;
            return result2;
        }
        Call call3 = call2 = resolvedCall2.getCall();
        Intrinsics.checkExpressionValueIsNotNull(call3, "call");
        if (Intrinsics.areEqual((Object)call3.getCallType(), (Object)Call.CallType.INVOKE) && !CallResolverUtilKt.isInvokeCallOnVariable(call2)) {
            ExplicitReceivers explicitReceiversForInvoke = CallTranslatorKt.computeExplicitReceiversForInvoke(context, resolvedCall2, explicitReceivers);
            return CallTranslatorKt.translateFunctionCall(context, resolvedCall2, resolvedCall2, explicitReceiversForInvoke);
        }
        return CallTranslatorKt.translateFunctionCall(context, resolvedCall2, resolvedCall2, explicitReceivers);
    }

    /*
     * WARNING - void declaration
     */
    private static final JsExpression translateFunctionCall(TranslationContext context, ResolvedCall<? extends FunctionDescriptor> resolvedCall2, ResolvedCall<? extends CallableDescriptor> inlineResolvedCall, ExplicitReceivers explicitReceivers) {
        void it;
        KotlinType kotlinType;
        JsExpression callExpression = FunctionCallCasesKt.translateFunctionCall(CallInfoKt.getCallInfo(context, resolvedCall2, explicitReceivers));
        if (CallExpressionTranslator.shouldBeInlined(inlineResolvedCall.getResultingDescriptor(), context)) {
            Call call2 = resolvedCall2.getCall();
            Intrinsics.checkExpressionValueIsNotNull(call2, "resolvedCall.call");
            KtElement ktElement = call2.getCallElement();
            if (ktElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            InlineUtils.setInlineCallMetadata(callExpression, (KtExpression)ktElement, inlineResolvedCall.getResultingDescriptor(), context);
        }
        if (resolvedCall2.getResultingDescriptor().isSuspend()) {
            if (CallTranslatorKt.isInStateMachine(context)) {
                JsNode jsNode;
                JsBlock jsBlock = context.getCurrentBlock();
                Intrinsics.checkExpressionValueIsNotNull(jsBlock, "context.currentBlock");
                Collection collection = jsBlock.getStatements();
                JsExpression $receiver = jsNode = callExpression;
                MetadataProperties.setSuspend($receiver, true);
                Call call3 = resolvedCall2.getCall();
                Intrinsics.checkExpressionValueIsNotNull(call3, "resolvedCall.call");
                $receiver.setSource(call3.getCallElement());
                jsNode = JsAstUtils.asSyntheticStatement(jsNode);
                collection.add(jsNode);
                $receiver = jsNode = TranslationUtils.translateContinuationArgument(context);
                Call call4 = resolvedCall2.getCall();
                Intrinsics.checkExpressionValueIsNotNull(call4, "resolvedCall.call");
                $receiver.setSource(call4.getCallElement());
                JsNode coroutineRef = jsNode;
                $receiver = jsNode = new JsNameRef("$$coroutineResult$$", (JsExpression)coroutineRef);
                TranslationContext translationContext = context;
                MetadataProperties.setSideEffects($receiver, SideEffectKind.DEPENDS_ON_STATE);
                Call call5 = resolvedCall2.getCall();
                Intrinsics.checkExpressionValueIsNotNull(call5, "resolvedCall.call");
                $receiver.setSource(call5.getCallElement());
                MetadataProperties.setCoroutineResult((JsNameRef)$receiver, true);
                Unit unit = Unit.INSTANCE;
                JsExpression jsExpression = translationContext.defineTemporary((JsExpression)jsNode);
                Intrinsics.checkExpressionValueIsNotNull(jsExpression, "context.defineTemporary(\u2026ult = true\n            })");
                return jsExpression;
            }
            MetadataProperties.setTailCallSuspend(callExpression, true);
        }
        KotlinType kotlinType2 = kotlinType = CallTranslatorKt.getReturnType(resolvedCall2);
        JsExpression jsExpression = callExpression;
        Call call6 = resolvedCall2.getCall();
        Intrinsics.checkExpressionValueIsNotNull(call6, "resolvedCall.call");
        KotlinType kotlinType3 = CallUtilKt.isSafeCall(call6) ? TypeUtilsKt.makeNullable((KotlinType)it) : it;
        MetadataProperties.setType(jsExpression, kotlinType3);
        return callExpression;
    }

    @NotNull
    public static final KotlinType getReturnType(@NotNull ResolvedCall<? extends CallableDescriptor> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        KotlinType kotlinType = TranslationUtils.getReturnTypeForCoercion($receiver.getResultingDescriptor());
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "TranslationUtils.getRetu\u2026cion(resultingDescriptor)");
        return kotlinType;
    }

    private static final boolean isInStateMachine(@NotNull TranslationContext $receiver) {
        DeclarationDescriptor declarationDescriptor = $receiver.getDeclarationDescriptor();
        if (!(declarationDescriptor instanceof FunctionDescriptor)) {
            declarationDescriptor = null;
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)declarationDescriptor;
        return functionDescriptor != null && UtilsKt.requiresStateMachineTransformation(functionDescriptor, $receiver);
    }

    @NotNull
    public static final ExplicitReceivers computeExplicitReceiversForInvoke(@NotNull TranslationContext context, @NotNull ResolvedCall<? extends FunctionDescriptor> resolvedCall2, @NotNull ExplicitReceivers explicitReceivers) {
        ExplicitReceivers explicitReceivers2;
        boolean bl;
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(explicitReceivers, "explicitReceivers");
        Call call2 = resolvedCall2.getCall();
        Intrinsics.checkExpressionValueIsNotNull(call2, "resolvedCall.call");
        KtElement callElement = call2.getCallElement();
        boolean bl2 = bl = explicitReceivers.getExtensionReceiver() == null;
        if (_Assertions.ENABLED && !bl) {
            String string = "'Invoke' call must have one receiver: " + callElement;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Function1<ReceiverValue, JsExpression> translateReceiverAsExpression$ = new Function1<ReceiverValue, JsExpression>(context){
            final /* synthetic */ TranslationContext $context;

            @Nullable
            public final JsExpression invoke(@Nullable ReceiverValue receiver) {
                JsExpression jsExpression;
                ReceiverValue receiverValue = receiver;
                if (!(receiverValue instanceof ExpressionReceiver)) {
                    receiverValue = null;
                }
                ExpressionReceiver expressionReceiver = (ExpressionReceiver)receiverValue;
                if (expressionReceiver != null) {
                    ExpressionReceiver expressionReceiver2;
                    ExpressionReceiver it = expressionReceiver2 = expressionReceiver;
                    jsExpression = Translation.translateAsExpression(it.getExpression(), this.$context);
                } else {
                    jsExpression = null;
                }
                return jsExpression;
            }
            {
                this.$context = translationContext;
                super(1);
            }
        };
        ReceiverValue dispatchReceiver = resolvedCall2.getDispatchReceiver();
        ReceiverValue extensionReceiver = resolvedCall2.getExtensionReceiver();
        if (dispatchReceiver != null && extensionReceiver != null && Intrinsics.areEqual((Object)resolvedCall2.getExplicitReceiverKind(), (Object)ExplicitReceiverKind.BOTH_RECEIVERS)) {
            boolean bl3;
            boolean bl4 = bl3 = explicitReceivers.getExtensionOrDispatchReceiver() != null;
            if (_Assertions.ENABLED && !bl3) {
                StringBuilder stringBuilder = new StringBuilder().append("No explicit receiver for 'invoke' resolved call with both receivers: ").append(callElement).append(", text: ");
                KtElement ktElement = callElement;
                Intrinsics.checkExpressionValueIsNotNull(ktElement, "callElement");
                String string = stringBuilder.append(ktElement.getText()).append("Dispatch receiver: ").append(dispatchReceiver).append(" Extension receiver: ").append(extensionReceiver).toString();
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
        } else {
            boolean bl5;
            boolean bl6 = bl5 = explicitReceivers.getExtensionOrDispatchReceiver() == null;
            if (_Assertions.ENABLED && !bl5) {
                StringBuilder stringBuilder = new StringBuilder().append("Non trivial explicit receiver ").append(explicitReceivers.getExtensionOrDispatchReceiver()).append('\n').append("for 'invoke' resolved call: ").append(callElement).append(", text: ");
                KtElement ktElement = callElement;
                Intrinsics.checkExpressionValueIsNotNull(ktElement, "callElement");
                String string = stringBuilder.append(ktElement.getText()).append('\n').append("Dispatch receiver: ").append(dispatchReceiver).append(" Extension receiver: ").append(extensionReceiver).toString();
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
        }
        switch (CallTranslatorKt$WhenMappings.$EnumSwitchMapping$0[resolvedCall2.getExplicitReceiverKind().ordinal()]) {
            case 1: {
                explicitReceivers2 = new ExplicitReceivers(null, null, 2, null);
                break;
            }
            case 2: {
                explicitReceivers2 = new ExplicitReceivers(translateReceiverAsExpression$.invoke(dispatchReceiver), null, 2, null);
                break;
            }
            case 3: {
                explicitReceivers2 = new ExplicitReceivers(translateReceiverAsExpression$.invoke(extensionReceiver), null, 2, null);
                break;
            }
            case 4: {
                explicitReceivers2 = new ExplicitReceivers(translateReceiverAsExpression$.invoke(dispatchReceiver), translateReceiverAsExpression$.invoke(extensionReceiver));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return explicitReceivers2;
    }

    @NotNull
    public static final /* synthetic */ JsExpression access$translateCall(@NotNull TranslationContext context, @NotNull ResolvedCall resolvedCall2, @NotNull ExplicitReceivers explicitReceivers) {
        return CallTranslatorKt.translateCall(context, resolvedCall2, explicitReceivers);
    }
}

