/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.collections;

import edu.berkeley.nlp.lm.collections.TIntMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Semaphore;

public class Indexer<E extends Comparable<E>>
implements Serializable {
    private static final long serialVersionUID = -8769544079136550516L;
    protected ArrayList<E> objects = new ArrayList();
    protected TIntMap<E> indexes = new TIntMap();
    protected boolean locked = false;
    private Semaphore sem;

    public void lock() {
        this.locked = true;
    }

    public E getObject(int index) {
        return (E)((Comparable)this.objects.get(index));
    }

    public boolean add(E elem) {
        int oldSize = this.size();
        return this.getIndex(elem) >= oldSize;
    }

    public int size() {
        return this.objects.size();
    }

    public int indexOf(E o) {
        int index = this.indexes.get(o, -1);
        return index;
    }

    public int getIndex(E e) {
        int index;
        if (e == null) {
            return -1;
        }
        if (this.sem != null) {
            this.sem.acquireUninterruptibly();
        }
        if ((index = this.indexes.get(e, -1)) < 0) {
            if (this.locked) {
                throw new RuntimeException("Attempt to add to locked indexer");
            }
            index = this.size();
            this.objects.add(e);
            assert (this.size() >= 0) : "Too many objects in indexer";
            this.indexes.put(e, index);
        }
        if (this.sem != null) {
            this.sem.release();
        }
        return index;
    }

    public Indexer(boolean sync) {
        this.sem = sync ? new Semaphore(1) : null;
    }

    public Indexer() {
        this(false);
    }

    public Indexer(Collection<? extends E> c) {
        this();
        for (Comparable a : c) {
            this.getIndex(a);
        }
    }

    public void trim() {
        this.objects.trimToSize();
    }

    public Iterable<E> getObjects() {
        return Collections.unmodifiableList(this.objects);
    }
}

