/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.da.comp.writer2xhtml;

import com.sun.star.awt.XDialog;
import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.XComponent;
import com.sun.star.ui.dialogs.XExecutableDialog;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.awt.GraphicsEnvironment;
import org.openoffice.da.comp.w2lcommon.filter.OptionsDialogBase;
import org.openoffice.da.comp.w2lcommon.helper.PropertyHelper;
import org.openoffice.da.comp.writer2xhtml.W2XRegistration;

public class EpubOptionsDialog
extends OptionsDialogBase {
    public static String __serviceName = "org.openoffice.da.writer2xhtml.EpubOptionsDialog";
    public static String __implementationName = "org.openoffice.da.comp.writer2xhtml.EpubOptionsDialog";

    @Override
    public String getDialogLibraryName() {
        return "W2XDialogs2";
    }

    @Override
    public String getDialogName() {
        return "EpubOptions";
    }

    @Override
    public String getRegistryPath() {
        return "/org.openoffice.da.Writer2xhtml.Options/EpubOptions";
    }

    public EpubOptionsDialog(XComponentContext xContext) {
        super(xContext);
        this.xMSF = W2XRegistration.xMultiServiceFactory;
    }

    @Override
    protected void loadSettings(XPropertySet xProps) {
        int nColumnScaling;
        this.loadConfig(xProps);
        int nScaling = this.loadNumericOption(xProps, "Scaling");
        if (nScaling <= 1) {
            this.setNumericFieldValue("Scaling", 100);
        }
        if ((nColumnScaling = this.loadNumericOption(xProps, "ColumnScaling")) <= 1) {
            this.setNumericFieldValue("ColumnScaling", 100);
        }
        this.loadCheckBoxOption(xProps, "RelativeFontSize");
        this.loadNumericOption(xProps, "FontScaling");
        int nFontScaling = this.loadNumericOption(xProps, "FontScaling");
        if (nFontScaling <= 1) {
            this.setNumericFieldValue("FontScaling", 100);
        }
        this.loadCheckBoxOption(xProps, "RelativeFontSize");
        this.loadCheckBoxOption(xProps, "UseDefaultFont");
        this.loadComboBoxOption(xProps, "DefaultFontName");
        this.loadCheckBoxOption(xProps, "ConvertToPx");
        this.loadListBoxOption(xProps, "ImageSize");
        this.setListBoxStringItemList("DefaultFontName", GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        this.loadCheckBoxOption(xProps, "IgnoreHardLineBreaks");
        this.loadCheckBoxOption(xProps, "IgnoreEmptyParagraphs");
        this.loadCheckBoxOption(xProps, "IgnoreDoubleSpaces");
        this.loadCheckBoxOption(xProps, "DisplayHiddenText");
        this.loadCheckBoxOption(xProps, "Notes");
        this.loadListBoxOption(xProps, "SplitLevel");
        this.loadListBoxOption(xProps, "PageBreakSplit");
        this.loadCheckBoxOption(xProps, "UseImageSplit");
        this.loadNumericOption(xProps, "ImageSplit");
        this.loadCheckBoxOption(xProps, "CoverImage");
        this.loadCheckBoxOption(xProps, "UseSplitAfter");
        this.loadNumericOption(xProps, "SplitAfter");
        this.loadListBoxOption(xProps, "ExternalTocDepth");
        this.loadCheckBoxOption(xProps, "IncludeToc");
        this.updateLockedOptions();
        this.enableControls();
    }

    @Override
    protected void saveSettings(XPropertySet xProps, PropertyHelper helper) {
        short nConfig = this.saveConfig(xProps, helper);
        switch (nConfig) {
            case 0: {
                helper.put("ConfigURL", "*default.xml");
                break;
            }
            case 1: {
                helper.put("ConfigURL", "$(user)/writer2xhtml.xml");
                helper.put("AutoCreate", "true");
                helper.put("TemplateURL", "$(user)/writer2xhtml-template.xhtml");
                helper.put("StyleSheetURL", "$(user)/writer2xhtml-styles.css");
                helper.put("ResourceURL", "$(user)/writer2xhtml-resources");
            }
        }
        this.saveNumericOptionAsPercentage(xProps, helper, "Scaling", "scaling");
        this.saveNumericOptionAsPercentage(xProps, helper, "ColumnScaling", "column_scaling");
        this.saveCheckBoxOption(xProps, helper, "RelativeFontSize", "relative_font_size");
        this.saveNumericOptionAsPercentage(xProps, helper, "FontScaling", "font_scaling");
        this.saveCheckBoxOption(xProps, helper, "UseDefaultFont", "use_default_font");
        this.saveTextFieldOption(xProps, helper, "DefaultFontName", "default_font_name");
        this.saveCheckBoxOption(xProps, helper, "ConvertToPx", "convert_to_px");
        this.saveListBoxOption(xProps, "ImageSize");
        switch (this.getListBoxSelectedItem("ImageSize")) {
            case 0: {
                helper.put("image_size", "absolute");
                break;
            }
            case 1: {
                helper.put("image_size", "relative");
                break;
            }
            case 2: {
                helper.put("image_size", "none");
            }
        }
        this.saveCheckBoxOption(xProps, helper, "IgnoreHardLineBreaks", "ignore_hard_line_breaks");
        this.saveCheckBoxOption(xProps, helper, "IgnoreEmptyParagraphs", "ignore_empty_paragraphs");
        this.saveCheckBoxOption(xProps, helper, "IgnoreDoubleSpaces", "ignore_double_spaces");
        this.saveCheckBoxOption(xProps, helper, "DisplayHiddenText", "display_hidden_text");
        this.saveCheckBoxOption(xProps, helper, "Notes", "notes");
        short nSplitLevel = this.saveListBoxOption(xProps, "SplitLevel");
        if (!this.isLocked("split_level")) {
            helper.put("split_level", Integer.toString(nSplitLevel));
        }
        short nPageBreakSplit = this.saveListBoxOption(xProps, "PageBreakSplit");
        if (!this.isLocked("page_break_split")) {
            switch (nPageBreakSplit) {
                case 0: {
                    helper.put("page_break_split", "none");
                    break;
                }
                case 1: {
                    helper.put("page_break_split", "styles");
                    break;
                }
                case 2: {
                    helper.put("page_break_split", "explicit");
                    break;
                }
                case 3: {
                    helper.put("page_break_split", "all");
                }
            }
        }
        boolean bUseImageSplit = this.saveCheckBoxOption(xProps, "UseImageSplit");
        int nImageSplit = this.saveNumericOption(xProps, "ImageSplit");
        if (!this.isLocked("image_split")) {
            if (bUseImageSplit) {
                helper.put("image_split", nImageSplit + "%");
            } else {
                helper.put("image_split", "none");
            }
        }
        this.saveCheckBoxOption(xProps, helper, "CoverImage", "cover_image");
        boolean bUseSplitAfter = this.saveCheckBoxOption(xProps, "UseSplitAfter");
        int nSplitAfter = this.saveNumericOption(xProps, "SplitAfter");
        if (!this.isLocked("split_after")) {
            if (bUseSplitAfter) {
                helper.put("split_after", Integer.toString(nSplitAfter));
            } else {
                helper.put("split_after", "0");
            }
        }
        short nExternalTocDepth = this.saveListBoxOption(xProps, "ExternalTocDepth");
        helper.put("external_toc_depth", Integer.toString(nExternalTocDepth + 1));
        this.saveCheckBoxOption(xProps, helper, "IncludeToc", "include_toc");
    }

    @Override
    public boolean callHandlerMethod(XDialog xDialog, Object event, String sMethod) {
        if (sMethod.equals("ConfigChange")) {
            this.updateLockedOptions();
            this.enableControls();
        } else if (sMethod.equals("RelativeFontSizeChange")) {
            this.relativeFontSizeChange();
        } else if (sMethod.equals("UseDefaultFontChange")) {
            this.useDefaultFontChange();
        } else if (sMethod.equals("EditMetadataClick")) {
            this.editMetadataClick();
        } else if (sMethod.equals("UseImageSplitChange")) {
            this.useImageSplitChange();
        } else if (sMethod.equals("UseSplitAfterChange")) {
            this.useSplitAfterChange();
        }
        return true;
    }

    @Override
    public String[] getSupportedMethodNames() {
        String[] sNames = new String[]{"ConfigChange", "RelativeFontSizeChange", "UseDefaultFontChange", "EditMetadataClick", "UseImageSplitChange", "UseSplitAfterChange"};
        return sNames;
    }

    private void enableControls() {
        this.setControlEnabled("ScalingLabel", !this.isLocked("scaling"));
        this.setControlEnabled("Scaling", !this.isLocked("scaling"));
        this.setControlEnabled("ColumnScalingLabel", !this.isLocked("column_scaling"));
        this.setControlEnabled("ColumnScaling", !this.isLocked("column_scaling"));
        boolean bRelativeFontSize = this.getCheckBoxStateAsBoolean("RelativeFontSize");
        this.setControlEnabled("RelativeFontSize", !this.isLocked("relative_font_size"));
        this.setControlEnabled("FontScalingLabel", !this.isLocked("font_scaling") && bRelativeFontSize);
        this.setControlEnabled("FontScaling", !this.isLocked("font_scaling") && bRelativeFontSize);
        this.setControlEnabled("FontScalingPercentLabel", !this.isLocked("font_scaling") && bRelativeFontSize);
        boolean bUseDefaultFont = this.getCheckBoxStateAsBoolean("UseDefaultFont");
        this.setControlEnabled("UseDefaultFont", !this.isLocked("use_default_font"));
        this.setControlEnabled("DefaultFontNameLabel", !this.isLocked("default_font_name") && bUseDefaultFont);
        this.setControlEnabled("DefaultFontName", !this.isLocked("default_font_name") && bUseDefaultFont);
        this.setControlEnabled("ConvertToPx", !this.isLocked("convert_to_px"));
        this.setControlEnabled("ImageSize", !this.isLocked("image_size"));
        this.setControlEnabled("IgnoreHardLineBreaks", !this.isLocked("ignore_hard_line_breaks"));
        this.setControlEnabled("IgnoreEmptyParagraphs", !this.isLocked("ignore_empty_paragraphs"));
        this.setControlEnabled("IgnoreDoubleSpaces", !this.isLocked("ignore_double_spaces"));
        this.setControlEnabled("DisplayHiddenText", !this.isLocked("display_hidden_text"));
        this.setControlEnabled("Notes", !this.isLocked("notes"));
        this.setControlEnabled("SplitLevelLabel", !this.isLocked("split_level"));
        this.setControlEnabled("SplitLevel", !this.isLocked("split_level"));
        this.setControlEnabled("PageBreakSplitLabel", !this.isLocked("page_break_split"));
        this.setControlEnabled("PageBreakSplit", !this.isLocked("page_break_split"));
        boolean bUseImageSplit = this.getCheckBoxStateAsBoolean("UseImageSplit");
        this.setControlEnabled("UseImageSplit", !this.isLocked("image_split"));
        this.setControlEnabled("ImageSplitLabel", !this.isLocked("image_split") && bUseImageSplit);
        this.setControlEnabled("ImageSplit", !this.isLocked("image_split") && bUseImageSplit);
        this.setControlEnabled("ImageSplitPercentLabel", !this.isLocked("image_split") && bUseImageSplit);
        this.setControlEnabled("CoverImage", !this.isLocked("cover_image"));
        boolean bUseSplitAfter = this.getCheckBoxStateAsBoolean("UseSplitAfter");
        this.setControlEnabled("UseSplitAfter", !this.isLocked("split_after"));
        this.setControlEnabled("SplitAfterLabel", !this.isLocked("split_after") && bUseSplitAfter);
        this.setControlEnabled("SplitAfter", !this.isLocked("split_after") && bUseSplitAfter);
        this.setControlEnabled("ExternalTocDepthLabel", !this.isLocked("external_toc_depth"));
        this.setControlEnabled("ExternalTocDepth", !this.isLocked("external_toc_depth"));
        this.setControlEnabled("IncludeToc", !this.isLocked("include_toc"));
    }

    private void relativeFontSizeChange() {
        if (!this.isLocked("font_scaling")) {
            boolean bState = this.getCheckBoxStateAsBoolean("RelativeFontSize");
            this.setControlEnabled("FontScalingLabel", bState);
            this.setControlEnabled("FontScaling", bState);
            this.setControlEnabled("FontScalingPercentLabel", bState);
        }
    }

    private void useDefaultFontChange() {
        if (!this.isLocked("default_font_name")) {
            boolean bState = this.getCheckBoxStateAsBoolean("UseDefaultFont");
            this.setControlEnabled("DefaultFontNameLabel", bState);
            this.setControlEnabled("DefaultFontName", bState);
        }
    }

    private void editMetadataClick() {
        try {
            Object dialog = this.xContext.getServiceManager().createInstanceWithContext("org.openoffice.da.writer2xhtml.EpubMetadataDialog", this.xContext);
            XExecutableDialog xDialog = (XExecutableDialog)UnoRuntime.queryInterface(XExecutableDialog.class, (Object)dialog);
            xDialog.execute();
            XComponent xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)dialog);
            if (xComponent != null) {
                xComponent.dispose();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void useImageSplitChange() {
        if (!this.isLocked("image_split")) {
            boolean bEnable = this.getCheckBoxStateAsBoolean("UseImageSplit");
            this.setControlEnabled("ImageSplitLabel", bEnable);
            this.setControlEnabled("ImageSplit", bEnable);
            this.setControlEnabled("ImageSplitPercentLabel", bEnable);
        }
    }

    private void useSplitAfterChange() {
        if (!this.isLocked("split_after")) {
            boolean bState = this.getCheckBoxStateAsBoolean("UseSplitAfter");
            this.setControlEnabled("SplitAfterLabel", bState);
            this.setControlEnabled("SplitAfter", bState);
        }
    }
}

