/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex;

import java.util.Enumeration;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXConfig;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.ListStyleConverter;
import writer2latex.latex.StyleConverter;
import writer2latex.latex.util.BeforeAfter;
import writer2latex.latex.util.Context;
import writer2latex.office.MasterPage;
import writer2latex.office.OfficeReader;
import writer2latex.office.OfficeStyle;
import writer2latex.office.PageLayout;
import writer2latex.office.StyleWithProperties;
import writer2latex.util.CSVList;
import writer2latex.util.Misc;

public class PageStyleConverter
extends StyleConverter {
    private String sChapterField1 = null;
    private String sChapterField2 = null;
    private PageLayout mainPageLayout;

    public PageStyleConverter(OfficeReader ofr, LaTeXConfig config, ConverterPalette palette) {
        super(ofr, config, palette);
        MasterPage firstMasterPage = ofr.getFirstMasterPage();
        String sPageLayoutName = null;
        if (firstMasterPage != null) {
            MasterPage nextMasterPage = ofr.getMasterPage(firstMasterPage.getProperty("style:next-style-name"));
            sPageLayoutName = nextMasterPage != null ? nextMasterPage.getPageLayoutName() : firstMasterPage.getPageLayoutName();
        }
        this.mainPageLayout = ofr.getPageLayout(sPageLayoutName);
    }

    @Override
    public void appendDeclarations(LaTeXDocumentPortion pack, LaTeXDocumentPortion decl) {
        MasterPage firstMasterPage;
        if (this.config.useFancyhdr()) {
            pack.append("\\usepackage{fancyhdr}").nl();
        }
        if ((firstMasterPage = this.ofr.getFirstMasterPage()) != null) {
            this.styleNames.addName(this.getDisplayName(firstMasterPage.getName()));
        }
        this.convertPageMasterGeometry(pack, decl);
        this.convertMasterPages(decl);
        if (firstMasterPage != null) {
            BeforeAfter ba = new BeforeAfter();
            this.applyMasterPage(firstMasterPage.getName(), ba);
            decl.append(ba.getBefore());
        }
    }

    public void setChapterField1(String s) {
        this.sChapterField1 = s;
    }

    public void setChapterField2(String s) {
        this.sChapterField2 = s;
    }

    public boolean isTwocolumn() {
        return this.mainPageLayout != null && this.mainPageLayout.getColCount() > 1;
    }

    public void applyPageBreak(StyleWithProperties style, boolean bInherit, BeforeAfter ba) {
        String sMasterPage;
        if (style == null) {
            return;
        }
        if (style.isAutomatic() && this.config.ignoreHardPageBreaks()) {
            return;
        }
        String s = style.getProperty("fo:break-before", bInherit);
        if ("page".equals(s)) {
            ba.add("\\clearpage", "");
        }
        if ("page".equals(s = style.getProperty("fo:break-after", bInherit))) {
            ba.add("", "\\clearpage");
        }
        if ((sMasterPage = style.getMasterPageName()) == null || sMasterPage.length() == 0) {
            return;
        }
        ba.add("\\clearpage", "");
        String sPageNumber = style.getProperty("style:page-number");
        if (sPageNumber != null) {
            int nPageNumber = Misc.getPosInteger(sPageNumber, 1);
            ba.add("\\setcounter{page}{" + nPageNumber + "}", "");
        }
        this.applyMasterPage(sMasterPage, ba);
    }

    private void applyMasterPage(String sName, BeforeAfter ba) {
        if (this.config.pageFormatting() == 0 || this.config.pageFormatting() == 6) {
            return;
        }
        MasterPage style = this.ofr.getMasterPage(sName);
        if (style == null) {
            return;
        }
        String sNextName = style.getProperty("style:next-style-name");
        MasterPage nextStyle = this.ofr.getMasterPage(sNextName);
        if (style == nextStyle || nextStyle == null) {
            ba.add("\\pagestyle{" + this.styleNames.getExportName(this.getDisplayName(sName)) + "}\n", "");
        } else {
            ba.add("\\pagestyle{" + this.styleNames.getExportName(this.getDisplayName(sNextName)) + "}\n" + "\\thispagestyle{" + this.styleNames.getExportName(this.getDisplayName(sName)) + "}\n", "");
        }
    }

    private void convertMasterPages(LaTeXDocumentPortion ldp) {
        if (this.config.pageFormatting() == 0 || this.config.pageFormatting() == 6) {
            return;
        }
        Context context = new Context();
        context.resetFormattingFromStyle(this.ofr.getDefaultParStyle());
        context.setInHeaderFooter(true);
        Enumeration<OfficeStyle> styles = this.ofr.getMasterPages().getStylesEnumeration();
        ldp.append("% Pages styles").nl();
        if (!this.config.useFancyhdr()) {
            ldp.append("\\makeatletter").nl();
        }
        while (styles.hasMoreElements()) {
            MasterPage style = (MasterPage)styles.nextElement();
            String sName = style.getName();
            if (!this.styleNames.containsName(this.getDisplayName(sName))) continue;
            this.sChapterField1 = null;
            this.sChapterField2 = null;
            String sPageLayout = style.getPageLayoutName();
            PageLayout pageLayout = this.ofr.getPageLayout(sPageLayout);
            if (this.config.useFancyhdr()) {
                ldp.append("\\fancypagestyle{").append(this.styleNames.getExportName(this.getDisplayName(sName))).append("}{\\fancyhf{}").nl();
                ldp.append("  \\fancyhead[").append(this.getParAlignment(style.getHeader())).append(style.getHeaderLeft() != null ? "O" : "").append("]{");
                this.traverseHeaderFooter((Element)style.getHeader(), ldp, context);
                ldp.append("}").nl();
                if (style.getHeaderLeft() != null) {
                    ldp.append("  \\fancyhead[").append(this.getParAlignment(style.getHeaderLeft())).append("E]{");
                    this.traverseHeaderFooter((Element)style.getHeaderLeft(), ldp, context);
                    ldp.append("}").nl();
                }
                ldp.append("  \\fancyfoot[").append(this.getParAlignment(style.getFooter())).append(style.getFooterLeft() != null ? "O" : "").append("]{");
                this.traverseHeaderFooter((Element)style.getFooter(), ldp, context);
                ldp.append("}").nl();
                if (style.getFooterLeft() != null) {
                    ldp.append("  \\fancyfoot[").append(this.getParAlignment(style.getFooterLeft())).append("E]{");
                    this.traverseHeaderFooter((Element)style.getFooterLeft(), ldp, context);
                    ldp.append("}").nl();
                }
                ldp.append("  \\renewcommand\\headrulewidth{").append(this.getBorderWidth(pageLayout, true)).append("}").nl().append("  \\renewcommand\\footrulewidth{").append(this.getBorderWidth(pageLayout, false)).append("}").nl();
            } else {
                ldp.append("\\newcommand\\ps@").append(this.styleNames.getExportName(this.getDisplayName(sName))).append("{").nl();
                ldp.append("  \\renewcommand\\@oddhead{");
                this.traverseHeaderFooter((Element)style.getHeader(), ldp, context);
                ldp.append("}").nl();
                ldp.append("  \\renewcommand\\@evenhead{");
                if (style.getHeaderLeft() != null) {
                    this.traverseHeaderFooter((Element)style.getHeaderLeft(), ldp, context);
                } else if (style.getHeader() != null) {
                    ldp.append("\\@oddhead");
                }
                ldp.append("}").nl();
                ldp.append("  \\renewcommand\\@oddfoot{");
                this.traverseHeaderFooter((Element)style.getFooter(), ldp, context);
                ldp.append("}").nl();
                ldp.append("  \\renewcommand\\@evenfoot{");
                if (style.getFooterLeft() != null) {
                    this.traverseHeaderFooter((Element)style.getFooterLeft(), ldp, context);
                } else if (style.getFooter() != null) {
                    ldp.append("\\@oddfoot");
                }
                ldp.append("}").nl();
            }
            if (this.sChapterField1 != null) {
                ldp.append("  \\def\\sectionmark##1{\\markboth{");
                if ("name".equals(this.sChapterField1)) {
                    ldp.append("##1");
                } else if ("number".equals(this.sChapterField1) || "plain-number".equals(this.sChapterField1)) {
                    ldp.append("\\thesection");
                } else {
                    ldp.append("\\thesection\\ ##1");
                }
                ldp.append("}{}}").nl();
            }
            if (this.sChapterField2 != null) {
                if (this.sChapterField1 == null) {
                    ldp.append("  \\def\\sectionmark##1{\\markboth{}{}}").nl();
                }
                ldp.append("  \\def\\subsectionmark##1{\\markright{");
                if ("name".equals(this.sChapterField2)) {
                    ldp.append("##1");
                } else if ("number".equals(this.sChapterField2) || "plain-number".equals(this.sChapterField1)) {
                    ldp.append("\\thesubsection");
                } else {
                    ldp.append("\\thesubsection\\ ##1");
                }
                ldp.append("}{}}").nl();
            }
            if (pageLayout != null) {
                String sPageNumber;
                String sNumFormat = pageLayout.getProperty("style:num-format");
                if (sNumFormat != null) {
                    ldp.append("  \\renewcommand\\thepage{").append(ListStyleConverter.numFormat(sNumFormat)).append("{page}}").nl();
                }
                if ((sPageNumber = pageLayout.getProperty("style:first-page-number")) != null && !sPageNumber.equals("continue")) {
                    ldp.append("  \\setcounter{page}{").append(Misc.getPosInteger(sPageNumber, 0)).append("}").nl();
                }
            }
            ldp.append("}").nl();
        }
        if (!this.config.useFancyhdr()) {
            ldp.append("\\makeatother").nl();
        }
    }

    private String getParAlignment(Node node) {
        String sStyleName;
        StyleWithProperties style;
        Element par;
        String sAlign = "L";
        if (node != null && (par = Misc.getChildByTagName(node, "text:p")) != null && (style = this.ofr.getParStyle(sStyleName = Misc.getAttribute(par, "text:style-name"))) != null) {
            String s = style.getProperty("fo:text-align");
            if ("center".equals(s)) {
                sAlign = "C";
            } else if ("end".equals(s)) {
                sAlign = "R";
            }
        }
        return sAlign;
    }

    private String getBorderWidth(PageLayout style, boolean bHeader) {
        String sBorder;
        if (style == null) {
            return "0pt";
        }
        if (bHeader) {
            sBorder = style.getHeaderProperty("fo:border-bottom");
            if (sBorder == null) {
                sBorder = style.getHeaderProperty("fo:border");
            }
        } else {
            sBorder = style.getFooterProperty("fo:border-top");
            if (sBorder == null) {
                sBorder = style.getFooterProperty("fo:border");
            }
        }
        if (sBorder != null && !sBorder.equals("none")) {
            return sBorder.substring(0, sBorder.indexOf(32));
        }
        return "0pt";
    }

    private void traverseHeaderFooter(Element node, LaTeXDocumentPortion ldp, Context context) {
        if (node == null) {
            return;
        }
        Element par = Misc.getChildByTagName(node, "text:p");
        if (par == null) {
            return;
        }
        String sStyleName = par.getAttribute("text:style-name");
        BeforeAfter ba = new BeforeAfter();
        StyleWithProperties style = this.ofr.getParStyle(sStyleName);
        if (!(style == null || this.ofr.isPackageFormat() && style.isAutomatic())) {
            this.palette.getCharSc().applyHardCharFormatting(style, ba);
        }
        if (par.hasChildNodes()) {
            ldp.append(ba.getBefore());
            this.palette.getInlineCv().traverseInlineText(par, ldp, context);
            ldp.append(ba.getAfter());
        }
    }

    private void convertPageMasterGeometry(LaTeXDocumentPortion pack, LaTeXDocumentPortion ldp) {
        String sWidth;
        String sHeight;
        String sAfter;
        if (this.config.pageFormatting() != 4 && this.config.pageFormatting() != 6) {
            return;
        }
        if (this.mainPageLayout == null) {
            return;
        }
        if ("mirrored".equals(this.mainPageLayout.getPageUsage())) {
            this.palette.addGlobalOption("twoside");
        }
        if (this.isTwocolumn()) {
            this.palette.addGlobalOption("twocolumn");
        }
        String sPaperHeight = this.mainPageLayout.getAbsoluteProperty("fo:page-height");
        String sPaperWidth = this.mainPageLayout.getAbsoluteProperty("fo:page-width");
        String sMarginTop = this.mainPageLayout.getAbsoluteProperty("fo:margin-top");
        String sMarginBottom = this.mainPageLayout.getAbsoluteProperty("fo:margin-bottom");
        String sMarginLeft = this.mainPageLayout.getAbsoluteProperty("fo:margin-left");
        String sMarginRight = this.mainPageLayout.getAbsoluteProperty("fo:margin-right");
        String sHeadHeight = "0cm";
        String sHeadSep = "0cm";
        String sFootHeight = "0cm";
        String sFootSep = "0cm";
        boolean bIncludeHead = false;
        boolean bIncludeFoot = false;
        Enumeration<OfficeStyle> masters = this.ofr.getMasterPages().getStylesEnumeration();
        while (masters.hasMoreElements()) {
            String sThisFootSep;
            PageLayout layout;
            MasterPage master = (MasterPage)masters.nextElement();
            if (!this.styleNames.containsName(this.getDisplayName(master.getName())) || (layout = this.ofr.getPageLayout(master.getPageLayoutName())) == null) continue;
            if (layout.hasHeaderStyle()) {
                String sThisHeadSep;
                String sThisHeadHeight = layout.getHeaderProperty("fo:min-height");
                if (sThisHeadHeight != null && Misc.isLessThan(sHeadHeight, sThisHeadHeight)) {
                    sHeadHeight = sThisHeadHeight;
                }
                if ((sThisHeadSep = layout.getHeaderProperty("fo:margin-bottom")) != null && Misc.isLessThan(sHeadSep, sThisHeadSep)) {
                    sHeadSep = sThisHeadSep;
                }
                bIncludeHead = true;
            }
            if (!layout.hasFooterStyle()) continue;
            String sThisFootHeight = layout.getFooterProperty("fo:min-height");
            if (sThisFootHeight != null && Misc.isLessThan(sFootHeight, sThisFootHeight)) {
                sFootHeight = sThisFootHeight;
            }
            if ((sThisFootSep = layout.getFooterProperty("fo:margin-top")) != null && Misc.isLessThan(sFootSep, sThisFootSep)) {
                sFootSep = sThisFootSep;
            }
            bIncludeFoot = true;
        }
        if (bIncludeHead && Misc.isLessThan(sHeadHeight, "12pt")) {
            sHeadHeight = "12pt";
        }
        if (bIncludeFoot && Misc.isLessThan(sFootHeight, "12pt")) {
            sFootHeight = "12pt";
        }
        String sFootSkip = Misc.add(sFootHeight, sFootSep);
        if (this.config.useGeometry()) {
            CSVList props = new CSVList(",");
            if (!this.standardPaperSize(sPaperWidth, sPaperHeight)) {
                props.addValue("paperwidth=" + sPaperWidth);
                props.addValue("paperheight=" + sPaperHeight);
            }
            props.addValue("top=" + sMarginTop);
            props.addValue("bottom=" + sMarginBottom);
            props.addValue("left=" + sMarginLeft);
            props.addValue("right=" + sMarginRight);
            if (bIncludeHead) {
                props.addValue("includehead");
                props.addValue("head=" + sHeadHeight);
                props.addValue("headsep=" + sHeadSep);
            } else {
                props.addValue("nohead");
            }
            if (bIncludeFoot) {
                props.addValue("includefoot");
                props.addValue("foot=" + sFootHeight);
                props.addValue("footskip=" + sFootSkip);
            } else {
                props.addValue("nofoot");
            }
            pack.append("\\usepackage[").append(props.toString()).append("]{geometry}").nl();
        } else {
            String sTextHeight = Misc.sub(sPaperHeight, sMarginTop);
            sTextHeight = Misc.sub(sTextHeight, sHeadHeight);
            sTextHeight = Misc.sub(sTextHeight, sHeadSep);
            sTextHeight = Misc.sub(sTextHeight, sFootSkip);
            sTextHeight = Misc.sub(sTextHeight, sMarginBottom);
            String sTextWidth = Misc.sub(sPaperWidth, sMarginLeft);
            sTextWidth = Misc.sub(sTextWidth, sMarginRight);
            ldp.append("% Page layout (geometry)").nl();
            if (!this.standardPaperSize(sPaperWidth, sPaperHeight)) {
                ldp.append("\\setlength\\paperwidth{").append(sPaperWidth).append("}").nl().append("\\setlength\\paperheight{").append(sPaperHeight).append("}").nl();
            }
            if (this.config.getBackend() == 2 && !this.config.useHyperref()) {
                ldp.append("\\setlength\\pdfpagewidth{").append(sPaperWidth).append("}").nl().append("\\setlength\\pdfpageheight{").append(sPaperHeight).append("}").nl();
            }
            ldp.append("\\setlength\\voffset{-1in}").nl().append("\\setlength\\hoffset{-1in}").nl();
            ldp.append("\\setlength\\topmargin{").append(sMarginTop).append("}").nl().append("\\setlength\\oddsidemargin{").append(sMarginLeft).append("}").nl();
            if ("mirrored".equals(this.mainPageLayout.getPageUsage())) {
                ldp.append("\\setlength\\evensidemargin{").append(sMarginRight).append("}").nl();
            }
            ldp.append("\\setlength\\textheight{").append(sTextHeight).append("}").nl();
            ldp.append("\\setlength\\textwidth{").append(sTextWidth).append("}").nl();
            ldp.append("\\setlength\\footskip{").append(sFootSkip).append("}").nl();
            ldp.append("\\setlength\\headheight{").append(sHeadHeight).append("}").nl();
            ldp.append("\\setlength\\headsep{").append(sHeadSep).append("}").nl();
        }
        String sAdjustment = this.mainPageLayout.getFootnoteProperty("style:adjustment");
        String sBefore = this.mainPageLayout.getFootnoteProperty("style:distance-before-sep");
        if (sBefore == null) {
            sBefore = "1mm";
        }
        if ((sAfter = this.mainPageLayout.getFootnoteProperty("style:distance-after-sep")) == null) {
            sAfter = "1mm";
        }
        if ((sHeight = this.mainPageLayout.getFootnoteProperty("style:width")) == null) {
            sHeight = "0.2mm";
        }
        if ((sWidth = this.mainPageLayout.getFootnoteProperty("style:rel-width")) == null) {
            sWidth = "25%";
        }
        sWidth = Float.toString(Misc.getFloat(sWidth.substring(0, sWidth.length() - 1), 1.0f) / 100.0f);
        BeforeAfter baColor = new BeforeAfter();
        String sColor = this.mainPageLayout.getFootnoteProperty("style:color");
        this.palette.getColorCv().applyColor(sColor, false, baColor, new Context());
        String sSkipFootins = Misc.add(sBefore, sHeight);
        ldp.append("% Footnote rule").nl().append("\\setlength{\\skip\\footins}{").append(sSkipFootins).append("}").nl().append("\\renewcommand\\footnoterule{\\vspace*{-").append(sHeight).append("}");
        if ("right".equals(sAdjustment)) {
            ldp.append("\\setlength\\leftskip{0pt plus 1fil}\\setlength\\rightskip{0pt}");
        } else if ("center".equals(sAdjustment)) {
            ldp.append("\\setlength\\leftskip{0pt plus 1fil}\\setlength\\rightskip{0pt plus 1fil}");
        } else {
            ldp.append("\\setlength\\leftskip{0pt}\\setlength\\rightskip{0pt plus 1fil}");
        }
        ldp.append("\\noindent").append(baColor.getBefore()).append("\\rule{").append(sWidth).append("\\columnwidth}{").append(sHeight).append("}").append(baColor.getAfter()).append("\\vspace*{").append(sAfter).append("}}").nl();
    }

    private boolean standardPaperSize(String sWidth, String sHeight) {
        if (this.standardPaperSize1(sWidth, sHeight)) {
            return true;
        }
        if (this.standardPaperSize1(sHeight, sWidth)) {
            this.palette.addGlobalOption("landscape");
            return true;
        }
        return false;
    }

    private boolean standardPaperSize1(String sWidth, String sHeight) {
        if (this.compare(sWidth, "210mm", "0.5mm") && this.compare(sHeight, "297mm", "0.5mm")) {
            this.palette.addGlobalOption("a4paper");
            return true;
        }
        if (this.compare(sWidth, "148mm", "0.5mm") && this.compare(sHeight, "210mm", "0.5mm")) {
            this.palette.addGlobalOption("a5paper");
            return true;
        }
        if (this.compare(sWidth, "176mm", "0.5mm") && this.compare(sHeight, "250mm", "0.5mm")) {
            this.palette.addGlobalOption("b5paper");
            return true;
        }
        if (this.compare(sWidth, "8.5in", "0.02in") && this.compare(sHeight, "11in", "0.02in")) {
            this.palette.addGlobalOption("letterpaper");
            return true;
        }
        if (this.compare(sWidth, "8.5in", "0.02in") && this.compare(sHeight, "14in", "0.02in")) {
            this.palette.addGlobalOption("legalpaper");
            return true;
        }
        if (this.compare(sWidth, "7.25in", "0.02in") && this.compare(sHeight, "10.5in", "0.02in")) {
            this.palette.addGlobalOption("executivepaper");
            return true;
        }
        return false;
    }

    private boolean compare(String sLength1, String sLength2, String sTolerance) {
        return Misc.isLessThan(Misc.abs(Misc.sub(sLength1, sLength2)), sTolerance);
    }

    private String getDisplayName(String sName) {
        String sDisplayName = this.ofr.getMasterPages().getDisplayName(sName);
        return sDisplayName != null ? sDisplayName : sName;
    }
}

