/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.util;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.batik.dom.util.DOMUtilitiesSupport;
import org.apache.batik.dom.util.HashTable;
import org.apache.batik.dom.util.SAXDocumentFactory;
import org.apache.batik.xml.XMLUtilities;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMUtilities
extends XMLUtilities {
    protected static final String[] LOCK_STRINGS = new String[]{"", "CapsLock", "NumLock", "NumLock CapsLock", "Scroll", "Scroll CapsLock", "Scroll NumLock", "Scroll NumLock CapsLock", "KanaMode", "KanaMode CapsLock", "KanaMode NumLock", "KanaMode NumLock CapsLock", "KanaMode Scroll", "KanaMode Scroll CapsLock", "KanaMode Scroll NumLock", "KanaMode Scroll NumLock CapsLock"};
    protected static final String[] MODIFIER_STRINGS = new String[]{"", "Shift", "Control", "Control Shift", "Meta", "Meta Shift", "Control Meta", "Control Meta Shift", "Alt", "Alt Shift", "Alt Control", "Alt Control Shift", "Alt Meta", "Alt Meta Shift", "Alt Control Meta", "Alt Control Meta Shift", "AltGraph", "AltGraph Shift", "AltGraph Control", "AltGraph Control Shift", "AltGraph Meta", "AltGraph Meta Shift", "AltGraph Control Meta", "AltGraph Control Meta Shift", "Alt AltGraph", "Alt AltGraph Shift", "Alt AltGraph Control", "Alt AltGraph Control Shift", "Alt AltGraph Meta", "Alt AltGraph Meta Shift", "Alt AltGraph Control Meta", "Alt AltGraph Control Meta Shift"};

    protected DOMUtilities() {
    }

    public static void writeDocument(Document document, Writer writer) throws IOException {
        for (Node node = document.getFirstChild(); node != null; node = node.getNextSibling()) {
            DOMUtilities.writeNode(node, writer);
        }
    }

    public static void writeNode(Node node, Writer writer) throws IOException {
        switch (node.getNodeType()) {
            case 1: {
                Object object;
                writer.write("<");
                writer.write(node.getNodeName());
                if (node.hasAttributes()) {
                    object = node.getAttributes();
                    int n = object.getLength();
                    for (int i = 0; i < n; ++i) {
                        Attr attr = (Attr)object.item(i);
                        writer.write(" ");
                        writer.write(attr.getNodeName());
                        writer.write("=\"");
                        writer.write(DOMUtilities.contentToString(attr.getNodeValue()));
                        writer.write("\"");
                    }
                }
                if ((object = node.getFirstChild()) != null) {
                    writer.write(">");
                    while (object != null) {
                        DOMUtilities.writeNode((Node)object, writer);
                        object = object.getNextSibling();
                    }
                    writer.write("</");
                    writer.write(node.getNodeName());
                    writer.write(">");
                    break;
                }
                writer.write("/>");
                break;
            }
            case 3: {
                writer.write(DOMUtilities.contentToString(node.getNodeValue()));
                break;
            }
            case 4: {
                writer.write("<![CDATA[");
                writer.write(node.getNodeValue());
                writer.write("]]>");
                break;
            }
            case 5: {
                writer.write("&");
                writer.write(node.getNodeName());
                writer.write(";");
                break;
            }
            case 7: {
                writer.write("<?");
                writer.write(node.getNodeName());
                writer.write(" ");
                writer.write(node.getNodeValue());
                writer.write("?>");
                break;
            }
            case 8: {
                writer.write("<!--");
                writer.write(node.getNodeValue());
                writer.write("-->");
                break;
            }
            case 10: {
                DocumentType documentType = (DocumentType)node;
                writer.write("<!DOCTYPE ");
                writer.write(node.getOwnerDocument().getDocumentElement().getNodeName());
                String string = documentType.getPublicId();
                if (string != null) {
                    writer.write(" PUBLIC \"" + documentType.getNodeName() + "\" \"" + string + "\">");
                    break;
                }
                String string2 = documentType.getSystemId();
                if (string2 == null) break;
                writer.write(" SYSTEM \"" + string2 + "\">");
                break;
            }
            default: {
                throw new IOException("Unknown DOM node type " + node.getNodeType());
            }
        }
    }

    public static String getXML(Node node) {
        StringWriter stringWriter = new StringWriter();
        try {
            DOMUtilities.writeNode(node, stringWriter);
            ((Writer)stringWriter).close();
        }
        catch (IOException iOException) {
            return "";
        }
        return ((Object)stringWriter).toString();
    }

    public static String contentToString(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block7;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    continue block7;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static int getChildIndex(Node node, Node node2) {
        if (node == null || node.getParentNode() != node2 || node.getParentNode() == null) {
            return -1;
        }
        return DOMUtilities.getChildIndex(node);
    }

    public static int getChildIndex(Node node) {
        NodeList nodeList = node.getParentNode().getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2 != node) continue;
            return i;
        }
        return -1;
    }

    public static boolean isAnyNodeAncestorOf(ArrayList arrayList, Node node) {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Node node2 = (Node)arrayList.get(i);
            if (!DOMUtilities.isAncestorOf(node2, node)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAncestorOf(Node node, Node node2) {
        if (node == null || node2 == null) {
            return false;
        }
        for (Node node3 = node2.getParentNode(); node3 != null; node3 = node3.getParentNode()) {
            if (node3 != node) continue;
            return true;
        }
        return false;
    }

    public static boolean isParentOf(Node node, Node node2) {
        return node != null && node2 != null && node.getParentNode() == node2;
    }

    public static boolean canAppend(Node node, Node node2) {
        return node != null && node2 != null && node != node2 && !DOMUtilities.isAncestorOf(node, node2);
    }

    public static boolean canAppendAny(ArrayList arrayList, Node node) {
        if (!DOMUtilities.canHaveChildren(node)) {
            return false;
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Node node2 = (Node)arrayList.get(i);
            if (!DOMUtilities.canAppend(node2, node)) continue;
            return true;
        }
        return false;
    }

    public static boolean canHaveChildren(Node node) {
        if (node == null) {
            return false;
        }
        switch (node.getNodeType()) {
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                return false;
            }
        }
        return true;
    }

    public static Node parseXML(String string, Document document, String string2, Map map, String string3, SAXDocumentFactory sAXDocumentFactory) {
        Object object;
        Object object2;
        Set set;
        String string4 = "";
        String string5 = "";
        if (string3 != null) {
            string4 = "<" + string3;
            if (map != null) {
                string4 = string4 + " ";
                set = map.keySet();
                for (Object object3 : set) {
                    object2 = (String)map.get(object3);
                    string4 = string4 + (String)object3 + "=\"" + (String)object2 + "\" ";
                }
            }
            string4 = string4 + ">";
            string5 = string5 + "</" + string3 + ">";
        }
        if (string4.trim().length() == 0 && string5.trim().length() == 0) {
            try {
                set = sAXDocumentFactory.createDocument(string2, new StringReader(string));
                if (document == null) {
                    return set;
                }
                object = document.createDocumentFragment();
                object.appendChild(document.importNode(set.getDocumentElement(), true));
                return object;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        set = new StringBuffer(string4.length() + string.length() + string5.length());
        ((StringBuffer)((Object)set)).append(string4);
        ((StringBuffer)((Object)set)).append(string);
        ((StringBuffer)((Object)set)).append(string5);
        object = ((StringBuffer)((Object)set)).toString();
        try {
            Object object3;
            object3 = sAXDocumentFactory.createDocument(string2, new StringReader((String)object));
            if (document == null) {
                return object3;
            }
            for (object2 = object3.getDocumentElement().getFirstChild(); object2 != null; object2 = object2.getNextSibling()) {
                if (object2.getNodeType() != 1) continue;
                object2 = document.importNode((Node)object2, true);
                DocumentFragment documentFragment = document.createDocumentFragment();
                documentFragment.appendChild((Node)object2);
                return documentFragment;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Document deepCloneDocument(Document document, DOMImplementation dOMImplementation) {
        Element element = document.getDocumentElement();
        Document document2 = dOMImplementation.createDocument(element.getNamespaceURI(), element.getNodeName(), null);
        Element element2 = document2.getDocumentElement();
        boolean bl = true;
        for (Node node = document.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == element) {
                Object object;
                bl = false;
                if (element.hasAttributes()) {
                    object = element.getAttributes();
                    int n = object.getLength();
                    for (int i = 0; i < n; ++i) {
                        element2.setAttributeNode((Attr)document2.importNode(object.item(i), true));
                    }
                }
                for (object = element.getFirstChild(); object != null; object = object.getNextSibling()) {
                    element2.appendChild(document2.importNode((Node)object, true));
                }
                continue;
            }
            if (node.getNodeType() == 10) continue;
            if (bl) {
                document2.insertBefore(document2.importNode(node, true), element2);
                continue;
            }
            document2.appendChild(document2.importNode(node, true));
        }
        return document2;
    }

    public static boolean isValidName(String string) {
        int n;
        int n2 = string.length();
        if (n2 == 0) {
            return false;
        }
        char c = string.charAt(0);
        int n3 = c / 32;
        if ((NAME_FIRST_CHARACTER[n3] & 1 << (n = c % 32)) == 0) {
            return false;
        }
        for (int i = 1; i < n2; ++i) {
            c = string.charAt(i);
            n3 = c / 32;
            if ((NAME_CHARACTER[n3] & 1 << (n = c % 32)) != 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidName11(String string) {
        int n;
        int n2 = string.length();
        if (n2 == 0) {
            return false;
        }
        char c = string.charAt(0);
        int n3 = c / 32;
        if ((NAME11_FIRST_CHARACTER[n3] & 1 << (n = c % 32)) == 0) {
            return false;
        }
        for (int i = 1; i < n2; ++i) {
            c = string.charAt(i);
            n3 = c / 32;
            if ((NAME11_CHARACTER[n3] & 1 << (n = c % 32)) != 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidPrefix(String string) {
        return string.indexOf(58) == -1;
    }

    public static String getPrefix(String string) {
        int n = string.indexOf(58);
        return n == -1 || n == string.length() - 1 ? null : string.substring(0, n);
    }

    public static String getLocalName(String string) {
        int n = string.indexOf(58);
        return n == -1 || n == string.length() - 1 ? string : string.substring(n + 1);
    }

    public static void parseStyleSheetPIData(String string, HashTable hashTable) {
        char c;
        int n;
        for (n = 0; n < string.length() && XMLUtilities.isXMLSpace(c = string.charAt(n)); ++n) {
        }
        while (n < string.length()) {
            int n2;
            c = string.charAt(n);
            int n3 = c / 32;
            if ((NAME_FIRST_CHARACTER[n3] & 1 << (n2 = c % 32)) == 0) {
                throw new DOMException(5, "Wrong name initial:  " + c);
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(c);
            while (++n < string.length() && (NAME_CHARACTER[n3 = (c = string.charAt(n)) / 32] & 1 << (n2 = c % 32)) != 0) {
                stringBuffer.append(c);
            }
            if (n >= string.length()) {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + string);
            }
            while (n < string.length() && XMLUtilities.isXMLSpace(c = string.charAt(n))) {
                ++n;
            }
            if (n >= string.length()) {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + string);
            }
            if (string.charAt(n) != '=') {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + string);
            }
            ++n;
            while (n < string.length() && XMLUtilities.isXMLSpace(c = string.charAt(n))) {
                ++n;
            }
            if (n >= string.length()) {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + string);
            }
            c = string.charAt(n);
            ++n;
            StringBuffer stringBuffer2 = new StringBuffer();
            if (c == '\'') {
                while (n < string.length() && (c = string.charAt(n)) != '\'') {
                    stringBuffer2.append(c);
                    ++n;
                }
                if (n >= string.length()) {
                    throw new DOMException(12, "Wrong xml-stylesheet data: " + string);
                }
            } else if (c == '\"') {
                while (n < string.length() && (c = string.charAt(n)) != '\"') {
                    stringBuffer2.append(c);
                    ++n;
                }
                if (n >= string.length()) {
                    throw new DOMException(12, "Wrong xml-stylesheet data: " + string);
                }
            } else {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + string);
            }
            hashTable.put(stringBuffer.toString().intern(), stringBuffer2.toString());
            ++n;
            while (n < string.length() && XMLUtilities.isXMLSpace(c = string.charAt(n))) {
                ++n;
            }
        }
    }

    public static String getModifiersList(int n, int n2) {
        return DOMUtilitiesSupport.getModifiersList(n, n2);
    }
}

