/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.ui.HgRepositorySelectorComponent;
import org.zmlx.hg4idea.util.HgBranchReferenceValidator;

public class HgTagDialog
extends DialogWrapper {
    private JPanel contentPanel;
    private JTextField tagTxt;
    private HgRepositorySelectorComponent hgRepositorySelectorComponent;

    public HgTagDialog(@NotNull Project project, @NotNull Collection<HgRepository> repositories, @Nullable HgRepository selectedRepo) {
        if (project == null) {
            HgTagDialog.$$$reportNull$$$0(0);
        }
        if (repositories == null) {
            HgTagDialog.$$$reportNull$$$0(1);
        }
        super(project, false);
        this.$$$setupUI$$$();
        this.hgRepositorySelectorComponent.setTitle("Select repository to tag");
        DocumentAdapter documentListener = new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                HgTagDialog.this.validateFields();
            }
        };
        this.tagTxt.getDocument().addDocumentListener((DocumentListener)documentListener);
        this.setTitle("Tag");
        this.init();
        this.setRoots(repositories, selectedRepo);
    }

    public String getTagName() {
        return this.tagTxt.getText();
    }

    public VirtualFile getRepository() {
        return this.hgRepositorySelectorComponent.getRepository().getRoot();
    }

    private void setRoots(@NotNull Collection<HgRepository> repositories, @Nullable HgRepository selectedRepo) {
        if (repositories == null) {
            HgTagDialog.$$$reportNull$$$0(2);
        }
        this.hgRepositorySelectorComponent.setRoots(repositories);
        this.hgRepositorySelectorComponent.setSelectedRoot(selectedRepo);
    }

    protected JComponent createCenterPanel() {
        return this.contentPanel;
    }

    private void validateFields() {
        String name;
        HgBranchReferenceValidator validator = new HgBranchReferenceValidator(this.hgRepositorySelectorComponent.getRepository());
        if (!validator.checkInput(name = this.getTagName())) {
            String message = validator.getErrorText(name);
            this.setErrorText(message == null ? "You have to specify tag name." : message, this.tagTxt);
            this.setOKActionEnabled(false);
            return;
        }
        this.setErrorText(null);
        this.setOKActionEnabled(true);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.tagTxt;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
        }
        objectArray2[1] = "org/zmlx/hg4idea/ui/HgTagDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setRoots";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        HgRepositorySelectorComponent hgRepositorySelectorComponent;
        JPanel jPanel;
        this.contentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.hgRepositorySelectorComponent = hgRepositorySelectorComponent = new HgRepositorySelectorComponent();
        JComponent jComponent = hgRepositorySelectorComponent.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Tag name:");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.tagTxt = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(1, 0, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPanel;
    }
}

