/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.EditorFactoryAdapter;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import java.util.List;
import org.editorconfig.Utils;
import org.editorconfig.core.EditorConfig;
import org.editorconfig.plugincomponents.SettingsProviderComponent;
import org.jetbrains.annotations.NotNull;

public class EditorSettingsManager
extends EditorFactoryAdapter {
    public static final String maxLineLengthKey = "max_line_length";
    private Project myProject;

    public EditorSettingsManager(Project project) {
        this.myProject = project;
    }

    public void editorCreated(@NotNull EditorFactoryEvent event) {
        if (event == null) {
            EditorSettingsManager.$$$reportNull$$$0(0);
        }
        this.applyEditorSettings(event.getEditor());
    }

    public void applyEditorSettings(Editor editor) {
        Document document = editor.getDocument();
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        if (file == null) {
            return;
        }
        if (!Utils.isEnabled(CodeStyleSettingsManager.getInstance((Project)this.myProject).getCurrentSettings())) {
            return;
        }
        List<EditorConfig.OutPair> outPairs = SettingsProviderComponent.getInstance().getOutPairs(this.myProject, file);
        String maxLineLength = Utils.configValueForKey(outPairs, maxLineLengthKey);
        this.applyMaxLineLength(maxLineLength, editor, file);
    }

    private void applyMaxLineLength(String maxLineLength, Editor editor, VirtualFile file) {
        if (maxLineLength.isEmpty()) {
            return;
        }
        if ("off".equals(maxLineLength)) {
            editor.getSettings().setRightMarginShown(false);
            return;
        }
        try {
            int length = Integer.parseInt(maxLineLength);
            if (length < 0) {
                Utils.invalidConfigMessage(this.myProject, maxLineLength, maxLineLengthKey, file.getCanonicalPath());
                return;
            }
            editor.getSettings().setRightMarginShown(true);
            editor.getSettings().setRightMargin(length);
        }
        catch (NumberFormatException e) {
            Utils.invalidConfigMessage(this.myProject, maxLineLength, maxLineLengthKey, file.getCanonicalPath());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/editorconfig/configmanagement/EditorSettingsManager", "editorCreated"));
    }
}

