/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.dateOrRevision;

import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.config.DateOrRevisionSettings;
import com.intellij.cvsSupport2.cvsoperations.dateOrRevision.RevisionOrDate;
import com.intellij.cvsSupport2.history.CvsRevisionNumber;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import java.text.ParseException;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.Command;

public class RevisionOrDateImpl
implements RevisionOrDate {
    private static final Logger LOG = Logger.getInstance(RevisionOrDateImpl.class);
    @Nullable
    private String myStickyTag;
    @Nullable
    private Date myStickyDate;

    public static RevisionOrDate createOn(@NotNull VirtualFile file) {
        if (file == null) {
            RevisionOrDateImpl.$$$reportNull$$$0(0);
        }
        VirtualFile parent = file.getParent();
        return new RevisionOrDateImpl(parent, CvsEntriesManager.getInstance().getEntryFor(parent, file.getName()));
    }

    public static RevisionOrDate createOn(VirtualFile parent, String name) {
        return new RevisionOrDateImpl(parent, CvsEntriesManager.getInstance().getEntryFor(parent, name));
    }

    public static RevisionOrDate createOn(VirtualFile parent, Entry entry, DateOrRevisionSettings config) {
        RevisionOrDateImpl result = new RevisionOrDateImpl(parent, entry);
        RevisionOrDateImpl.updateOn(result, config);
        return result;
    }

    private static void updateOn(RevisionOrDateImpl result, DateOrRevisionSettings config) {
        String stickyTagFromConfig = config.USE_BRANCH ? config.BRANCH : null;
        String stickyDateFromConfig = config.USE_DATE ? config.getDate() : null;
        result.setStickyInfo(stickyTagFromConfig, stickyDateFromConfig);
    }

    @NotNull
    public static RevisionOrDate createOn(DateOrRevisionSettings config) {
        RevisionOrDateImpl result = new RevisionOrDateImpl();
        RevisionOrDateImpl.updateOn(result, config);
        RevisionOrDateImpl revisionOrDateImpl = result;
        if (revisionOrDateImpl == null) {
            RevisionOrDateImpl.$$$reportNull$$$0(1);
        }
        return revisionOrDateImpl;
    }

    private RevisionOrDateImpl() {
    }

    private RevisionOrDateImpl(VirtualFile parent, Entry entry) {
        if (entry == null) {
            this.lookupDirectory(parent);
        } else if (entry.getStickyRevision() != null) {
            this.myStickyTag = entry.getStickyRevision();
        } else if (entry.getStickyTag() != null) {
            this.myStickyTag = entry.getStickyTag();
        } else if (entry.getStickyDateString() != null) {
            this.myStickyDate = entry.getStickyDate();
        } else {
            this.lookupDirectory(parent);
        }
    }

    private void setStickyInfo(String stickyTag, String stickyDate) {
        if (stickyTag == null && stickyDate == null) {
            return;
        }
        if (stickyTag != null) {
            this.myStickyDate = null;
            this.myStickyTag = stickyTag;
        } else {
            this.myStickyTag = null;
            try {
                this.myStickyDate = Entry.getLastModifiedDateFormatter().parse(stickyDate);
            }
            catch (ParseException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public void setForCommand(Command command) {
        command.setUpdateByRevisionOrDate(this.myStickyTag, this.myStickyDate == null ? null : Entry.getLastModifiedDateFormatter().format(this.myStickyDate));
    }

    private void lookupDirectory(VirtualFile directory) {
        String stickyTag = CvsUtil.getStickyTagForDirectory(directory);
        if (stickyTag != null) {
            this.myStickyTag = stickyTag;
            return;
        }
        try {
            String stickyDateString = CvsUtil.getStickyDateForDirectory(directory);
            if (stickyDateString != null) {
                this.myStickyDate = Entry.STICKY_DATE_FORMAT.parse(stickyDateString);
            }
        }
        catch (ParseException e) {
            LOG.error((Throwable)e);
        }
    }

    public String getRevision() {
        if (this.myStickyTag == null) {
            return "HEAD";
        }
        return this.myStickyTag;
    }

    public CvsRevisionNumber getCvsRevisionNumber() {
        if (this.myStickyTag == null) {
            return null;
        }
        try {
            return new CvsRevisionNumber(this.myStickyTag);
        }
        catch (NumberFormatException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public String toString() {
        if (this.myStickyDate != null) {
            return Entry.getLastModifiedDateFormatter().format(this.myStickyDate);
        }
        return this.myStickyTag;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cvsSupport2/cvsoperations/dateOrRevision/RevisionOrDateImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cvsSupport2/cvsoperations/dateOrRevision/RevisionOrDateImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createOn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createOn";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

