/*
 * Decompiled with CFR 0.152.
 */
package org.markdown4j;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.markdown4j.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncludePlugin
extends Plugin {
    public static final String DEFAULT_CHARSET = System.getProperty("file.encoding");

    public IncludePlugin() {
        super("include");
    }

    @Override
    public void emit(StringBuilder out, List<String> lines, Map<String, String> params) {
        String src = params.get("src");
        try {
            String content2 = this.getContent(src);
            if (content2 != null) {
                out.append(content2);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error while rendering " + this.getClass().getName(), e);
        }
    }

    private String getContent(String src) throws IOException, URISyntaxException {
        URL url = new URL(new URL("file:"), src);
        URLConnection urlc = url.openConnection();
        String charset = IncludePlugin.getCharsetFromContentTypeString(urlc.getHeaderField("Content-Type"));
        if (charset == null) {
            charset = IncludePlugin.getCharsetFromContent(url);
        }
        if (charset == null) {
            charset = DEFAULT_CHARSET;
        }
        System.err.println(charset);
        urlc.connect();
        InputStream is = urlc.getInputStream();
        InputStreamReader isr = new InputStreamReader(is, charset);
        BufferedReader br = new BufferedReader(isr);
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        String line = null;
        while ((line = br.readLine()) != null) {
            bw.write(line);
            bw.newLine();
        }
        br.close();
        bw.close();
        return sw.toString();
    }

    public static String getCharsetFromContentTypeString(String contentType) {
        String charset;
        String pattern;
        Matcher matcher;
        if (contentType != null && (matcher = Pattern.compile(pattern = "charset=([a-z\\d\\-]*)", 2).matcher(contentType)).find() && Charset.isSupported(charset = matcher.group(1))) {
            return charset;
        }
        return null;
    }

    public static String getCharsetFromContent(URL url) throws IOException {
        byte[] chunk;
        InputStream stream = url.openStream();
        int bytesRead = stream.read(chunk = new byte[2048]);
        if (bytesRead > 0) {
            String charset;
            String startContent = new String(chunk);
            String pattern = "\\<meta\\s*http-equiv=[\\\"\\']content-type[\\\"\\']\\s*content\\s*=\\s*[\"']text/html\\s*;\\s*charset=([a-z\\d\\-]*)[\\\"\\'\\>]";
            Matcher matcher = Pattern.compile(pattern, 2).matcher(startContent);
            if (matcher.find() && Charset.isSupported(charset = matcher.group(1))) {
                return charset;
            }
        }
        return null;
    }
}

