/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.SmartHashSet;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogFileOptions
implements JDOMExternalizable {
    @NonNls
    private static final String PATH = "path";
    @NonNls
    private static final String CHECKED = "checked";
    @NonNls
    private static final String ALIAS = "alias";
    @NonNls
    private static final String SKIPPED = "skipped";
    @NonNls
    private static final String SHOW_ALL = "show_all";
    @NonNls
    private static final String CHARSET = "charset";
    private String myName;
    private String myPathPattern;
    private boolean myEnabled;
    private boolean mySkipContent;
    private boolean myShowAll;
    @NotNull
    private Charset myCharset;

    public LogFileOptions() {
    }

    public LogFileOptions(String name, String path2, boolean enabled, boolean skipContent, boolean showAll) {
        this(name, path2, null, enabled, skipContent, showAll);
    }

    public LogFileOptions(String name, String path2, @Nullable Charset charset, boolean enabled, boolean skipContent, boolean showAll) {
        this.myName = name;
        this.myPathPattern = path2;
        this.myEnabled = enabled;
        this.mySkipContent = skipContent;
        this.myShowAll = showAll;
        this.myCharset = charset != null ? charset : Charset.defaultCharset();
    }

    public String getName() {
        return this.myName;
    }

    public String getPathPattern() {
        return this.myPathPattern;
    }

    @NotNull
    public Set<String> getPaths() {
        File logFile = new File(this.myPathPattern);
        if (logFile.exists()) {
            Set<String> set = Collections.singleton(this.myPathPattern);
            if (set == null) {
                LogFileOptions.$$$reportNull$$$0(0);
            }
            return set;
        }
        int dirIndex = this.myPathPattern.lastIndexOf(File.separator);
        if (dirIndex == -1) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                LogFileOptions.$$$reportNull$$$0(1);
            }
            return set;
        }
        SmartList files = new SmartList();
        LogFileOptions.collectMatchedFiles(new File(this.myPathPattern.substring(0, dirIndex)), Pattern.compile(FileUtil.convertAntToRegexp((String)this.myPathPattern.substring(dirIndex + File.separator.length()))), (List<File>)files);
        if (files.isEmpty()) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                LogFileOptions.$$$reportNull$$$0(2);
            }
            return set;
        }
        if (this.myShowAll) {
            SmartHashSet result = new SmartHashSet();
            result.ensureCapacity(files.size());
            for (File file : files) {
                result.add((Object)file.getPath());
            }
            SmartHashSet smartHashSet = result;
            if (smartHashSet == null) {
                LogFileOptions.$$$reportNull$$$0(3);
            }
            return smartHashSet;
        }
        File lastFile = null;
        for (File file : files) {
            if (lastFile != null) {
                if (file.lastModified() <= lastFile.lastModified()) continue;
                lastFile = file;
                continue;
            }
            lastFile = file;
        }
        assert (lastFile != null);
        Set<String> set = Collections.singleton(lastFile.getPath());
        if (set == null) {
            LogFileOptions.$$$reportNull$$$0(4);
        }
        return set;
    }

    public static void collectMatchedFiles(@NotNull File root, @NotNull Pattern pattern, @NotNull List<File> files) {
        File[] dirs;
        if (root == null) {
            LogFileOptions.$$$reportNull$$$0(5);
        }
        if (pattern == null) {
            LogFileOptions.$$$reportNull$$$0(6);
        }
        if (files == null) {
            LogFileOptions.$$$reportNull$$$0(7);
        }
        if ((dirs = root.listFiles()) == null) {
            return;
        }
        for (File dir : dirs) {
            if (!pattern.matcher(dir.getName()).matches() || !dir.isFile()) continue;
            files.add(dir);
        }
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public boolean isSkipContent() {
        return this.mySkipContent;
    }

    public void setEnable(boolean enable) {
        this.myEnabled = enable;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public void setPathPattern(String pathPattern) {
        this.myPathPattern = pathPattern;
    }

    public void setSkipContent(boolean skipContent) {
        this.mySkipContent = skipContent;
    }

    public void setShowAll(boolean showAll) {
        this.myShowAll = showAll;
    }

    public void setLast(boolean last) {
        this.myShowAll = !last;
    }

    public boolean isShowAll() {
        return this.myShowAll;
    }

    public Charset getCharset() {
        return this.myCharset;
    }

    public void setCharset(Charset charset) {
        this.myCharset = charset;
    }

    public void readExternal(Element element) throws InvalidDataException {
        String file = element.getAttributeValue(PATH);
        if (file != null) {
            file = FileUtil.toSystemDependentName((String)file);
        }
        this.setPathPattern(file);
        Boolean checked = Boolean.valueOf(element.getAttributeValue(CHECKED));
        this.setEnable(checked);
        String skipped = element.getAttributeValue(SKIPPED);
        Boolean skip = skipped != null ? Boolean.valueOf(skipped) : Boolean.TRUE;
        this.setSkipContent(skip);
        String all2 = element.getAttributeValue(SHOW_ALL);
        Boolean showAll = skipped != null ? Boolean.valueOf(all2) : Boolean.TRUE;
        this.setShowAll(showAll);
        this.setName(element.getAttributeValue(ALIAS));
        String charsetStr = element.getAttributeValue(CHARSET);
        try {
            this.setCharset(Charset.forName(charsetStr));
        }
        catch (Exception ignored) {
            this.setCharset(Charset.defaultCharset());
        }
    }

    public void writeExternal(Element element) {
        element.setAttribute(PATH, FileUtil.toSystemIndependentName((String)this.getPathPattern()));
        element.setAttribute(CHECKED, String.valueOf(this.isEnabled()));
        element.setAttribute(SKIPPED, String.valueOf(this.isSkipContent()));
        element.setAttribute(SHOW_ALL, String.valueOf(this.isShowAll()));
        element.setAttribute(ALIAS, this.getName());
        if (!this.getCharset().equals(Charset.defaultCharset())) {
            element.setAttribute(CHARSET, this.getCharset().name());
        }
    }

    public static boolean areEqual(@Nullable LogFileOptions options1, @Nullable LogFileOptions options2) {
        if (options1 == null || options2 == null) {
            return options1 == options2;
        }
        return options1.myName.equals(options2.myName) && options1.myPathPattern.equals(options2.myPathPattern) && !options1.myShowAll == !options2.myShowAll && options1.myEnabled == options2.myEnabled && options1.mySkipContent == options2.mySkipContent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configurations/LogFileOptions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPaths";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configurations/LogFileOptions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectMatchedFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

