/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.switcher;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.switcher.QuickActionProvider;
import com.intellij.util.ObjectUtils;
import java.awt.Container;
import java.util.List;
import javax.swing.JComponent;

public class ShowQuickActionPopupAction
extends AnAction {
    @Override
    public void update(AnActionEvent e) {
        QuickActionProvider quickActionProvider = e.getData(QuickActionProvider.KEY);
        if (quickActionProvider == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        List<AnAction> actions = quickActionProvider.getActions(true);
        e.getPresentation().setEnabled(!actions.isEmpty());
    }

    @Override
    public void actionPerformed(AnActionEvent e) {
        QuickActionProvider provider = e.getRequiredData(QuickActionProvider.KEY);
        List<AnAction> actions = provider.getActions(true);
        DefaultActionGroup group = new DefaultActionGroup(actions);
        group.addSeparator();
        JComponent component = provider.getComponent();
        if (component != null && !provider.isCycleRoot()) {
            for (Container eachParent = component.getParent(); eachParent != null; eachParent = eachParent.getParent()) {
                QuickActionProvider parentProvider = (QuickActionProvider)ObjectUtils.tryCast((Object)eachParent, QuickActionProvider.class);
                if (parentProvider == null) continue;
                List<AnAction> parentActions = parentProvider.getActions(false);
                if (!parentActions.isEmpty()) {
                    String name = StringUtil.notNullize((String)parentProvider.getName(), (String)"");
                    DefaultActionGroup parentGroup = new DefaultActionGroup(name, parentActions);
                    if (!StringUtil.isEmpty((String)name)) {
                        parentGroup.setPopup(true);
                    } else {
                        group.add(Separator.getInstance());
                    }
                    group.add(parentGroup);
                }
                if (parentProvider.isCycleRoot()) break;
            }
        }
        JBPopupFactory.getInstance().createActionGroupPopup(null, group, e.getDataContext(), JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING, true).showInBestPositionFor(e.getDataContext());
    }
}

